/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.auditing;

public enum TimeFilterUnits {
    MINUTES("min"),
    HOURS("hrs"),
    DAYS("day"),
    WEEKS("week");

    public final String key;

    private TimeFilterUnits(String key) {
        this.key = key;
    }

    public Long getMillisecondsWithinLast(long timeUnitValue) {
        if (this.equals((Object)MINUTES)) {
            return 60L * timeUnitValue * 1000L;
        }
        if (this.equals((Object)HOURS)) {
            return 3600L * timeUnitValue * 1000L;
        }
        if (this.equals((Object)DAYS)) {
            return 86400L * timeUnitValue * 1000L;
        }
        if (this.equals((Object)WEEKS)) {
            return 604800L * timeUnitValue * 1000L;
        }
        return 0L;
    }

    public static TimeFilterUnits getInstanceOf(String timeUnit) {
        if (TimeFilterUnits.MINUTES.key.equals(timeUnit)) {
            return MINUTES;
        }
        if (TimeFilterUnits.HOURS.key.equals(timeUnit)) {
            return HOURS;
        }
        if (TimeFilterUnits.DAYS.key.equals(timeUnit)) {
            return DAYS;
        }
        if (TimeFilterUnits.WEEKS.key.equals(timeUnit)) {
            return WEEKS;
        }
        throw new IllegalArgumentException("Time unit $timeUnit is not supported");
    }
}

