/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.adminupdates.conditions;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.ClusterMessageConsumer;
import com.atlassian.jira.cluster.ClusterMessagingService;
import com.atlassian.jira.cluster.zdu.ClusterStateManager;
import com.atlassian.jira.cluster.zdu.ClusterUpgradeStateManager;
import com.atlassian.jira.cluster.zdu.JiraUpgradeCancelledEvent;
import com.atlassian.jira.cluster.zdu.JiraUpgradeFinishedEvent;
import com.atlassian.jira.cluster.zdu.JiraUpgradeStartedEvent;
import com.atlassian.jira.cluster.zdu.UpgradeState;
import com.atlassian.jira.plugin.webfragment.conditions.AbstractWebCondition;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class IsUpgradeInProgressCondition
extends AbstractWebCondition
implements InitializingBean,
DisposableBean {
    private final ClusterStateManager clusterStateManager;
    private final EventPublisher eventPublisher;
    private final ClusterMessagingService clusterMessagingService;
    private boolean upgradeActive = false;
    private final ClusterMessageConsumer clusterMessageConsumer = (channel, message, senderId) -> this.updateUpgradeActiveState();

    @Inject
    public IsUpgradeInProgressCondition(@ComponentImport ClusterUpgradeStateManager clusterStateManager, @ComponentImport EventPublisher eventPublisher, @ComponentImport ClusterMessagingService clusterMessagingService) {
        this.clusterStateManager = clusterStateManager;
        this.eventPublisher = eventPublisher;
        this.clusterMessagingService = clusterMessagingService;
    }

    public void init(Map<String, String> params) throws PluginParseException {
        this.updateUpgradeActiveState();
    }

    public boolean shouldDisplay(ApplicationUser applicationUser, JiraHelper jiraHelper) {
        return this.upgradeActive;
    }

    @EventListener
    public void onUpgradeStarted(JiraUpgradeStartedEvent event) {
        this.upgradeActive = true;
    }

    @EventListener
    public void onUpgradeFinished(JiraUpgradeFinishedEvent event) {
        this.upgradeActive = false;
    }

    @PluginEventListener
    public void onUpgradeCancelled(JiraUpgradeCancelledEvent event) {
        this.upgradeActive = false;
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
        this.clusterMessagingService.unregisterListener(this.clusterMessageConsumer);
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
        this.clusterMessagingService.registerListener("Upgrade State", this.clusterMessageConsumer);
    }

    private void updateUpgradeActiveState() {
        this.upgradeActive = this.clusterStateManager.getUpgradeState() != UpgradeState.STABLE;
    }
}

