AJS.test.require(["com.atlassian.jira.jira-project-config-plugin:edit-workflow-scheme"],function(){var s=require("underscore");var d=require("jira-project-config/backbone");var u=require("jira-project-config/workflows/scheme/editor/controller");var a=require("jira/jquery/deferred");var j=require("jira/util/events");var r=require("jira-project-config/workflows/scheme/editor/models/issue-type-collection");var h=require("jquery");var o=require("jira/message");var i=require("jira-project-config/workflows/scheme/editor/views/page");var g=require("jira/util/events/reasons");var p=require("jira/ajs/ajax/smart-ajax");var t=require("jira/ajs/ajax/smart-ajax/web-sudo");var l=require("jira-project-config/templates/messages");var c=require("jira-project-config/workflows/scheme/editor/templates");var m=require("jira/util/events/types");var f=require("jira-project-config/workflows/scheme/editor/models/workflow-collection");var b=require("jira-project-config/workflows/scheme/editor/models/workflow");var n=require("jira-project-config/workflows/scheme/editor/views/workflow-scheme-header");var q=require("jira-project-config/workflows/scheme/editor/models/workflow-scheme");var k=require("jira-project-config/workflows/scheme/editor/views/workflow-scheme");var e=require("jira-project-config/workflows/scheme/editor/views/workflow");module("JIRA.Workflows.Scheme.Editor.Controller - Tests",{teardown:function(){this.sandbox.restore()},setup:function(){this.sandbox=sinon.sandbox.create();this.bus=s.clone(d.Events)}});test("Controller.load no scheme",function(){var w=this.sandbox.stub(p,"makeWebSudoRequest");var y=this;var x=function(){this.renderError=y.sandbox.spy()};var v=new u({pageView:x,model:h.noop,issueTypeModel:h.noop,viewEventBus:this.bus});v.load();ok(v.page.renderError.calledOnce,"Render error called");ok(!w.called,"Never made ajax request.")});test("Controller.load good load",function(){var x=this.sandbox.stub(t,"makeWebSudoRequest");var B=this;var A=function(){this.renderModel=B.sandbox.spy()};var z=function(){this.load=B.sandbox.spy();this.workflows={on:B.sandbox.spy()}};var v=new u({pageView:A,model:z,issueTypeModel:z,schemeId:101010,url:"test",viewEventBus:this.bus});var y=new a();x.withArgs({url:"test101010",dataType:"json"}).returns(y.promise());v.load();ok(x.calledOnce,"Never made ajax request.");var w={issueTypes:{issueTypes:"test"},a:"c",description:""};y.resolveWith(window,[w]);ok(v.issueTypes.load.calledWithExactly(w.issueTypes),"Called with correct issueTypes data.");ok(v.model.load.calledWithExactly(w),"Called with correct scheme data.");ok(v.page.renderModel.calledWithExactly(v.model,v.issueTypes))});test("Controller.load bad load",function(){var z=this.sandbox.stub(t,"makeWebSudoRequest");var w=this.sandbox.stub(JIRA.Workflows.Scheme.Common,"smartAjaxErrorHandler");var C=this;var B=function(){this.renderError=C.sandbox.spy()};var v=new u({pageView:B,model:h.noop,issueTypeModel:h.noop,schemeId:101010,url:"test",viewEventBus:this.bus});var A=new a();z.withArgs({url:"test101010",dataType:"json"}).returns(A.promise());v.load();ok(z.calledOnce,"Never made ajax request.");A.rejectWith(window,[]);ok(w.calledOnce);var y=w.args[0][0];ok(!v.page.renderError.called);var x="With error String";y(x);ok(v.page.renderError.calledOnce);ok(v.page.renderError.calledWithExactly(x))});test("Controller removeIssueType",function(){var y=this;var w=new u({pageView:h.noop,model:function(){this.removeIssueType=y.sandbox.spy()},issueTypeModel:h.noop,viewEventBus:this.bus,url:"/test/",schemeId:10101});w.ajax=this.sandbox.spy();var x="workflow";var v=1;w.removeIssueType(x,v);ok(w.model.removeIssueType.calledWith(x,v));ok(w.ajax.calledWith({url:w.resourceUrl()+"/issuetype",type:"DELETE",contentType:"application/json",data:JSON.stringify({issueTypes:[v],workflow:x})}))});test("Controller removeWorkflow",function(){var y=this;var v=new u({pageView:h.noop,model:function(){this.removeWorkflow=y.sandbox.stub()},issueTypeModel:h.noop,viewEventBus:this.bus,url:"/url/",schemeId:100});var x="nextDefault";var w="name";v.ajax=this.sandbox.spy();v.model.removeWorkflow.returns(x);v.removeWorkflow(w);ok(v.model.removeWorkflow.calledWith(w));ok(v.ajax.calledWith({url:v.resourceUrl()+"/workflow",type:"DELETE",contentType:"application/json",data:JSON.stringify({workflow:w,nextDefaultWorkflow:x})}))});test("Controller assignIssueTypes",function(){var z=this;var v=new u({pageView:h.noop,model:function(){this.assignIssueTypes=z.sandbox.spy()},issueTypeModel:h.noop,viewEventBus:this.bus,url:"/url/",schemeId:100});var w="name";var x=["1","2"];var y=false;v.ajax=this.sandbox.spy();v.assignIssueTypes(w,x,y);ok(v.model.assignIssueTypes.calledWith(w,x,y));ok(v.ajax.calledWith({url:v.resourceUrl(),type:"PUT",contentType:"application/json",data:JSON.stringify({workflow:w,issueTypes:x,defaultWorkflow:y})}))});test("Controller addWorkflow",function(){var x=this;var w=new u({pageView:h.noop,model:function(){this.addWorkflow=x.sandbox.spy()},issueTypeModel:h.noop,viewEventBus:this.bus,url:"/url/",schemeId:100});var v={name:"name","default":true,issueTypes:[]};w.ajax=this.sandbox.spy();w.addWorkflow(v);ok(w.model.addWorkflow.calledWith(v));ok(w.ajax.calledWith({url:w.resourceUrl(),type:"PUT",contentType:"application/json",data:JSON.stringify({workflow:v.name,issueTypes:v.issueTypes,defaultWorkflow:v["default"]})}))});test("Controller discardDraft",function(){var w=this;var v=new u({pageView:h.noop,model:function(){this.discardDraft=w.sandbox.spy()},issueTypeModel:h.noop,viewEventBus:this.bus,url:"/url/",schemeId:100});v.ajax=this.sandbox.spy();v.discardDraft();ok(v.model.discardDraft.calledWith());ok(v.ajax.calledWith({url:v.resourceUrl()+"/draft",type:"DELETE",contentType:"application/json"}))});test("Controller loadModel",function(){var z=this;var y=function(){this.load=z.sandbox.stub()};var w=function(){this.load=z.sandbox.stub()};var v=new u({pageView:h.noop,model:y,issueTypeModel:w,viewEventBus:{on:h.noop}});var x={issueTypes:"something",description:""};v.model.load.returns(true);v.issueTypes.load.returns(true);ok(v.loadModel(x));ok(v.model.load.calledWithExactly(x));ok(v.issueTypes.load.calledWithExactly(x.issueTypes));v.model.load.returns(true);v.issueTypes.load.returns(false);ok(v.loadModel(x));v.model.load.returns(false);v.issueTypes.load.returns(true);ok(v.loadModel(x));v.model.load.returns(false);v.issueTypes.load.returns(false);ok(!v.loadModel(x))});test("Controller ajax success no change",function(){var w=new a();var x=this.sandbox.stub(t,"makeWebSudoRequest");var y=this.sandbox.stub(o,"showWarningMsg");x.returns(w.promise());var z=this;var v=new u({pageView:function(){this.setLoading=h.noop;this.renderModel=z.sandbox.spy()},model:function(){this.setDraft=z.sandbox.spy()},issueTypeModel:h.noop,viewEventBus:{on:h.noop}});v.loadModel=this.sandbox.stub();v.loadModel.returns(false);ok(v.ajax());ok(x.called);w.resolveWith(undefined,[{}]);ok(!y.called);ok(!v.page.renderModel.called);ok(!v.model.setDraft.called)});test("Controller ajax success change",function(){var w=new a();var x=this.sandbox.stub(t,"makeWebSudoRequest");var y=this.sandbox.stub(o,"showWarningMsg");x.returns(w.promise());var z=this;var v=new u({pageView:function(){this.setLoading=h.noop;this.renderModel=z.sandbox.spy()},model:function(){this.setDraft=z.sandbox.spy()},issueTypeModel:h.noop,viewEventBus:{on:h.noop}});v.loadModel=this.sandbox.stub();v.loadModel.returns(true);ok(v.ajax());ok(x.called);w.resolveWith(undefined,[{}]);ok(y.called);ok(!v.model.setDraft.called)});test("Controller ajax fail",function(){var z=this.sandbox.stub(t,"makeWebSudoRequest");var y=this.sandbox.stub(JIRA.Workflows.Scheme.Common,"smartAjaxErrorHandler");var x=new a();z.returns(x.promise());var A=this;var w=new u({pageView:function(){this.setLoading=h.noop},model:function(){this.setDraft=A.sandbox.spy()},issueTypeModel:h.noop,viewEventBus:{on:h.noop}});var v=this.sandbox.spy();y.returns(v);ok(w.ajax());ok(z.called);ok(y.calledWithExactly(JIRA.Workflows.Scheme.Common.refreshErrorDialog));ok(w.requests);x.rejectWith(window,[]);ok(v.called);ok(!w.requests);ok(!w.model.setDraft.called)});test("Controller constructor binds to bus events",function(){var v=new u({pageView:h.noop,model:h.noop,issueTypeModel:h.noop,viewEventBus:{on:this.sandbox.spy()}});v.viewEventBus.on.calledWith("removeIssueType",v.removeIssueType,v);v.viewEventBus.on.calledWith("removeWorkflow",v.removeWorkflow,v);v.viewEventBus.on.calledWith("assignIssueTypes",v.assignIssueTypes,v);v.viewEventBus.on.calledWith("addWorkflow",v.addWorkflow,v);expect(0)});module("JIRA.Workflows.Scheme.Editor.Model - Tests",{teardown:function(){this.sandbox.restore()},setup:function(){this.sandbox=sinon.sandbox.create();this.bus=s.clone(d.Events)}});test("WorkflowSchemeModel sets correctly",function(){var v=new q();var w={name:"WorkflowSchemeModel",mappings:[{name:"Workflow1"},{name:"Workflow2"}],issueTypes:"name"};ok(v.load(w),"Returns true if changed.");deepEqual(v.workflows.toJSON(),w.mappings,"Mappings should be in its own collection.");deepEqual(v.toJSON(),{name:"WorkflowSchemeModel"},"Workflow Scheme Model correctly copied.")});test("WorkflowSchemeModel load",function(){var v=new q({});var x=function(y){var z=v.toJSON();z.mappings=v.workflows.toJSON();ok(s.isEqual(y,z))};var w={mappings:[{name:"workflow1",issueTypes:[]},{name:"workflow2",issueTypes:[]}],name:"",description:"",draftScheme:"",shared:"",totalWorkflows:""};ok(v.load(w));ok(!v.load(w));x(w);w.mappings[1].name="workflow3";ok(v.load(w));ok(!v.load(w));x(w);w.name="something";ok(v.load(w));ok(!v.load(w));x(w);w.ignoredProperty="this will not matter";ok(!v.load(w));x(w);w.mappings[1].issueTypes=["1","2"];ok(v.load(w));ok(!v.load(w));x(w);w.mappings[1].issueTypes=["2","1"];ok(!v.load(w));w.mappings[1].issueTypes=["1","2"];x(w);w.mappings[1].issueTypes=["1"];ok(v.load(w));ok(!v.load(w));x(w);w.mappings.reverse();ok(!v.load(w));w.mappings.reverse();x(w)});test("WorkflowSchemeModel removeIssueType on non-default workflow",function(){var v=new q();v.workflows.add({"default":false,issueTypes:["1","2","3"],name:"workflow"});v.removeIssueType("workflow","1");deepEqual(v.workflows.get("workflow").toJSON(),{"default":false,issueTypes:["2","3"],name:"workflow"});v.removeIssueType("workflow","2");deepEqual(v.workflows.get("workflow").toJSON(),{"default":false,issueTypes:["3"],name:"workflow"});v.removeIssueType("workflow","3");ok(!v.workflows.get("workflow"))});test("WorkflowSchemeModel removeIssueType on default workflow",function(){var v=new q();v.workflows.add({"default":true,issueTypes:["1","2","3"],name:"workflow"});v.removeIssueType("workflow","1");deepEqual(v.workflows.get("workflow").toJSON(),{"default":true,issueTypes:["2","3"],name:"workflow"});v.removeIssueType("workflow","2");deepEqual(v.workflows.get("workflow").toJSON(),{"default":true,issueTypes:["3"],name:"workflow"});v.removeIssueType("workflow","3");deepEqual(v.workflows.get("workflow").toJSON(),{"default":true,issueTypes:[],name:"workflow"})});test("WorkflowSchemeModel removeWorkflow on non-default workflow",function(){var v="workflow";var w=new q();w.workflows.add({"default":false,name:v});var x=w.workflows.get(v);x.destroy=this.sandbox.spy();ok(w.removeWorkflow("workflow")===undefined);ok(x.destroy.calledWith())});test("WorkflowSchemeModel removeWorkflow on default workflow with other workflow",function(){var v="workflow";var y="workflowNewDefault";var w=new q();w.workflows.add({"default":true,name:v});w.workflows.add({"default":false,name:y});var x=w.workflows.get(v);this.sandbox.spy(x,"destroy");ok(w.removeWorkflow(v)===y);deepEqual(w.workflows.get(y).toJSON(),{"default":true,name:y});ok(x.destroy.calledWith())});test("WorkflowSchemeModel removeWorkflow on default workflow with no other workflow",function(){var v="workflow";var w=new q();w.workflows.add({"default":true,name:v});var x=w.workflows.get(v);this.sandbox.spy(x,"destroy");ok(w.removeWorkflow("workflow")===undefined);ok(x.destroy.calledWith())});test("WorkflowSchemeModel assignIssueTypes do not reassign default",function(){var v=new q();v.workflows.add({"default":false,issueTypes:["1"],name:"workflow"});v.workflows.add({"default":true,issueTypes:["2"],name:"workflow2"});v.assignIssueTypes("workflow",["2"],false);deepEqual(v.workflows.get("workflow").toJSON(),{"default":false,issueTypes:["1","2"],name:"workflow"});deepEqual(v.workflows.get("workflow2").toJSON(),{"default":true,issueTypes:[],name:"workflow2"})});test("WorkflowSchemeModel assignIssueTypes do reassign default",function(){var v=new q();v.workflows.add({"default":false,issueTypes:["1"],name:"workflow"});v.workflows.add({"default":true,issueTypes:["2"],name:"workflow2"});v.workflows.add({"default":false,issueTypes:["3","4"],name:"workflow3"});v.assignIssueTypes("workflow",["3","2"],true);deepEqual(v.workflows.get("workflow").toJSON(),{"default":true,issueTypes:["1","3","2"],name:"workflow"});ok(!v.workflows.get("workflow2"));deepEqual(v.workflows.get("workflow3").toJSON(),{"default":false,issueTypes:["4"],name:"workflow3"})});test("WorkflowSchemeModel addWorkflow do not reassign default",function(){var v=new q();v.workflows.add({"default":false,issueTypes:["1"],name:"workflow"});v.workflows.add({"default":true,issueTypes:["2"],name:"workflow2"});v.addWorkflow({name:"workflow3",issueTypes:["2","4"],"default":false,displayName:"workflow3",description:"description"});deepEqual(v.workflows.get("workflow").toJSON(),{"default":false,issueTypes:["1"],name:"workflow"});deepEqual(v.workflows.get("workflow2").toJSON(),{"default":true,issueTypes:[],name:"workflow2"});deepEqual(v.workflows.get("workflow3").toJSON(),{"default":false,issueTypes:["2","4"],name:"workflow3",displayName:"workflow3",description:"description"})});test("WorkflowSchemeModel addWorkflow do reassign default",function(){var v=new q();v.workflows.add({"default":false,issueTypes:["1"],name:"workflow"});v.workflows.add({"default":true,issueTypes:["2"],name:"workflow2"});v.addWorkflow({name:"workflow3",issueTypes:["2","4"],"default":true,displayName:"workflow3",description:"workflow3"});deepEqual(v.workflows.get("workflow").toJSON(),{"default":false,issueTypes:["1"],name:"workflow"});deepEqual(v.workflows.get("workflow3").toJSON(),{"default":true,issueTypes:["2","4"],name:"workflow3",displayName:"workflow3",description:"workflow3"})});test("WorkflowSchemeModel discardDraft",function(){var v=new q();v.set({draftScheme:true,lastModifiedDate:"something",lastModifiedUser:"user",other:"other"});var w=[{name:"workflow3"},{name:"workflow4"}];v.workflows.reset([{name:"workflow1"},{name:"workflow2"}]);v.originalWorkflows.reset(w);v.discardDraft();deepEqual(v.toJSON(),{draftScheme:false,other:"other"},"Cleared out the correct state.");deepEqual(v.workflows.toJSON(),w,"Original -> Current");deepEqual(v.originalWorkflows.length,0,"Original Cleared")});test("IssueTypeCollection load",function(){var v=[{name:"issuetype1"},{name:"issuetype2"}];var x=[{name:"issuetype1"},{name:"issuetype3"}];var w=new r(v);w.reset=this.sandbox.spy();ok(!w.load(v));ok(!w.reset.called);ok(w.load(x));ok(w.reset.called)});test("WorkflowModel equalsObject",function(){var x={name:"workflow","default":true,issueTypes:["1","2"]};var z=new b(x);ok(z.equalsObject(x));var y=h.extend(true,{},x);ok(z.equalsObject(y));y["default"]=false;ok(!z.equalsObject(y));var w=h.extend(true,{},x);ok(z.equalsObject(w));w.name="different name";ok(!z.equalsObject(w));var v=h.extend(true,{},x);ok(z.equalsObject(v));v.issueTypes.reverse();ok(z.equalsObject(v));v.issueTypes.pop();ok(!z.equalsObject(v))});test("WorkflowCollection equalsArray",function(){var z=[{name:"workflow1","default":true,issueTypes:["1","2"]},{name:"workflow2","default":false,issueTypes:["3","4"]}];var v=new f(z);ok(v.equalsArray(z));var y=h.extend(true,[],z);y.pop();ok(!v.equalsArray(y));var x=h.extend(true,[],z);x.push({name:"workflow3","default":false,issueTypes:["5"]});ok(!v.equalsArray(x));var w=h.extend(true,[],z);w[0].issueTypes.reverse();ok(v.equalsArray(w));w[0].issueTypes.pop();ok(!v.equalsArray(w))});module("JIRA.Workflows.Scheme.Editor.View - Tests",{teardown:function(){this.sandbox.restore()},setup:function(){this.sandbox=sinon.sandbox.create();this.Templates=c;this.bus=s.clone(d.Events);this.sandbox.spy(AJS,"format")}});test("WorkflowSchemeHeaderView",function(){var K={key:"ONE",name:"Project One",id:1};var J={key:"TWO",name:"Project Two",id:2};var H={name:"workflow1"};var G={name:"workflow2"};var L={name:"Scheme2",draftScheme:false,shared:{sharedWithProjects:[K,J],sharedWithIssueTypes:[],totalProjectsCount:3,hiddenProjectsCount:1},totalWorkflows:3};var D={name:"Scheme1",draftScheme:true,shared:{sharedWithProjects:[],sharedWithIssueTypes:[],totalProjectsCount:0,hiddenProjectsCount:0},lastModifiedDate:"Last Date",lastModifiedUser:{displayName:"User Display",name:"User"},currentUser:"User"};var C=new d.Model(L);var B=new f([H,G]);var F=new r([]);var y=AJS.test.mockableModuleContext();var M=this.stub(j);y.mock("jira/util/events",M);var z=this.stub();y.mock("jira-project-config/workflows/dialogs/discard-draft",z);var I=y.require("jira-project-config/workflows/scheme/editor/views/workflow-scheme-header");var v=new I({bus:this.bus,issueTypes:F,workflows:B,editable:true,model:C});var x={events:[],register:function(O){O.on("all",function(){this.events.push(s.toArray(arguments))},this)},clear:function(){this.events=[]},calledWith:function(){var O=s.toArray(arguments);return s.any(this.events,function(P){return s.isEqual(P,O)})}};var w=function(O){this.view=O;this.selectors={publish:"#publish-draft",discard:"#discard-draft",viewOriginal:"#view-original",viewDraft:"#view-draft",addWorkflow:"#add-workflow-dropdown li:has(#add-workflow), #add-workflow-dropdown-trigger",schemeName:"#workflow-scheme-name",draftStatus:".status-draft",sharedBy:".shared-by",projects:"#project-config-workflow-scheme-shared li a"};this.name=function(){return this.view.$(this.selectors.schemeName).val()};this.draft=function(){return this.view.$(this.selectors.draftStatus).length>0};this.shared=function(){if(this.view.$(this.selectors.sharedBy).length){var P=[];this.view.$(this.selectors.projects).each(function(){P.push(h.trim(h(this).text()))});return P}else{return null}};this.getDraftInfo=function(){var P=this.findOrNull(this.selectors.draftStatus);if(!P){return null}var R=P.attr("title");if(!R){return null}var Q=AJS.format.lastCall;if(Q.calledWith("admin.workflowscheme.last.edited.by.you.at")){return{you:true,time:Q.args[1]}}else{if(Q.calledWith("admin.workflowscheme.last.edited.by.user.at")){return{you:false,name:Q.args[1],time:Q.args[2]}}else{throw new Error("Title did not match expected info.")}}};this.canPublish=function(){return this.findOrNull(this.selectors.publish)!==null};this.canDiscard=function(){return this.findOrNull(this.selectors.discard)!==null};this.canViewOriginal=function(){return this.findOrNull(this.selectors.viewOriginal)!==null};this.canViewDraft=function(){return this.findOrNull(this.selectors.viewDraft)!==null};this.canAddWorkflow=function(){var P=this.view.$(this.selectors.addWorkflow);return P.length>0&&!P.hasClass("disabled")};this.viewOriginal=function(){return this.click(this.selectors.viewOriginal,"View Original")};this.viewDraft=function(){return this.click(this.selectors.viewDraft,"View Draft")};this.discard=function(){return this.click(this.selectors.discard,"Discard Draft")};this.findOrNull=function(P){var Q=this.view.$(P);if(Q.length===0){return null}else{return Q}};this.click=function(R,P){var Q=this.findOrNull(R);if(!Q){throw new Error("Unable to perform '"+P+"' link not present.")}Q.click();return this}};var N=function(Q,X,S,O){equal(O.name(),Q.get("name"),"Workflow has correct name?");var P=Q.get("draftScheme");if(!P){ok(!O.draft(),"Workflow scheme is not draft?");ok(!O.canPublish(),"Can't publish inactive ?");ok(!O.canDiscard(),"Can't discard inactive ?");ok(!O.canViewOriginal(),"Can't see original of inactive ?");ok(!O.canViewDraft(),"Can't see original of inactive ?");ok(!O.getDraftInfo(),"No draft info.")}else{if(S){ok(!O.draft(),"Workflow original should not be draft?");ok(!O.canPublish(),"Can't publish from original screen.");ok(!O.canDiscard(),"Can't discard from original screen");ok(!O.canViewOriginal(),"Can't view original from original screen.");ok(O.canViewDraft(),"Can view draft from original screen.");ok(!O.getDraftInfo(),"No draft info.")}else{var W=null;var U=Q.get("lastModifiedUser");var T=Q.get("lastModifiedDate");if(U&&T){var V=U.name===Q.get("currentUser");W={you:V,time:T};if(!V){W.name=U.displayName}}deepEqual(O.getDraftInfo(),W,"Draft Info correct?");ok(O.draft(),"Workflow should not be draft?");ok(O.canPublish(),"Can publish from draft screen.");ok(O.canDiscard(),"Can discard from draft screen");ok(O.canViewOriginal(),"Can view original from draft screen.");ok(!O.canViewDraft(),"Can't view draft from draft screen.")}}var R=Q.get("shared");if(R.sharedWithProjects.length>0){deepEqual(O.shared(),s.pluck(R.sharedWithProjects,"name"),"Sharing information correct")}else{ok(!O.shared(),"Not shared.")}if((P&&S)||X.length>=Q.get("totalWorkflows")){ok(!O.canAddWorkflow(),"Should not be able to add workflow.")}else{ok(O.canAddWorkflow(),"Should be able to add workflow")}};var E=new w(v.render());equal(M.trigger.callCount,1,"Trigged NEW_CONTEXT_ADDED.");ok(M.trigger.lastCall.calledWith(m.NEW_CONTENT_ADDED,[v.$el,g.workflowHeaderReady]),"Content added triggered.");N(C,B,false,E);B.add({name:"workflow3"});N(C,B,false,E);equal(M.trigger.callCount,1,"Don't trigger NEW_CONTEXT_ADDED.");B.remove(B.get("workflow3"));N(C,B,false,E);equal(M.trigger.callCount,1,"Don't trigger NEW_CONTEXT_ADDED.");C.set(D);equal(M.trigger.callCount,2,"Trigged NEW_CONTEXT_ADDED.");ok(M.trigger.lastCall.calledWith(m.NEW_CONTENT_ADDED,[v.$el,g.workflowHeaderReady]),"Content added triggered.");N(C,B,false,E);x.register(this.bus);E.viewOriginal();equal(M.trigger.callCount,3,"Trigged NEW_CONTEXT_ADDED.");ok(M.trigger.lastCall.calledWith(m.NEW_CONTENT_ADDED,[v.$el,g.workflowHeaderReady]),"Content added triggered.");ok(x.calledWith("viewOriginal"),"View Original event triggered.");N(C,B,true,E);x.clear();E.viewDraft();equal(M.trigger.callCount,4,"Trigged NEW_CONTEXT_ADDED.");ok(M.trigger.lastCall.calledWith(m.NEW_CONTENT_ADDED,[v.$el,g.workflowHeaderReady]),"Content added triggered.");ok(x.calledWith("viewDraft"),"View Draft event triggered.");N(C,B,false,E);B.add({name:"workflow5"});N(C,B,false,E);x.clear();E.viewOriginal();equal(M.trigger.callCount,5,"Trigged NEW_CONTEXT_ADDED.");ok(M.trigger.lastCall.calledWith(m.NEW_CONTENT_ADDED,[v.$el,g.workflowHeaderReady]),"Content added triggered.");ok(x.calledWith("viewOriginal"),"View Original event triggered.");N(C,B,true,E);x.clear();E.viewDraft();C.set("currentUser","notMe");equal(M.trigger.callCount,7,"Trigged NEW_CONTEXT_ADDED.");ok(M.trigger.lastCall.calledWith(m.NEW_CONTENT_ADDED,[v.$el,g.workflowHeaderReady]),"Content added triggered.");ok(x.calledWith("viewDraft"),"View Draft event triggered.");N(C,B,false,E);B.remove(B.get("workflow5"));N(C,B,false,E);equal(M.trigger.callCount,7,"Don't trigger NEW_CONTEXT_ADDED.");var A=this.sandbox.spy();x.clear();z.yields(A);E.discard();ok(x.calledWith("discardDraft"),"Discard Draft called.");N(C,B,false,E);ok(A.calledWith(),"Triggered the callback.")});test("WorkflowSchemeHeaderView assignAfterAdd",function(){var y=AJS.test.mockableModuleContext();var x=this.sandbox.stub();y.mock("jira-project-config/workflows/dialogs/assign-issue-types",x);var v=y.require("jira-project-config/workflows/scheme/editor/views/workflow-scheme-header");var z=[{name:"workflow1","default":true}];var w=new v({model:{workflows:new f(z),on:h.noop},workflows:{on:h.noop,toJSON:h.noop},issueTypes:{toJSON:h.noop}});w.assignAfterAdd({});ok(x.called)});test("WorkflowSchemeHeaderView canAddWorkflow",function(){var v=new n({model:{on:h.noop,get:this.sandbox.stub()},workflows:{on:h.noop,length:1}});v.model.get.withArgs("totalWorkflows").returns(2);ok(v.canAddWorkflow());v.model.get.withArgs("totalWorkflows").returns(1);ok(!v.canAddWorkflow())});test("WorkflowView initialize",function(){var w={issueTypes:"something",model:{on:this.sandbox.spy()}};var v=new e(w);strictEqual(v.issueTypes,w.issueTypes);ok(w.model.on.calledWithExactly("change",v.render,v));ok(w.model.on.calledWithExactly("destroy",v.unrender,v))});test("WorkflowView template",function(){var x=this.sandbox.stub(this.Templates,"WorkflowView");x.returnsArg(0);var y={someKey:"some data"};var w={issueTypes:"",model:{on:h.noop}};var v=new e(w);strictEqual(v.template(y),y);ok(x.calledWithExactly(y))});test("WorkflowView render",function(){var z={issueTypes:["issueType1"]};var x="some name";var w={issueTypes:new r([{id:"issueType1",name:"issueType1"},{id:"issueType2",name:"issueType2"}]),model:{get:this.sandbox.stub(),on:h.noop,toJSON:this.sandbox.stub(),collection:{length:2}},editable:true};var v=new e(w);var y="some html";v.template=this.sandbox.stub();v.template.returns(y);v.$el.html=this.sandbox.spy();w.model.get.returns(x);w.model.toJSON.returns(z);var A=v.render();ok(v.template.calledWithExactly({issueTypes:[{id:"issueType1",name:"issueType1"}],showAssign:false,editable:true}));ok(v.$el.html.calledWithExactly(y));ok(v===A,"Invalid view")});test("WorkflowView viewWorkflowText",function(){var w=this.sandbox.stub(JIRA.Workflows.Scheme.Common,"showWorkflowTextView");var z="some id";var x={model:{id:z,on:h.noop}};var v=new e(x);var y={preventDefault:this.sandbox.spy()};v.viewWorkflowText(y);ok(y.preventDefault.called);ok(w.calledWithExactly({workflowName:z}))});test("WorkflowView removeAllIssueTypes",function(){var w={model:{id:"workflow",on:h.noop,destroy:this.sandbox.spy()},bus:{trigger:this.sandbox.spy()}};var v=new e(w);var x={preventDefault:this.sandbox.spy()};v.removeAllIssueTypes(x);ok(x.preventDefault.called);ok(w.bus.trigger.calledWith("removeWorkflow",w.model.id))});test("WorkflowView removeIssueType",function(){var w={model:{id:"workflow",on:h.noop,set:this.sandbox.spy(),get:this.sandbox.stub()},bus:{trigger:this.sandbox.spy()}};var v=new e(w);var x={preventDefault:this.sandbox.spy(),currentTarget:"<span data-issue-type='1'></span>"};v.removeIssueType(x);ok(x.preventDefault.called);ok(w.bus.trigger.calledWith("removeIssueType",w.model.id,"1"))});test("WorkflowSchemeView",function(){function y(B){this.options=B;this.render=function(){this.$el=h("<div>").attr("id","header");return this}}function w(B){this.model=B.model;this.name=this.model.id;this.options=B;this.render=function(){var C=h("<tr>").attr("id","row-"+this.name);h("<td>").text(this.name).data("editable",this.options.editable).appendTo(C);this.$el=C;return this};this.unrender=function(){this.$el.remove()}}var A={issueTypes:new r([]),model:{workflows:new f([{name:"workflow1"},{name:"workflow2"}]),originalWorkflows:new f([{name:"workflow4"},{name:"workflow3"}]),get:h.noop},bus:this.bus,headerViewCotr:y,workflowViewCotr:w};var z=A.model.workflows;var x=new k(A);x.render();var v=function(D,C){var E=x.$("td");equal(D.length,E.length,"Right number of expectedWorkflows?");for(var B=0;B<D.length;B++){var F=h(E[B]);var G=D[B];equal(F.text(),G,"Expected workflow["+B+"]  to be "+G);equal(F.data("editable"),C,"Expected workflow["+B+"] to be "+(!C?"NOT ":"")+" editable.")}};equal(x.$el.find("#header").length,1,"Is header rendered?");v(["workflow1","workflow2"],true);this.bus.trigger("viewOriginal");v(["workflow4","workflow3"],false);this.bus.trigger("viewDraft");v(["workflow1","workflow2"],true);z.add({name:"workflow7"});v(["workflow1","workflow2","workflow7"],true);this.bus.trigger("viewOriginal");v(["workflow4","workflow3"],false);this.bus.trigger("viewDraft");v(["workflow1","workflow2","workflow7"],true);z.reset([{name:"workflow8"},{name:"workflow9"}]);v(["workflow8","workflow9"],true)});test("Page view",function(){var w=AJS.test.mockableModuleContext();var x=this.sandbox.stub(l);w.mock("jira-project-config/workflows/scheme/editor/templates",x);var B=x.errorMessage;var H="something";var A;var E=this.sandbox.spy();var v=function(J){A=J;this.render=function(){this.$el=H;return this};this.finalize=E};w.mock("jira-project-config/workflows/scheme/editor/views/workflow-scheme",v);var I=w.require("jira-project-config/workflows/scheme/editor/views/page");var C={on:h.noop};var D=new I({bus:C});D.$el={removeClass:this.sandbox.stub(),html:this.sandbox.spy(),toggleClass:this.sandbox.spy(),closest:this.sandbox.stub()};D.$el.removeClass.returns(D.$el);D.$el.closest.returns(D.$el);var z="some html";D.html(z);ok(D.$el.removeClass.calledWithExactly("workflowscheme-editor-loading"));ok(D.$el.html.calledWithExactly(z));var G="something";D.html=this.sandbox.spy();B.returns(G);D.renderError(G);ok(B.calledWithExactly({message:G}));ok(D.html.calledWithExactly(G));var y={workflows:{on:this.sandbox.spy(),length:1},on:h.noop,get:h.noop};var F="issueTypes";D.html=this.sandbox.spy();D.renderModel(y,F);ok(!E.called);deepEqual(A,{model:y,issueTypes:F,bus:C});ok(D.html.calledWithExactly(H));D.renderModel(y,F);ok(y.workflows.on.calledWith("add remove"));ok(y.workflows.on.calledWith("reset"));ok(D.$el.toggleClass.calledWith("multiple-workflows",false));ok(E.called)})});