define("jira-project-config/utils/paged-scrollable",["require"],function(require){var jQuery=require("jquery");var _=require("underscore");function PagedScrollable(scrollPaneSelector,options){var self=this;this.$scrollElement=jQuery(scrollPaneSelector||window);if(jQuery.isWindow(this.$scrollElement[0])){var docEl=window.document.documentElement;this.getPaneHeight=function(){return docEl.clientHeight};this.getContentHeight=function(){return docEl.scrollHeight}}this.options=jQuery.extend({},PagedScrollable.defaults,options);this.functionCall=this.options.functionCall;this._eventHandlers=[];PagedScrollable.prototype.reset.call(this);this.addScrollListener(function(){self.loadIfRequired()});if(this.options.preventOverscroll){this._bindOverscrollPrevention()}jQuery(window).on("resize",this._resizeHandler=function(){self.loadIfRequired()});self.loadIfRequired();return this}PagedScrollable.defaults={scrollDelay:250,bufferPixels:0,preventOverscroll:false,functionCall:function(){}};PagedScrollable.prototype.reset=function(){this.clearScrollListeners();if(this._resizeHandler){jQuery(window).off("resize",this._resizeHandler);this._resizeHandler=null}this._suspended=false};PagedScrollable.prototype.destroy=function(){this.reset();delete this.$scrollElement};PagedScrollable.prototype.suspend=function(){this._suspended=true};PagedScrollable.prototype.resume=function(){this._suspended=false;return this.loadIfRequired()};PagedScrollable.prototype.isSuspended=function(){return this._suspended};PagedScrollable.prototype.getScrollTop=function(){return this.$scrollElement.scrollTop()};PagedScrollable.prototype.setScrollTop=function(scrollTop){this.$scrollElement.scrollTop(scrollTop)};PagedScrollable.prototype.getPane=function(){return this.$scrollElement};PagedScrollable.prototype.getPaneHeight=function(){return this.$scrollElement[0].clientHeight};PagedScrollable.prototype.getContentHeight=function(){return this.$scrollElement[0].scrollHeight};PagedScrollable.prototype.getOption=function(opt){if(Object.prototype.hasOwnProperty.call(this.options,opt)){return this.options[opt]}return undefined};PagedScrollable.prototype.setOptions=function(opts){if(jQuery.isPlainObject(opts)){this.options=jQuery.extend(this.options,opts)}};PagedScrollable.prototype.addScrollListener=function(func){var handler=this.scrollDelay?_.debounce(func,this.scrollDelay):func;this._eventHandlers.push(handler);this.$scrollElement.on("scroll.paged-scrollable",handler)};PagedScrollable.prototype._bindOverscrollPrevention=function(){var _this=this;function overscrollPrevention(e,delta){var height=jQuery(_this).outerHeight();var scrollHeight=_this.scrollHeight;if((_this.scrollTop===(scrollHeight-height)&&delta<0)||(_this.scrollTop===0&&delta>0)){e.preventDefault()}}this._eventHandlers.push(overscrollPrevention);this.$scrollElement.on("mousewheel.paged-scrollable",overscrollPrevention)};PagedScrollable.prototype.clearScrollListeners=function(){var self=this;_.each(this._eventHandlers,function(handler){self.$scrollElement.unbind(".paged-scrollable",handler)});this._eventHandlers.length=0};PagedScrollable.prototype.loadIfRequired=function(){if(this.isSuspended()){return }if(!jQuery.isWindow(this.getPane()[0])&&this.getPane().is(":hidden")){return }var scrollTop=this.getScrollTop();var scrollPaneHeight=this.getPaneHeight();var contentHeight=this.getContentHeight();var scrollBottom=scrollPaneHeight+scrollTop;var chromeWindowsFontChangeBuffer=1;if(scrollBottom+chromeWindowsFontChangeBuffer>=contentHeight-this.options.bufferPixels){var self=this;var functionResult=self.functionCall();if(functionResult.done){self.suspend();functionResult.done(function(){self.resume()})}}};return PagedScrollable});AJS.namespace("JIRA.ProjectConfig.PageScroller",null,require("jira-project-config/utils/paged-scrollable"));