AJS.test.require(["com.atlassian.jira.jira-project-config-plugin:project-config-roles"],function(){var d=require("jquery");var h=require("underscore");var g=require("jira/util/formatter");var e=require("wrm/context-path");var i=require("jira-project-config/roles/entities/roles-results-model");var f=require("jira-project-config/roles/entities/role-collection");var b={projectKey:"?A&QUERY=1",roles:[{id:10001,name:"Administrators",total:4,groups:[{name:"jira-administrators"},{name:"jira-developers"}],users:[{active:true,name:"sharwood",displayName:"Scott Harwood",email:"sh@gmail.com",applicationRoleNames:[]},{active:true,name:"bbaker",displayName:"Brad Baker",email:"bb@gmail.com",applicationRoleNames:[]}]},{id:10002,name:"Customers",total:3,users:[{active:true,name:"jwilson",displayName:"Julian Wilson",email:"sh@gmail.com",applicationRoleNames:[]},{active:true,name:"kslater",displayName:"Kelly Slater",email:"kelly@gmail.com",applicationRoleNames:[]},{active:true,name:"airons",displayName:"Andy Irons",email:"and@gmail.com",applicationRoleNames:[]}],groups:[]}]};var c={roles:[{id:10001,name:"Administrators",total:0,groups:[],users:[]},{id:10002,name:"Customers",total:0,users:[],groups:[]}]};var a={pageNumber:1,viewingRoleId:10001,roles:[{id:10001,name:"",total:192,groups:new Array(15),users:new Array(5)}]};module("jira-project-config/roles/entities/roles-results-model-test",{setup:function(){this.sandbox=sinon.sandbox.create();this.sandbox.stub(g,"format",function(){var j=Array.prototype.slice.call(arguments,0);return j.join(",")})},teardown:function(){this.sandbox.restore()}});test("Model should have default values",function(){var j=new i();strictEqual(j.get("projectKey"),"");strictEqual(j.get("pageNumber"),1);strictEqual(j.get("viewingRoleId"),null);strictEqual(j.get("query"),"");deepEqual(j.get("roles").toJSON(),[])});test("The old fetch request should be aborted before a new request is fired",function(){var l=new i();var k=l.fetch();var m=this.sandbox.spy();k.fail(m);var j=l._currentFetchRequest;ok(j.abort(),false);l.fetch();ok(j.abort(),true,"The old fetch request should be aborted");sinon.assert.callCount(m,0,"Fail callback should not be called when the request is aborted.")});test("toFilterRoleOptions",function(){var j=new i(b);var k=j.toFilterRoleOptions();deepEqual(k,[{text:"common.words.all",value:""},{text:"Administrators",value:10001},{text:"Customers",value:10002}])});test("toRoleOptions",function(){var j=new i(b);var k=j.toRoleOptions();deepEqual(k,[{text:"Administrators",value:10001},{text:"Customers",value:10002}])});test("Should use a nested roles collection when use set roles",function(){var j=new i(b);ok(j.get("roles") instanceof f,"Should use a nested roles collection when use set roles")});test("isViewingDefaultView",function(){var j=new i(b);strictEqual(j.isViewingDefaultView(),true);j.set("query","blah");strictEqual(j.isViewingDefaultView(),false);j.set("query","");j.set("viewingRoleId",10002);strictEqual(j.isViewingDefaultView(),false)});test("isRoleResultEmpty",function(){var j=new i(b);strictEqual(j.isRoleResultEmpty(),false);j=new i(c);strictEqual(j.isRoleResultEmpty(),true)});test("getVisibleActorsCount",function(){var j=new i(a);j.set("pageNumber",1);strictEqual(j.getVisibleActorsCount(),20)});test("getTotalPageNumber",function(){var j=new i(a);strictEqual(j.getTotalPageNumber(),200/20,"Should return total page number when viewing a specific role");j.set("viewingRoleId",null);strictEqual(j.getTotalPageNumber(),undefined,"Should return undefined when viewing all roles")});test("Fetcher URL Should be encoded",function(){var j=new i(b);j.set("query","&tim=&amp;&no");strictEqual(j.url(),e()+"/rest/projectconfig/latest/roles/%3FA&QUERY=1?query="+encodeURIComponent("&tim=&amp;&no")+"&pageNumber=1&pageSize=5","URL should encoded");j.set("viewingRoleId",10009);strictEqual(j.url(),e()+"/rest/projectconfig/latest/roles/%3FA&QUERY=1?query="+encodeURIComponent("&tim=&amp;&no")+"&pageNumber=1&pageSize=20&roleId=10009","URL should encoded")});test("_buildPaginationData",function(){var j=new i(a);j.set("pageNumber",1);deepEqual(j._buildPaginationData(),{firstPage:null,previousPage:null,pages:[{number:1,selected:true},{number:2,selected:false},{number:3,selected:false}],nextPage:2,lastPage:10,showingFrom:1,showingTo:20});j.set("pageNumber",2);deepEqual(j._buildPaginationData(),{firstPage:1,previousPage:1,pages:[{number:1,selected:false},{number:2,selected:true},{number:3,selected:false},{number:4,selected:false}],nextPage:3,lastPage:10,showingFrom:21,showingTo:40});j.set("pageNumber",4);deepEqual(j._buildPaginationData(),{firstPage:1,previousPage:3,pages:[{number:2,selected:false},{number:3,selected:false},{number:4,selected:true},{number:5,selected:false},{number:6,selected:false}],nextPage:5,lastPage:10,showingFrom:61,showingTo:80});j.set("pageNumber",9);deepEqual(j._buildPaginationData(),{firstPage:1,previousPage:8,pages:[{number:7,selected:false},{number:8,selected:false},{number:9,selected:true},{number:10,selected:false}],nextPage:10,lastPage:10,showingFrom:161,showingTo:180});j.set("pageNumber",10);deepEqual(j._buildPaginationData(),{firstPage:1,previousPage:9,pages:[{number:8,selected:false},{number:9,selected:false},{number:10,selected:true}],nextPage:null,lastPage:null,showingFrom:181,showingTo:192})});test("toJSON with extra infomation",function(){var j=new i(b);j.set({query:"&tim=&amp;&no",viewingRoleId:10002});var k=j.toJSON();strictEqual(k.isViewingDefaultView,false);strictEqual(k.isRoleResultEmpty,false);strictEqual(k.allRoleViewPageSize,5);strictEqual(k.totalPageNumber,1);ok(k.paginationData!==undefined)});test("_getPageSize",function(){var j=new i({viewingRoleId:null});strictEqual(j._getPageSize(),5,"Should have page size of 5 when viewing all roles");j.set("viewingRoleId",10009);strictEqual(j._getPageSize(),20,"Should have page size of 20 when viewing a specific role")});test("Fetch URL should be correct with or without contextPath",function(){var m=this.stub();var k=AJS.test.mockableModuleContext();k.mock("wrm/context-path",m);var j=k.require("jira-project-config/roles/entities/roles-results-model");var l=new j(b);l.set("query","&tim=&amp;&no");m.returns("/jira");ok(l.url().indexOf("/jira/rest/projectconfig/latest/roles/%3FA&QUERY=1?query=")===0,"Fetch URL should be correct with context path");m.returns("");ok(l.url().indexOf("/rest/projectconfig/latest/roles/%3FA&QUERY=1?query=")===0,"Fetch URL should be correct without context path")})});