AJS.test.require(["com.atlassian.jira.jira-project-config-plugin:issuetypes-tab","com.atlassian.jira.jira-project-config-plugin:issuetypes-test-utils"],function(){var m=require("underscore");var l=require("jira-project-config/backbone");var d=require("jira-project-config/libs/chance");var e=require("jira-project-config/issuetypes/entities/test/chance-mixins");var i=require("jira/jquery/deferred");var n=require("jira-project-config/issuetypes/entities/models/issue-types");var o=require("jquery");var h=require("jira-project-config/marionette");var k=require("jira-project-config/issuetypes/perspectives/workflow/pluggable-actions/view");var f=require("jira-project-config/issuetypes/perspectives/workflow/workflowinfo/view");var c=require("jira-project-config/issuetypes/entities/models/projects");var b=require("jira-project-config/issuetypes/perspectives/workflow/view");var g=require("wrm/context-path");var a=require("jira-project-config/issuetypes/model");var j=require("jira-project-config/issuetypes/perspectives/workflow/analytics");module("JIRA.ProjectConfig.IssueTypes.Workflow.Controller",{setup:function(){this.chance=new d(1);m.extend(this.chance,new e());this.$fixture=o("#qunit-fixture");var q=this.sandbox=sinon.sandbox.create();this.context=AJS.test.mockableModuleContext();this.context.mock("jira-project-config/backbone",l);this.context.mock("jira-project-config/issuetypes/perspectives/workflow/analytics",j);this.bug=this.chance.issueType().set({workflow:this.chance.workflow()});this.story=this.chance.issueType().set({workflow:this.chance.workflow()});this.issueTypes=new n([this.bug,this.story]);this.project=this.chance.project();this.model=new a({selectedIssueType:this.bug,editing:true,project:this.project});var p=this.workflowView=new b();this.context.mock("jira-project-config/issuetypes/perspectives/workflow/view",function(){return p});var r=this.workflowDesignerMock={destroy:q.spy(),publishDraft:q.stub().returns(new i().resolve().promise()),discardDraft:q.stub().returns(new i().resolve().promise())};this.sandbox.stub(JIRA.WorkflowDesigner,"Application").returns(r);this.region={show:sinon.spy()};this.resetPluggableRegionsSpy=this.sandbox.spy();this.commands=new h.Wreqr.Commands();this.commands.setHandler("issueTypes:resetPluggableRegions",this.resetPluggableRegionsSpy);this.vent=new h.Wreqr.EventAggregator();this.controller=this.buildController()},teardown:function(){this.sandbox.restore()},buildController:function(){var p=this.context.require("jira-project-config/issuetypes/perspectives/workflow/controller");return new p({commands:this.commands,model:this.model,region:this.region,vent:this.vent})},setEditWorkflowPermission:function(){this.bug.get("workflow").set({state:"editabledelegated"})},mockPluggableView:function(){var p=new l.View();m.extend(p,{disable:this.sandbox.spy()});this.context.mock("jira-project-config/issuetypes/perspectives/workflow/pluggable-actions/view",function(){return p});return p},mockPluggableInfoView:function(){var p=new l.View();m.extend(p,{disable:this.sandbox.spy()});this.context.mock("jira-project-config/issuetypes/perspectives/workflow/workflowinfo/view",function(){return p});return p}});test("showing shows in the provided region",3,function(){equal(this.region.show.callCount,0);this.controller.show();equal(this.region.show.callCount,1);ok(this.region.show.firstCall.args[0]===this.workflowView)});test("showing shows workflow designer",function(){equal(JIRA.WorkflowDesigner.Application.callCount,0,"Workflow designer should not yet have been instantiated");this.controller.show({});equal(JIRA.WorkflowDesigner.Application.callCount,1,"Workflow designer should have been instantiated");deepEqual(JIRA.WorkflowDesigner.Application.firstCall.args[0],{element:this.workflowView.ui.workflowDesigner,immutable:false,layoutData:{},workflowId:this.bug.get("workflow").get("name"),fullScreenButton:false,draft:true,actions:true},"options should match")});test("closing content view destroys workflow designer",function(){var p;this.controller.show({});p=this.region.show.firstCall.args[0];equal(this.workflowDesignerMock.destroy.callCount,0,"workflow designer should not yet have been destroyed");p.trigger("close");equal(this.workflowDesignerMock.destroy.callCount,1,"workflow designer should have been destroyed")});test("showing resets pluggable regions",function(){var r=this.chance.issueType();var s=this.chance.workflow();var x;var v;var t;var p;var q;var w=this.chance.issueType();this.context.mock("jira-project-config/issuetypes/perspectives/workflow/pluggable-actions/view",k);this.context.mock("jira-project-config/issuetypes/perspectives/workflow/workflowinfo/view",f);var u=this.buildController();s.set("sharedWithIssueTypes",new n([w]));s.set("sharedWithProjects",new c([this.project]));s.set("totalProjectsCount",Math.round(Math.random()*100));s.set("hiddenProjectsCount",Math.round(Math.random()*100));r.set("workflow",s);this.model.set("selectedIssueType",r);this.spy(AJS,"format");equal(this.resetPluggableRegionsSpy.callCount,0,"issueTypes:resetPluggableRegions should not yet have been executed");u.show({});equal(this.resetPluggableRegionsSpy.callCount,1,"issueTypes:resetPluggableRegions should have been executed");x=this.resetPluggableRegionsSpy.firstCall.args[0];ok(x.actions instanceof k,"options.actions should have been pluggable actions view");ok(x.info instanceof f,"options.actions should have been pluggable info view");sinon.assert.calledWith(AJS.format,"admin.issuetypeconfig.workflow.heading",r.get("name"));deepEqual(x.descriptor.toJSON(),{title:"admin.issuetypeconfig.workflow.heading",subtitle:"admin.issuetypeconfig.workflow.subheading",breadcrumbs:[{link:g()+"/plugins/servlet/project-config/"+this.project.get("key")+"/issuetypes",name:"admin.schemes.workflow.issuetypes",selected:false},{name:r.get("name"),selected:true}],},"options.descriptor should have had the correct model values");v=x.sharedBy.get("issueTypes");t=x.sharedBy.get("projects");p=x.sharedBy.get("totalProjectsCount");q=x.sharedBy.get("hiddenProjectsCount");deepEqual(v.toJSON(),[w.toJSON()]);deepEqual(t.toJSON(),[this.project.toJSON()]);equal(p,s.toJSON().totalProjectsCount);equal(q,s.toJSON().hiddenProjectsCount)});test("workflow:editWorkflow is fired on vent when pluggable actions view fires click:edit",function(){var r=this.mockPluggableView();var q=this.sandbox.spy();this.vent.on("workflow:editWorkflow",q);var p=this.buildController();p.show({});equal(q.callCount,0,"workflow:editWorkflow should not yet have been fired on the vent");r.trigger("click:edit");equal(q.callCount,1,"workflow:editWorkflow should have been fired on the vent")});test("analytics is fired when pluggable actions view fires click:edit",function(){this.sandbox.spy(j,"triggerEditedWorkflowClicked");var q=this.mockPluggableView();var p=this.buildController();p.show({});sinon.assert.notCalled(j.triggerEditedWorkflowClicked,"Analytics should not be fired before click:edit event");q.trigger("click:edit");sinon.assert.calledWith(j.triggerEditedWorkflowClicked)});test("analytics for user with edit workflow permission is fired when pluggable actions view fires click:edit with workflowEditPermission parameter set to true",function(){this.sandbox.spy(j,"triggerEditedWorkflowClicked");var q=this.mockPluggableView();var p=this.buildController();p.show({});sinon.assert.notCalled(j.triggerEditedWorkflowClicked,"Analytics should not be fired before click:edit event");q.trigger("click:edit",{workflowEditPermission:true});sinon.assert.calledWith(j.triggerEditedWorkflowClicked,true)});test("workflow:discardComplete is fired on vent when pluggable info view fires click:discard and discard request successful",function(){var r=this.mockPluggableInfoView();var q=this.sandbox.spy();this.vent.on("workflow:discardComplete",q);var p=this.buildController();p.show({});equal(q.callCount,0,"workflow:discardComplete should not yet have been fired on the vent");r.trigger("click:discard");equal(q.callCount,1,"workflow:discardComplete should have been fired on the vent")});test("info view disabled when it fires click:discard and discard succeeds",function(){var q=new i();this.workflowDesignerMock.discardDraft.returns(q);var r=this.mockPluggableInfoView();var p=this.buildController();p.show({});equal(r.disable.callCount,0,"info view disable() should not yet have been called");r.trigger("click:discard");equal(r.disable.callCount,1,"info view disable() should have been called once");equal(r.disable.firstCall.args[0],true,"info view disable() should have been called with true");q.resolve();equal(r.disable.callCount,1,"info view disable() should still only have been called once")});test("info view enabled when it fires click:discard and discard fails",function(){var q=new i();this.workflowDesignerMock.discardDraft.returns(q);var r=this.mockPluggableInfoView();var p=this.buildController();p.show({});equal(r.disable.callCount,0,"info view disable() should not yet have been called");r.trigger("click:discard");equal(r.disable.callCount,1,"info view disable() should have been called once");equal(r.disable.firstCall.args[0],true,"info view disable() should have been called with true");q.reject();equal(r.disable.callCount,2,"info view disable() should have been called once");equal(r.disable.secondCall.args[0],false,"info view disable() should have been called with false")});test("analytics event fired when info view fires click:discard and discard succeeds",function(){this.sandbox.spy(j,"triggerDiscardEditedWorkflow");this.workflowDesignerMock.discardDraft.returns(new i().resolve());var q=this.mockPluggableInfoView();var p=this.buildController();p.show({});q.trigger("click:discard");sinon.assert.calledWith(j.triggerDiscardEditedWorkflow,false)});test("analytics event fired when info view fires click:publish and publish fails",function(){this.sandbox.spy(j,"triggerDiscardEditedWorkflowFail");this.workflowDesignerMock.discardDraft.returns(new i().reject());var q=this.mockPluggableInfoView();var p=this.buildController();p.show({});q.trigger("click:discard");sinon.assert.calledWith(j.triggerDiscardEditedWorkflowFail,false)});test("workflow:publishComplete is fired on vent when pluggable info view fires click:publish and publish request successful",function(){var q=this.sandbox.spy();this.vent.on("workflow:publishComplete",q);var r=this.mockPluggableInfoView();var p=this.buildController();p.show({});equal(q.callCount,0,"workflow:publishComplete should not yet have been fired on the vent");r.trigger("click:publish");equal(q.callCount,1,"workflow:publishComplete should have been fired on the vent")});test("info view disabled when it fires click:publish and publish succeeds",function(){var q=new i();this.workflowDesignerMock.publishDraft.returns(q);var r=this.mockPluggableInfoView();var p=this.buildController();p.show({});equal(r.disable.callCount,0,"actions view disable() should not yet have been called");r.trigger("click:publish");equal(r.disable.callCount,1,"actions view disable() should have been called once");equal(r.disable.firstCall.args[0],true,"actions view disable() should have been called with true");q.resolve();equal(r.disable.callCount,1,"actions view disable() should still only have been called once")});test("info view enabled when it fires click:publish and publish fails",function(){var q=new i();this.workflowDesignerMock.publishDraft.returns(q);var r=this.mockPluggableInfoView();var p=this.buildController();p.show({});equal(r.disable.callCount,0,"actions view disable() should not yet have been called");r.trigger("click:publish");equal(r.disable.callCount,1,"actions view disable() should have been called once");equal(r.disable.firstCall.args[0],true,"actions view disable() should have been called with true");q.reject();equal(r.disable.callCount,2,"actions view disable() should have been called once");equal(r.disable.secondCall.args[0],false,"actions view disable() should have been called with false")});test("analytics event fired when info view fires click:publish and publish succeeds",function(){this.sandbox.spy(j,"triggerPublishEditedWorkflow");this.workflowDesignerMock.publishDraft.returns(new i().resolve());var q=this.mockPluggableInfoView();var p=this.buildController();p.show({});q.trigger("click:publish");sinon.assert.calledWith(j.triggerPublishEditedWorkflow,false)});test("analytics event fired when info view fires click:publish and publish fails",function(){this.sandbox.spy(j,"triggerPublishEditedWorkflowFail");var q=this.mockPluggableInfoView();this.workflowDesignerMock.publishDraft.returns(new i().reject());var p=this.buildController();p.show({});q.trigger("click:publish");sinon.assert.calledWith(j.triggerPublishEditedWorkflowFail,false)});test("controller stops listening to pluggable actions view and vent when it fires close",function(){var r=this.mockPluggableView();var p=this.buildController();var q=this.sandbox.spy(p,"stopListening");p.show({});equal(q.callCount,0,"stopListening() should not yet have been called");r.trigger("close");equal(q.callCount,2,"stopListening() should have been called twice");ok(q.firstCall.args[0]===r,"first call to stopListening() should have been called with the pluggable actions view");ok(q.secondCall.args[0]===this.vent,"second call to stopListening should be called with the pluggable actions");equal(q.secondCall.args[1],"before:perspectiveRerender","second call to stopListening should be called with the appropriate event")});test("controller stops listening to pluggable info view and vent when it fires close",function(){var r=this.mockPluggableInfoView();var p=this.buildController();var q=this.sandbox.spy(p,"stopListening");p.show({});equal(q.callCount,0,"stopListening() should not yet have been called");r.trigger("close");equal(q.callCount,2,"stopListening() should have been called twice");ok(q.firstCall.args[0]===r,"first call to stopListening() should have been called with the pluggable info view");ok(q.secondCall.args[0]===this.vent,"second call to stopListening should be called with the pluggable info");equal(q.secondCall.args[1],"before:perspectiveRerender","second call to stopListening should be called with the appropriate event")});test("pluggable actions view is disabled when vent is fired with before:perspectiveRerender",function(){var q=this.mockPluggableView();var p=this.buildController();p.show({});equal(q.disable.callCount,0,"stopListening() should not yet have been called");this.vent.trigger("before:perspectiveRerender");equal(q.disable.callCount,1,"stopListening() should have been called once")});test("pluggable info view is disabled when vent is fired with before:perspectiveRerender",function(){var q=this.mockPluggableInfoView();var p=this.buildController();p.show({});equal(q.disable.callCount,0,"stopListening() should not yet have been called");this.vent.trigger("before:perspectiveRerender");equal(q.disable.callCount,1,"stopListening() should have been called once")});test("show triggers an 'administration.workflow.open.view.project' event when not editing.",function(){this.sandbox.spy(j,"triggerEditProject");this.sandbox.spy(j,"triggerViewProject");this.model.set("editing",false);this.controller.show();sinon.assert.calledWith(j.triggerViewProject,false);sinon.assert.notCalled(j.triggerEditProject)});test("show triggers an 'administration.workflow.open.edit.project' event when editing.",function(){this.sandbox.spy(j,"triggerEditProject");this.sandbox.spy(j,"triggerViewProject");this.model.set("editing",true);this.controller.show();sinon.assert.calledWith(j.triggerEditProject,false);sinon.assert.notCalled(j.triggerViewProject)});test("getPerspectiveModel() returns correct information",function(){var p=this.controller.getPerspectiveModel();equal(p.get("id"),"workflow","id should be 'workflow'");equal(p.get("name"),"admin.issuetypeconfig.perspective.workflow.name","name should be 'Workflow'")});test("analytics event for user with workflow edit permission fired when info view fires click:discard and discard succeeds",function(){this.setEditWorkflowPermission();this.sandbox.spy(j,"triggerDiscardEditedWorkflow");this.workflowDesignerMock.discardDraft.returns(new i().resolve());var q=this.mockPluggableInfoView();var p=this.buildController();p.show({});q.trigger("click:discard");sinon.assert.calledWith(j.triggerDiscardEditedWorkflow,true)});test("analytics event for user with workflow edit permission  fired when info view fires click:publish and publish succeeds",function(){this.setEditWorkflowPermission();this.sandbox.spy(j,"triggerPublishEditedWorkflow");this.workflowDesignerMock.publishDraft.returns(new i().resolve());var q=this.mockPluggableInfoView();var p=this.buildController();p.show({});q.trigger("click:publish");sinon.assert.calledWith(j.triggerPublishEditedWorkflow,true)});test("show triggers an 'administration.workflow.open.view.project' event for project admin when not editing.",function(){this.setEditWorkflowPermission();this.sandbox.spy(j,"triggerEditProject");this.sandbox.spy(j,"triggerViewProject");this.model.set("editing",false);this.controller.show();sinon.assert.calledWith(j.triggerViewProject,true);sinon.assert.notCalled(j.triggerEditProject)});test("show triggers an 'administration.workflow.open.edit.project' event for project admin when editing.",function(){this.setEditWorkflowPermission();this.sandbox.spy(j,"triggerEditProject");this.sandbox.spy(j,"triggerViewProject");this.model.set("editing",true);this.controller.show();sinon.assert.calledWith(j.triggerEditProject,true);sinon.assert.notCalled(j.triggerViewProject)})});