AJS.test.require(["com.atlassian.jira.jira-project-config-plugin:issuetypes-tab","com.atlassian.jira.jira-project-config-plugin:issuetypes-test-utils"],function(){var g=require("jira-project-config/marionette");var i=require("underscore");var b=require("jira-project-config/libs/chance");var e=require("jira-project-config/issuetypes/entities/test/chance-mixins");var h=require("jira-project-config/backbone");var j=require("jira-project-config/issuetypes/header/descriptor/view");var f=require("jira-project-config/issuetypes/header/perspectives/view");var a=require("jira-project-config/issuetypes/header/shared-by/view");var c=require("jira-project-config/issuetypes/header/view");var d=require("jira-project-config/issuetypes/header/readonly/view");module("JIRA.ProjectConfig.IssueTypes.Header.Controller",{createMockHeaderView:function(){var k={perspectives:{close:this.sandbox.spy(),show:this.sandbox.spy()},actions:{close:this.sandbox.spy(),show:this.sandbox.spy()},descriptor:{close:this.sandbox.spy(),show:this.sandbox.spy()},sharedBy:{close:this.sandbox.spy(),show:this.sandbox.spy()},readOnly:{close:this.sandbox.spy(),show:this.sandbox.spy()},workflowInfo:{close:this.sandbox.spy(),show:this.sandbox.spy()}};this.context.mock("jira-project-config/issuetypes/header/view",function(){return k});return k},createNewHeaderController:function(k){var l=this.context.require("jira-project-config/issuetypes/header/controller");return new l(i.defaults({},k,{commands:this.commands,model:this.model,perspectives:this.defaultPerspectives,region:this.region,reqres:this.reqres,vent:this.vent}))},setup:function(){this.sandbox=sinon.sandbox.create();this.commands=new g.Wreqr.Commands();this.context=AJS.test.mockableModuleContext();this.reqres=new g.Wreqr.RequestResponse();this.vent=new g.Wreqr.EventAggregator();this.region={show:this.sandbox.spy()};this.chance=new b(1);i.extend(this.chance,new e());this.bug=this.chance.issueType();this.story=this.chance.issueType();this.project=this.chance.project();this.project.set({key:"PTE"});this.perspective1=this.chance.perspective();this.perspective2=this.chance.perspective();this.perspective3=this.chance.perspective();this.defaultPerspectives=[this.perspective1,this.perspective2,this.perspective3];this.model=new h.Model({selectedIssueType:this.bug,selectedPerspective:this.perspective1,project:this.project})},teardown:function(){this.sandbox.restore()}});test("Executing issueTypes:resetPluggableRegions closes all regions and re-initializes nothing when no options provided",function(){var k=this.createMockHeaderView();this.createNewHeaderController().show();this.commands.execute("issueTypes:resetPluggableRegions");equal(k.actions.close.callCount,1,"actions close() should have been called once");equal(k.descriptor.close.callCount,1,"descriptor close() should have been called once");equal(k.sharedBy.close.callCount,1,"sharedBy close() should have been called once");equal(k.readOnly.close.callCount,1,"readOnly close() should have been called once");equal(k.workflowInfo.close.callCount,1,"workflowInfo close() should have been called once");sinon.assert.notCalled(k.actions.show,"actions show() should not have been called");sinon.assert.notCalled(k.descriptor.show,"descriptor show() should not have been called");sinon.assert.notCalled(k.sharedBy.show,"sharedBy show() should not have been called");sinon.assert.notCalled(k.readOnly.show,"readOnly show() should not have been called");sinon.assert.notCalled(k.workflowInfo.show,"workflowInfo show() should not have been called")});test("Executing issueTypes:resetPluggableRegions shows descriptor view in header when descriptor in options",function(){var k=this.createMockHeaderView();var m=this.sandbox.spy(j);this.context.mock("jira-project-config/issuetypes/header/descriptor/view",m);var l=this.chance.headerDescriptor();this.createNewHeaderController().show();equal(k.descriptor.show.callCount,0,"show() should not yet have been called");this.commands.execute("issueTypes:resetPluggableRegions",{descriptor:l});equal(k.descriptor.show.callCount,1,"show() should have been called once");ok(k.descriptor.show.firstCall.args[0] instanceof j,"View passed to show() should be the descriptor view");deepEqual(m.firstCall.args[0],{model:l},"Model passed to View should be that which is passed to issueTypes:resetPluggableRegions")});test("Executing issueTypes:resetPluggableRegions shows shared by view in header when shared by data in options",function(){var l=this.createMockHeaderView();var m=this.chance.sharedByData();var k=this.sandbox.spy(a);this.context.mock("jira-project-config/issuetypes/header/shared-by/view",k);this.createNewHeaderController().show();equal(l.sharedBy.show.callCount,0,"show() should not yet have been called");this.commands.execute("issueTypes:resetPluggableRegions",{sharedBy:m});equal(l.sharedBy.show.callCount,1,"show() should have been called once");ok(l.sharedBy.show.firstCall.args[0] instanceof a,"View passed to show() should be the shared by view");deepEqual(k.firstCall.args[0],{model:m},"Model passed to View should be that which is passed to issueTypes:resetPluggableRegions")});test("Executing issueTypes:resetPluggableRegions shows actions view in header when actions in options",function(){var l=this.createMockHeaderView();var k=new h.View();this.createNewHeaderController().show();equal(l.actions.show.callCount,0,"show() should not yet have been called");this.commands.execute("issueTypes:resetPluggableRegions",{actions:k});equal(l.actions.show.callCount,1,"show() should have been called once");ok(l.actions.show.firstCall.args[0]===k,"View passed to show() should be the view created")});test("Executing issueTypes:resetPluggableRegions shows info view in header when info in options",function(){var l=this.createMockHeaderView();var k=new h.View();this.createNewHeaderController().show();equal(l.workflowInfo.show.callCount,0,"show() should not yet have been called");this.commands.execute("issueTypes:resetPluggableRegions",{info:k});equal(l.workflowInfo.show.callCount,1,"show() should have been called once");ok(l.workflowInfo.show.firstCall.args[0]===k,"View passed to show() should be the view created")});test("Executing issueTypes:resetPluggableRegions shows readonly lozenge in header when workflow in options",function(){var k=this.createMockHeaderView();var m=new h.Model();var l=this.sandbox.spy(d);this.context.mock("jira-project-config/issuetypes/header/readonly/view",l);this.createNewHeaderController().show();sinon.assert.notCalled(k.readOnly.show,"show() should not yet have been called");this.commands.execute("issueTypes:resetPluggableRegions",{workflow:m});equal(k.readOnly.show.callCount,1,"show() should have been called once");ok(k.readOnly.show.firstCall.args[0] instanceof d)});test("show() renders a Header view in the provided region",function(){this.context.mock("jira-project-config/issuetypes/header/view",c);this.createNewHeaderController().show();equal(this.region.show.callCount,1,"show() should not yet have been called.");ok(this.region.show.firstCall.args[0] instanceof c)});test("show() renders Perspectives view in the perspectives region of the Header",function(){this.context.mock("jira-project-config/issuetypes/header/perspectives/view",f);var l=this.createMockHeaderView();var k=this.createNewHeaderController();equal(l.perspectives.show.callCount,0,"show() should not yet have been called.");k.show();equal(l.perspectives.show.callCount,1,"show() should not yet have been called.");ok(l.perspectives.show.firstCall.args[0] instanceof f,"parameter passed to show() should be a Perspectives View")});test("When Perspectives view fires perspective:selected, a header:perspectiveSelected event is fired on vent",function(){var k=this.sandbox.spy();this.vent.on("header:perspectiveSelected",k);var m=new h.View();var l=this.sandbox.stub().returns(m);this.context.mock("jira-project-config/issuetypes/header/perspectives/view",l);this.createNewHeaderController().show();equal(k.callCount,0,"header:perspectiveSelected should not yet have been fired");m.trigger("perspective:selected",this.perspective3);equal(k.callCount,1,"header:perspectiveSelected should have been fired once");equal(k.firstCall.args[0],this.perspective3,"header:perspectiveSelected should have been fired with correct parameter")});test("When Shared by view is displayed, and it fires issueType:selected, a header:issueTypeSelected is fired on vent",function(){var l=this.sandbox.spy();this.vent.on("header:issueTypeSelected",l);var m=new h.View();var k=this.sandbox.stub().returns(m);this.context.mock("jira-project-config/issuetypes/header/shared-by/view",k);this.createNewHeaderController().show();this.commands.execute("issueTypes:resetPluggableRegions",{sharedBy:new h.Model()});equal(l.callCount,0,"header:issueTypeSelected should not yet have been fired");m.trigger("issueType:selected",this.story);equal(l.callCount,1,"header:issueTypeSelected should have been fired once");equal(l.firstCall.args[0],this.story,"header:issueTypeSelected should have been fired with correct parameter")});test("When Shared by view is displayed, and it fires close, controller stops listening to it",function(){var n=new h.View();var m=this.sandbox.stub().returns(n);this.context.mock("jira-project-config/issuetypes/header/shared-by/view",m);var k=this.createNewHeaderController();k.show();var l=this.sandbox.spy(k,"stopListening");this.commands.execute("issueTypes:resetPluggableRegions",{sharedBy:new h.Model()});equal(l.callCount,0,"stopListening() should not yet have been called");n.trigger("close");equal(l.callCount,1,"stopListening() should have been called once");ok(l.firstCall.args[0]===n,"stopListening() should have been called with the shared by view")});test("When Perspectives view is displayed, and it fires close, controller stops listening to it",function(){var n=new h.View();var m=this.sandbox.stub().returns(n);this.context.mock("jira-project-config/issuetypes/header/perspectives/view",m);var k=this.createNewHeaderController();k.show();var l=this.sandbox.spy(k,"stopListening");equal(l.callCount,0,"stopListening() should not yet have been called");n.trigger("close");equal(l.callCount,1,"stopListening() should have been called once");ok(l.firstCall.args[0]===n,"stopListening() should have been called with the perspectives view")})});