define("jira-project-config/issuetypes/entities/manager",["require"],function(require){var Deferred=require("jira/jquery/deferred");var jQuery=require("jquery");var _=require("underscore");var Project=require("jira-project-config/issuetypes/entities/models/project");var Projects=require("jira-project-config/issuetypes/entities/models/projects");var IssueTypes=require("jira-project-config/issuetypes/entities/models/issue-types");var IssueType=require("jira-project-config/issuetypes/entities/models/issue-type");var IssueTypeLink=require("jira-project-config/issuetypes/entities/models/issue-type-link");var IssueTypeLinks=require("jira-project-config/issuetypes/entities/models/issue-type-links");var Fields=require("jira-project-config/issuetypes/entities/models/fields");var Workflow=require("jira-project-config/issuetypes/entities/models/workflow");var ProjectIssueTypeManager=require("jira-project-config/issuetypes/entities/ajax/project-issue-type-manager");var WorkflowDesignerProjectConfigAJAXManager=JIRA.WorkflowDesigner.IO.AJAX.ProjectConfigAJAXManager;var PREFERRED_PERSPECTIVE_LOCAL_STORAGE_KEY="projectConfig:issueTypes:preferredPerspective";var supportsLocalStorage=!!window.localStorage;function makeIssueType(data){return new IssueType({id:data.id,name:data.name})}function getProjectData(){var id=jQuery("meta[name=projectId]").attr("content");var key=jQuery("meta[name=projectKey]").attr("content");var nameElement=jQuery("#project-config-header-name");var data={};if(id!==undefined){data.id=parseInt(id,0)}if(key!==undefined){data.key=key}if(nameElement.length){data.name=nameElement.text()}return new Project(data)}function getIssueTypesData(){var data=jQuery("#project_issuetypes").data("issueTypes");var issueTypes=_.map(data,makeIssueType);return new IssueTypes(issueTypes)}function makeProjects(projectsData){var projects=_.map(projectsData,function makeProject(projectData){var project=_.pick(projectData,"id","key","name");return new Project(project)});return new Projects(projects)}function makeIssueTypes(ids,lookup){return new IssueTypes(_.map(ids,_.bind(lookup.get,lookup)))}function makeError(jqXHR){var statusText=jqXHR.statusText;var statusCode=jqXHR.status;var error={};if(statusText==="abort"){error.type="abort"}else{if(statusCode===401){error.type="unauthenticated"}else{error.type="error"}}if(_.contains([400,403,404],statusCode)&&jqXHR.responseText){try{error.message=JSON.parse(jqXHR.responseText).errorMessages[0]}catch(e){error.message=jqXHR.responseText}}return error}var Manager=function(options){_.defaults(options,{projectIssueTypeAjaxManager:new ProjectIssueTypeManager({reqres:options.reqres})});this._issueTypes=null;this._project=null;_.extend(this,_.pick(options,"reqres","projectIssueTypeAjaxManager"))};Manager.prototype={workflowLayoutData:function(workflow,requireDraft){requireDraft=arguments.length===1?false:requireDraft;var api=requireDraft?"loadOrCreateDraftWorkflow":"loadDraftWorkflowIfAvailable";return WorkflowDesignerProjectConfigAJAXManager[api]({name:workflow.get("name")}).pipe(function(isDraft,layoutData){return jQuery.when({isDraft:isDraft,layoutData:layoutData})},function(errorMessage){return Deferred().reject({type:"error",message:errorMessage}).promise()})},issueTypes:function(){if(!this._issueTypes){this._issueTypes=getIssueTypesData()}return jQuery.when(this._issueTypes)},issueTypeLinks:function(){var deferred=Deferred();var self=this;jQuery.when(this.issueTypes(),this.project()).done(function(issueTypes,project){var issueTypeLinks=issueTypes.map(function(issueType){var url=self.reqres.request("urls:issueTypes:base",{project:project,issueType:issueType});return new IssueTypeLink(_.extend(issueType.pick("id","name"),{url:url}))});deferred.resolve(new IssueTypeLinks(issueTypeLinks))});return deferred.promise()},fields:function(project,issueType){var wish=Deferred();var fetchingFieldsData=this.projectIssueTypeAjaxManager.fields(project,issueType);var fetchingIssueTypes=this.issueTypes();jQuery.when(fetchingFieldsData,fetchingIssueTypes).done(function(fieldsData,issueTypes){var fields=new Fields({screenName:fieldsData.screenName,viewScreenId:fieldsData.viewScreenId,totalProjectsCount:fieldsData.totalProjectsCount,hiddenProjectsCount:fieldsData.hiddenProjectsCount,sharedWithProjects:makeProjects(fieldsData.sharedWithProjects),sharedWithIssueTypes:makeIssueTypes(fieldsData.sharedWithIssueTypes,issueTypes)});wish.resolve(fields)}).fail(_.compose(wish.reject,makeError));return wish.promise()},workflow:function(project,issueType){var wish=Deferred();var fetchingWorkflowData=this.projectIssueTypeAjaxManager.workflow(project,issueType);var fetchingIssueTypes=this.issueTypes();jQuery.when(fetchingWorkflowData,fetchingIssueTypes).done(function(workflowData,issueTypes){var workflow=new Workflow({name:workflowData.name,displayName:workflowData.displayName,state:workflowData.state,totalProjectsCount:workflowData.totalProjectsCount,hiddenProjectsCount:workflowData.hiddenProjectsCount,sharedWithProjects:makeProjects(workflowData.sharedWithProjects),sharedWithIssueTypes:makeIssueTypes(workflowData.sharedWithIssueTypes,issueTypes)});wish.resolve(workflow)}).fail(_.compose(wish.reject,makeError));return wish.promise()},project:function(){if(!this._project){this._project=getProjectData()}return Deferred().resolve(this._project).promise()},issueType:function(options){var self=this;var wish=Deferred();_.defaults(options,{fetchRelated:false});_.bindAll(wish,"reject");jQuery.when(this.project(),this.issueTypes()).pipe(function(project,issueTypes){var fetchingFields;var fetchingWorkflow;var issueType=issueTypes.get(options.id);if(issueType===undefined){return Deferred().reject({type:"error"})}issueType=issueType.clone();if(options.fetchRelated===false){return wish.resolve(issueType)}fetchingFields=self.fields(project,issueType);fetchingWorkflow=self.workflow(project,issueType);return jQuery.when(fetchingFields,fetchingWorkflow).done(function(fields,workflow){issueType.set({fields:fields,workflow:workflow});wish.resolve(issueType)})}).fail(wish.reject);return wish.promise()},getPreferredPerspective:function(){return supportsLocalStorage&&localStorage.getItem(PREFERRED_PERSPECTIVE_LOCAL_STORAGE_KEY)||"workflow"},setPreferredPerspective:function(preferredPerspective){supportsLocalStorage&&localStorage.setItem(PREFERRED_PERSPECTIVE_LOCAL_STORAGE_KEY,preferredPerspective)}};return Manager});