define("jira-project-config/issuetypes/controller",["require"],function(require){var $=require("jquery");var Marionette=require("jira-project-config/marionette");var _=require("underscore");var navigate=require("jira-project-config/navigate");var TemplateIssueTypeConfig=require("jira-project-config/issuetypes/templates");var IssueType=require("jira-project-config/issuetypes/entities/models/issue-type");var HeaderController=require("jira-project-config/issuetypes/header/controller");var FieldsController=require("jira-project-config/issuetypes/perspectives/fields/controller");var WorkflowController=require("jira-project-config/issuetypes/perspectives/workflow/controller");var IssueTypesView=require("jira-project-config/issuetypes/view");return Marionette.Controller.extend({internalEvents:{"header:issueTypeSelected":"_onIssueTypeSelected","header:perspectiveSelected":"_onPerspectiveSelected","workflow:publishComplete workflow:discardComplete":"_onPublishDiscardComplete","workflow:editWorkflow":"_onEditWorkflow"},deferredRoutes:["editWorkflow","fields","workflow"],renderingRoutes:["editWorkflow","fields","workflow"],initialize:function(options){this.application=options.application;this.model=options.model;this.request=0;this.internalVent=new Marionette.Wreqr.EventAggregator();this.view=new IssueTypesView({region:options.region});this.progressIndicatorView=new JIRA.ProjectConfig.ProgressIndicator.View();this.listenTo(this.model,"change:selectedIssueType",function(model,value){var previouslySelectedIssueType=model.previous("selectedIssueType");if(!previouslySelectedIssueType||previouslySelectedIssueType.get("id")!==value.get("id")){this.application.vent.trigger("issueTypes:issueTypeSelected",value)}});this.listenTo(this.model,"change:selectedPerspective",function(model,value){this.application.reqres.request("setPreferredPerspective",value.get("id"))});this._initializeControllers();this._initializeEventHandlers();this._initializeDeferredRouteWrappers();this._initializeRenderingRouteWrappers();this.deferredRoutesExecuting=0},issueType:function(projectId,issueTypeId){var self=this;var issueType=new IssueType({id:issueTypeId});var perspective=this.application.request("getPreferredPerspective");this.application.request("project",projectId).done(function(project){navigate(self._getUrlForPerspective(perspective,project,issueType),{replace:true})})},workflow:function(projectId,issueTypeId){var app=this.application;var self=this;var request=++this.request;var fetchingIssueType=app.request("issueType",{id:issueTypeId,fetchRelated:true});var fetchingWorkflowLayoutData=fetchingIssueType.pipe(function(issueType){return app.request("workflowLayoutData",issueType.get("workflow"))});var isCurrent=function(){return request===self.request};this._workflowQuickUiUpdates(projectId,issueTypeId);return $.when(fetchingIssueType,fetchingWorkflowLayoutData).done(function(issueType,workflowLayoutData){var url;if(!isCurrent()){return }self.model.set({editing:workflowLayoutData.isDraft,selectedIssueType:issueType});if(workflowLayoutData.isDraft){url=app.request("urls:issueTypes:editWorkflow",{project:self.model.get("project"),issueType:issueType});navigate(url,{replace:true,trigger:false})}self.workflowController.show(workflowLayoutData.layoutData)}).fail(function(error){if(!isCurrent()){return }self._handleError(error)})},editWorkflow:function(projectId,issueTypeId){var app=this.application;var request=++this.request;var self=this;var fetchingIssueType=app.request("issueType",{id:issueTypeId,fetchRelated:true});var fetchingWorkflowLayoutData=fetchingIssueType.pipe(function(issueType){return app.request("workflowLayoutData",issueType.get("workflow"),true)});var isCurrent=function(){return request===self.request};this._workflowQuickUiUpdates(projectId,issueTypeId);return $.when(fetchingIssueType,fetchingWorkflowLayoutData).done(function(issueType,workflowLayoutData){if(!isCurrent()){return }self.model.set({editing:true,selectedIssueType:issueType});self.workflowController.show(workflowLayoutData.layoutData)}).fail(function(error){if(!isCurrent()){return }self._handleError(error)})},fields:function(projectId,issueTypeId){var app=this.application;var fetchingProject=app.request("project",projectId);var fetchingSimpleIssueType=app.request("issueType",{id:issueTypeId});var fetchingFullIssueType=app.request("issueType",{id:issueTypeId,fetchRelated:true});var self=this;var request=++this.request;var isCurrent=function(){return request===self.request};$.when(fetchingProject,fetchingSimpleIssueType).done(function(project,simpleIssueType){app.title(AJS.I18n.getText("admin.issuetypeconfig.fields.title",project.get("name"),simpleIssueType.get("name")));self.model.set({editing:false,project:project,selectedIssueType:simpleIssueType,selectedPerspective:self.fieldsController.getPerspectiveModel()})});return fetchingFullIssueType.done(function(issueType){if(!isCurrent()){return }self.model.set("selectedIssueType",issueType);self.fieldsController.show()}).fail(function(error){if(!isCurrent()){return }self._handleError(error)})},summary:function(projectId){var app=this.application;app.vent.trigger("issueTypes:summarySelected");app.request("project",projectId).done(function(project){app.title(AJS.I18n.getText("admin.project.issuetypes.title",project.get("name")))})},error404:function(){this.application.execute("error:404",this.application.content)},_closeProgressIndicatorIfPresent:function(){if(this._progressIndicatorTimeoutId){clearTimeout(this._progressIndicatorTimeoutId);delete this._progressIndicatorTimeoutId;this.view.progressIndicator&&this.view.progressIndicator.close()}},_getUrlForPerspective:function(perspective,project,issueType){var url;if(perspective==="workflow"){url=this.application.reqres.request("urls:issueTypes:viewWorkflow",{project:project,issueType:issueType})}else{url=this.application.reqres.request("urls:issueTypes:viewFields",{project:project,issueType:issueType})}return url},_handleError:function(error){if(_.contains(["error","abort"],error.type)){this.application.commands.execute("error:generic",this.application.content,error.message||AJS.I18n.getText("admin.projectconfig.error.generic.message"))}else{if(error.type==="unauthenticated"){navigate(TemplateIssueTypeConfig.Urls.login({returnUrl:window.location.href}))}}},_initializeControllers:function(){this.workflowController=new WorkflowController({commands:this.application.commands,model:this.model,region:this.view.content,vent:this.internalVent});this.fieldsController=new FieldsController({commands:this.application.commands,model:this.model,region:this.view.content});this.headerController=new HeaderController({commands:this.application.commands,model:this.model,perspectives:[this.workflowController.getPerspectiveModel(),this.fieldsController.getPerspectiveModel()],region:this.view.header,vent:this.internalVent})},_displayIssueTypesView:function(){this.application.content.show(this.view);this.fieldsController.setRegion(this.view.content);this.workflowController.setRegion(this.view.content);this.headerController.setRegion(this.view.header);this.headerController.show()},_initializeDeferredRouteWrappers:function(){var instance=this;var getWrapper=function(func){var toExecute=instance[func];return function(){instance.view.setLoading();instance._maybeShowProgressIndicator();instance.deferredRoutesExecuting++;toExecute.apply(instance,arguments).always(function(){instance.deferredRoutesExecuting--;if(instance.deferredRoutesExecuting===0){instance.view.hideLoading();instance._closeProgressIndicatorIfPresent()}})}};this._wrapFunctions(this.deferredRoutes,getWrapper)},_initializeEventHandlers:function(){_.each(this.internalEvents,function(handler,events){this.listenTo(this.internalVent,events,_.bind(this[handler],this))},this)},_initializeRenderingRouteWrappers:function(){var instance=this;var getWrapper=function(func){var toExecute=instance[func];return function(){if(instance.application.content.currentView!==instance.view){this._displayIssueTypesView()}instance.internalVent.trigger("before:perspectiveRerender");toExecute.apply(instance,arguments)}};this._wrapFunctions(this.renderingRoutes,getWrapper)},_maybeShowProgressIndicator:function(){var instance=this;if(!this._progressIndicatorTimeoutId){this._progressIndicatorTimeoutId=setTimeout(function(){instance.view.progressIndicator.show(instance.progressIndicatorView)},500)}},_onIssueTypeSelected:function(issueType){var url=this._getUrlForPerspective(this.model.get("selectedPerspective").get("id"),this.model.get("project"),issueType);navigate(url)},_onPerspectiveSelected:function(perspective){var url=this._getUrlForPerspective(perspective.get("id"),this.model.get("project"),this.model.get("selectedIssueType"));navigate(url)},_onPublishDiscardComplete:function(){var url=this._getUrlForPerspective(this.model.get("selectedPerspective").get("id"),this.model.get("project"),this.model.get("selectedIssueType"));navigate(url)},_onEditWorkflow:function(){var url=this.application.reqres.request("urls:issueTypes:editWorkflow",{project:this.model.get("project"),issueType:this.model.get("selectedIssueType")});navigate(url)},_workflowQuickUiUpdates:function(projectId,issueTypeId){var self=this;var fetchingProject=this.application.request("project");var fetchingSimpleIssueType=this.application.request("issueType",{id:issueTypeId});$.when(fetchingProject,fetchingSimpleIssueType).done(function(project,simpleIssueType){self.model.set({project:project,selectedIssueType:simpleIssueType,selectedPerspective:self.workflowController.getPerspectiveModel()});self.application.title(AJS.I18n.getText("admin.issuetypeconfig.workflow.title",project.get("name"),simpleIssueType.get("name")))})},_wrapFunctions:function(functions,getWrapper){_.each(functions,function(func){this[func]=getWrapper(func)},this)}})});