AJS.test.require(["com.atlassian.jira.jira-project-config-plugin:custom-fields","com.atlassian.jira.jira-project-config-plugin:custom-fields-impl"],function(){var f=require("jquery");var d=require("underscore");var a=require("jira-project-config/custom-fields/views/forms/options-field");var c=function(h){return h.is(":enabled")};var g=function(i,h){this.$el=f(i);this.$parent=f(h)};d.extend(g.prototype,{value:function(){return f.trim(this.$el.text())},deleteOption:function(){this.$el.find(".custom-field-options-delete").click();return this},isDeleted:function(){return this.$el.closest(this.$parent).length===0},moveOption:function(h){this.$el.trigger("moveOption",h);return this},moveOnDom:function(h){this.$el.remove();if(h>0){this.$el.after(this.$parent.get(h-1))}else{this.$el.prependTo(this.$parent)}}});var e=function(h){this.$el=h;this.input=h.find("#custom-field-options-input");this.addButton=h.find("#custom-field-options-add");this.items=h.find("#custom-field-options-list-container")};d.extend(e.prototype,{error:function(){return this.$el.find("div.error").text()},optionsText:function(){return d.map(this.options(),function(h){return h.value()})},options:function(){var h=this.items;return d.map(this.items.find("li"),function(i){return new g(i,h)})},isEnabled:function(){return c(this.input)&&c(this.addButton)&&!this.items.hasClass("disabled")},isDisabled:function(){return !c(this.input)&&!c(this.addButton)&&this.items.hasClass("disabled")},option:function(h){if(d.isUndefined(h)){return this.input.val()}else{this.input.val(h);return this}},add:function(){this.addButton.click();return this},addOption:function(h){return this.option(h).add()},addOptions:function(){d.each(arguments,d.bind(this.addOption,this));return this},enter:function(){var h=f.Event("keydown",{keyCode:f.ui.keyCode.ENTER});this.input.trigger(h);return this}});module("JIRA.Admin.CustomFields.OptionsField",{setup:function(){this.sandbox=sinon.sandbox.create();this.$fixture=f("#qunit-fixture");this.field=new a({name:"name"});this.$fixture.append(this.field.render().$el);this.pageObject=new e(this.$fixture);f(document.body).focus()},teardown:function(){this.sandbox.restore()}});test("initial state",function(){ok(this.pageObject.isEnabled(),"Enabled by default?");deepEqual(this.pageObject.optionsText(),[],"No options by default.")});test("validate",function(){ok(!this.field.validate(),"Should not validate with no options.");ok(this.pageObject.error(),"Error with no options.");this.pageObject.option("One").add();ok(this.field.validate(),"Should validate with options.");ok(!this.pageObject.error(),"Error should have been removed.")});test("setError && clearError",function(){var h="Error";ok(this.field.setError(h)===this.field,"Returned this from setError");equal(this.pageObject.error(),"Error","Error displayed on the UI.");ok(this.field.clearError()===this.field,"Returned this from clearError");ok(!this.pageObject.error(),"Error cleared from UI.")});test("value",function(){deepEqual(this.field.value(),[],"No options to start with.");this.pageObject.option("  a  ").add().option("b").add();deepEqual(this.field.value(),[{name:"a"},{name:"b"}],"Correct options returned.")});test("enable && disable",function(){ok(this.field.disable()===this.field,"this returned from disable.");ok(this.pageObject.isDisabled(),"FieldOptions are disabled.");ok(this.field.enable()===this.field,"this returned from enable.");ok(this.pageObject.isEnabled(),"FieldOptions are enabled.")});var b=function(h){this.pageObject.option("    ")[h]();deepEqual(this.pageObject.optionsText(),[],"FieldOption not added?");equal(this.pageObject.option(),"    ","FieldOption input not changed.");ok(this.pageObject.error(),"Error displayed for empty option.");this.pageObject.option("something")[h]();deepEqual(this.pageObject.optionsText(),["something"],"Added option.");ok(!this.pageObject.option(),"FieldOption cleared.");this.pageObject.option("Something")[h]();deepEqual(this.pageObject.optionsText(),["something"],"FieldOption not added.");equal(this.pageObject.option(),"Something","FieldOption input not cleared.");ok(this.pageObject.error(),"FieldOption error returned.");this.pageObject.option("something2")[h]();deepEqual(this.pageObject.optionsText(),["something","something2"],"FieldOption added.");ok(!this.pageObject.option(),"FieldOption cleared.")};test("add options btn",function(){b.call(this,"add")});test("add options enter",function(){b.call(this,"enter")});test("isDirty",function(){ok(!this.field.isDirty(),"Field should not be dirty.");this.pageObject.option("something");ok(this.field.isDirty(),"Field is dirty while option being added.");this.pageObject.add();ok(this.field.isDirty(),"Field is dirty after option added.")});test("Delete",function(){this.pageObject.addOptions("jack","jill","hill");var h=this.pageObject.options();ok(h[0].deleteOption().isDeleted(),"Option was removed from DOM.");deepEqual(this.pageObject.optionsText(),["jill","hill"],"Option removed from model.");ok(h[2].deleteOption().isDeleted(),"Option was removed from DOM.");deepEqual(this.pageObject.optionsText(),["jill"],"Option removed from model.");this.field.disable();ok(!h[1].deleteOption().isDeleted(),"Option should not be deleted from DOM when view disabled.");deepEqual(this.pageObject.optionsText(),["jill"],"Option not removed from model.");this.field.enable();ok(h[1].deleteOption().isDeleted(),"Option was removed from DOM.");deepEqual(this.pageObject.optionsText(),[],"All options now removed.")});test("Reorder",function(){this.pageObject.addOptions("lemon","melon","apple","banana","strawberry");var j=0;var i=4;var h=this.pageObject.options();h[j].moveOption(i).moveOnDom(i);deepEqual(this.field.value(),[{name:"melon"},{name:"apple"},{name:"banana"},{name:"strawberry"},{name:"lemon"}],"Correct options should be returned.");j=2;i=0;h=this.pageObject.options();h[j].moveOption(i).moveOnDom(i);deepEqual(this.field.value(),[{name:"banana"},{name:"melon"},{name:"apple"},{name:"strawberry"},{name:"lemon"}],"Correct options should be returned.");j=3;i=2;this.field.disable();h=h[j].moveOption(i);deepEqual(this.field.value(),[{name:"banana"},{name:"melon"},{name:"apple"},{name:"strawberry"},{name:"lemon"}],"Correct options should be returned.")})});