AJS.test.require(["com.atlassian.jira.jira-project-config-plugin:custom-fields","com.atlassian.jira.jira-project-config-plugin:custom-fields-impl"],function(){var c=require("jira-project-config/custom-fields/views/forms/form");var i=require("jquery");var h=require("underscore");var b=c.Fields.FormField.extend({initialize:function(j){this.parent=c.Fields.FormField.prototype;this.parent.initialize.call(this,j||{})},value:function(){if(arguments.length){this._value=arguments[0];return this}else{return this._value}},setError:function(j){this._error=j},clearError:function(){delete this._error},error:function(){return this._error}});module("JIRA.Admin.CustomFields.Form.Validators",{setup:function(){this.sandbox=sinon.sandbox.create()},teardown:function(){this.sandbox.restore()}});test("always",function(){var j=c.Validators.always();ok(j(),"Always should always validate.")});test("notEmpty no error",function(){var l=new b().value(20);var j="Error";var k=c.Validators.notEmpty(j);k.call(l);ok(!l.error(),"Error not set?")});test("notEmpty error",function(){var l=new b({});var j="Error";var k=c.Validators.notEmpty(j);k.call(l);equal(l.error(),j,"Error set?")});module("JIRA.Admin.CustomFields.Form.Fields.NamedFieldMixin",{setup:function(){this.sandbox=sinon.sandbox.create();this.Field=b.extend({mixin:[c.Fields.NamedFieldMixin]})},teardown:function(){this.sandbox.restore()}});test("showRelevantErrors",function(){var k=new this.Field({name:"name"});var j="Error";ok(k.showRelevantErrors({name:j}),"Shown error?");equal(k.error(),j,"Correct error show?");ok(!k.showRelevantErrors({other:"Errors"}),"Ignored errors.");ok(!k.error(),"Previous error cleared?")});test("addValueToData",function(){var k=new this.Field({name:"name"});k.value(20);var j={};k.addValueToData(j);deepEqual(j,{name:20},"Data pulled from field?");k.value(undefined);j={};k.addValueToData(j);deepEqual(j,{},"Data ignored?");k.value(null);j={name:"Random"};k.addValueToData(j);deepEqual(j,{name:"Random"},"Data ignored?")});module("JIRA.Admin.CustomFields.Form.Fields.ValidatorMixin",{setup:function(){this.sandbox=sinon.sandbox.create();this.Field=b.extend({mixin:[c.Fields.ValidatorMixin]})},teardown:function(){this.sandbox.restore()}});test("No validator",function(){var j=new this.Field({name:"name"});ok(j.validate(),"No validator always validates?")});test("With validator",function(){var j=this.sandbox.stub();var k=new this.Field({validator:j});j.returns(false);ok(!k.validate(),"Validate method failed when validator failed?");ok(j.calledOnce,"Validator called");ok(j.firstCall.calledOn(k),"Called with field as this?");j.returns(true);ok(k.validate(),"Validate method passes when validator failed?");ok(j.calledTwice,"Validator called");ok(j.secondCall.calledOn(k),"Called with field as this?")});var f=function(j){this.$el=j};h.extend(f.prototype,{submit:function(){this.$el.submit()}});var d=function(j){this.$el=j};h.extend(d.prototype,{value:function(){if(arguments.length>0){this.$el.val(arguments[0]);return this}else{return this.$el.val()}},label:function(){return this.$el.siblings().filter("label").text()},error:function(){return this.$el.siblings().filter("div.error").text()},id:function(){return this.$el.attr("id")},enabled:function(){return !this.$el.prop("disabled")},disable:function(){this.$el.prop("disabled",true);return this},enable:function(){this.$el.prop("disabled",false);return this},isLong:function(){return this.$el.hasClass("long-field")}});var a=function(){d.apply(this,arguments)};h.extend(a.prototype,d.prototype,{maxLength:function(){return this.$el.attr("maxLength")||0},isTextField:function(){return this.$el.is("input")&&this.$el.prop("type")==="text"}});var e=function(){d.apply(this,arguments)};h.extend(e.prototype,d.prototype,{cols:function(){return this.$el.attr("cols")||0},isTextArea:function(){return this.$el.is("textarea")}});module("JIRA.Admin.CustomFields.Form",{setup:function(){this.sandbox=sinon.sandbox.create();this.Field=b.extend({mixin:[c.Fields.ValidatorMixin,c.Fields.NamedFieldMixin]});this.$fixture=i("#qunit-fixture");i(document).focus()},teardown:function(){i(document).focus();this.sandbox.restore()}});var g=function(r){var q=r.fieldParsers[0];var o=r.fieldParsers[1];var m=r.formFields[0];var l=r.formFields[1];var k=r.validator;l.setError("Error");equal(o.error(),"Error","Field has correct error");l.clearError();ok(!o.error(),"Field no longer has error");var p={field1:"Error",field2:"Error2"};var j=["global"];ok(l.showRelevantErrors(p,j));equal(o.error(),"Error2","Field rendered errors.");deepEqual(p,{field1:"Error"},"Removed errors that were displayed.");deepEqual(j,["global"],"Did not touch global errors.");p={field1:"Error"};ok(!l.showRelevantErrors(p,j));ok(!o.error(),"Field removed errors.");deepEqual(p,{field1:"Error"},"Did not touch field errors.");deepEqual(j,["global"],"Did not touch global errors.");l.disable();ok(!o.enabled(),"Disabled the field?");l.enable();ok(o.enabled(),"Enabled the field?");ok(!m.isDirty(),"The field should not be dirty.");m.value("something");ok(m.isDirty(),"The field should be dirty.");equal(q.value(),"something","Value of the field correctly set.");equal(m.value(),"something","Value correctly returned.");ok(!m.value("").isDirty(),"The field should no longer be dirty.");ok(m.validate(),"Field with no validator should always validate");ok(!l.validate(),"Field should delegate to the validator.");ok(k.calledOnce,"Validator called through the field.");ok(k.calledOn(l),"Validator called with correct scope.");ok(l.value(" something ")===l,"SetValue returns field.");equal(o.value()," something ","Value set correctly.");equal(l.value(),"something","Value returned correctly.");ok(l.value("  ")===l,"SetValue returns field.");equal(o.value(),"  ","Value set correctly.");equal(l.value(),"","Value returned correctly.");o.value("");var n={};l.addValueToData(n);deepEqual(n,{},"Empty field does not add data.");o.value("   ");l.addValueToData(n);deepEqual(n,{},"Empty field does not add data.");o.value("sadjads   \t\n");l.addValueToData(n);deepEqual(n,{field2:"sadjads"},"Empty field does not add data.")};test("text field ",function(){var k=this.sandbox.stub();var l=new c({fields:[{id:"field1",type:"text",label:"Field 1"},{id:"field2",type:"text",label:"Field 2",maxLength:255,validator:k,size:c.Fields.FormField.SIZE.large}]});this.$fixture.html(l.render().$el);var j=new a(this.$fixture.find("#field1"));var m=new a(this.$fixture.find("#field2"));equal(j.label(),"Field 1","Correct label?");equal(j.id(),"field1","Correct Id?");equal(j.maxLength(),0,"Correct maxlength?");equal(j.value(),"","Field should be empty?");ok(j.enabled(),"Field should be enabled?");ok(!j.isLong(),"Field should not be long?");ok(j.isTextField(),"Should be a text field");equal(m.label(),"Field 2","Correct label?");equal(m.id(),"field2","Correct Id?");equal(m.maxLength(),255,"Correct maxlength?");equal(m.value(),"","Field should be empty?");ok(m.enabled(),"Field should be enabled?");ok(m.isLong(),"Field should be long?");ok(m.isTextField(),"Should be a text field");g.call(this,{fieldParsers:[j,m],formFields:[l.fields.field1,l.fields.field2],validator:k})});test("textarea field",function(){var k=this.sandbox.stub();var l=new c({fields:[{id:"field1",type:"textarea",label:"Field 1"},{id:"field2",type:"textarea",label:"Field 2",cols:10,validator:k,size:c.Fields.FormField.SIZE.large}]});this.$fixture.html(l.render().$el);var j=new e(this.$fixture.find("#field1"));var m=new e(this.$fixture.find("#field2"));equal(j.label(),"Field 1","Correct label?");equal(j.id(),"field1","Correct Id?");equal(j.cols(),0,"Correct maxlength?");equal(j.value(),"","Field should be empty?");ok(j.enabled(),"Field should be enabled?");ok(!j.isLong(),"Field should not be long?");ok(j.isTextArea(),"Field is text area");equal(m.label(),"Field 2","Correct label?");equal(m.id(),"field2","Correct Id?");equal(m.cols(),10,"Correct maxlength?");equal(m.value(),"","Field should be empty?");ok(m.enabled(),"Field should be enabled?");ok(m.isLong(),"Field should be long?");ok(m.isTextArea(),"Field is text area");g.call(this,{fieldParsers:[j,m],formFields:[l.fields.field1,l.fields.field2],validator:k})});test("append field",function(){var l=this.sandbox.stub();var m=new c({fields:[{id:"field1",type:"textarea",label:"Field 1"}]});this.$fixture.html(m.render().$el);var k=m.addField({id:"field2",type:"text",label:"Field 2",validator:l,size:c.Fields.FormField.SIZE.large});ok(k===m,"this returned from form.addField");var j=new e(this.$fixture.find("#field1"));var n=new a(this.$fixture.find("#field2"));equal(j.label(),"Field 1","Correct label?");equal(j.id(),"field1","Correct Id?");equal(j.cols(),0,"Correct maxlength?");equal(j.value(),"","Field should be empty?");ok(j.enabled(),"Field should be enabled?");ok(!j.isLong(),"Field should not be long?");ok(j.isTextArea(),"Field is text area?");equal(n.label(),"Field 2","Correct label?");equal(n.id(),"field2","Correct Id?");equal(n.value(),"","Field should be empty?");ok(n.enabled(),"Field should be enabled?");ok(n.isLong(),"Field should be long?");ok(n.isTextField(),"Field is text input?");g.call(this,{fieldParsers:[j,n],formFields:[m.fields.field1,m.fields.field2],validator:l})});test("submit on form",function(){var m=this.sandbox.stub();var j=this.sandbox.stub().returns(false);var l=new c({fields:[{id:"name",type:"text",label:"Name"},{id:"description",type:"textarea",label:"Description",validator:j}]});this.$fixture.html(l.render().$el);var k=new f(this.$fixture.find("form"));l.on("submit",m);k.submit();ok(!m.called,"Submit not called when form invalid.");j.returns(true);k.submit();ok(m.calledOnce,"Submit called when form valid.")});test("submit on object",function(){var l=this.sandbox.stub();var j=this.sandbox.stub().returns(false);var k=new c({fields:[{id:"name",type:"text",label:"Name"},{id:"description",type:"textarea",label:"Description",validator:j}]});this.$fixture.html(k.render().$el);k.on("submit",l);ok(k.submit()===k,"Form returns this on submit");ok(!l.called,"Submit not called when form invalid.");j.returns(true);k.submit();ok(l.calledOnce,"Submit called when form valid.")});test("validate",function(){var k=this.sandbox.stub().returns(false);var l=new c({fields:[{id:"name",type:"text",label:"Name",validator:k},{id:"description",type:"textarea",label:"Description",validator:k}]});this.$fixture.html(l.render().$el);var j=new e(this.$fixture.find("#name"));ok(!l.validate(),"Validate must fail.");j.disable();ok(!l.validate(),"Validate must fail.");k.returns(true);ok(l.validate(),"Validate must succeed.")});test("showErrors",function(){var p=new c({fields:[{id:"name",type:"text",label:"Name"},{id:"description",type:"textarea",label:"Description"}]});var o=["Global Errors"];var j={};this.$fixture.html(p.render().$el);var l=new e(this.$fixture.find("#name"));var n=new a(this.$fixture.find("#description"));ok(!p.showErrors(j,o),"No errors rendered returns false.");j={name:"Name",description:"Description",other:"Other"};var k=h.clone(j);var m=h.clone(o);ok(p.showErrors(k,m),"Some errors returns true.");deepEqual(k,{other:"Other"},"Removed errors not displayed.");deepEqual(m,o,"Didn't touch global errors.");equal(l.error(),"Name","Name field has error");equal(n.error(),"Description","Description field has error");j={description:"Description"};k=h.clone(j);m=h.clone(m);ok(p.showErrors(k,m),"Some errors returns true.");deepEqual(k,{},"Removed errors not displayed.");deepEqual(m,o,"Didn't touch global errors.");ok(!l.error(),"Name field error should have been removed.");equal(n.error(),"Description","Description field has error");j={description:"Description",name:"Name"};k=h.clone(j);m=h.clone(m);p.blur();l.disable();ok(p.showErrors(k,m),"Some errors returns true.");deepEqual(k,{},"Removed errors not displayed.");deepEqual(m,o,"Didn't touch global errors.");equal(l.error(),"Name","Name field error should be displayed");equal(n.error(),"Description","Description field has error");p.blur()});test("enable & disable",function(){var l=new c({fields:[{id:"name",type:"text",label:"Name"},{id:"description",type:"textarea",label:"Description"}]});this.$fixture.html(l.render().$el);var j=new e(this.$fixture.find("#name"));var k=new a(this.$fixture.find("#description"));ok(j.enabled(),"The name is enabled.");ok(k.enabled(),"The description is enabled.");ok(l.disable()===l,"Form returned from disable.");ok(!j.enabled(),"The name is disabled.");ok(!k.enabled(),"The description is disabled.");ok(l.enable()===l,"Form returned from enable.");ok(j.enabled(),"The name is enabled.");ok(k.enabled(),"The description is enabled.")});test("toJson",function(){var l=new c({fields:[{id:"name",type:"text",label:"Name"},{id:"description",type:"textarea",label:"Description"}]});this.$fixture.html(l.render().$el);var j=new e(this.$fixture.find("#name"));var k=new a(this.$fixture.find("#description"));j.value("name");k.value("description");deepEqual(l.toJSON(),{name:"name",description:"description"},"Form correctly parsed.");j.value("       ");k.value("description");deepEqual(l.toJSON(),{description:"description"},"Form correctly parsed.")});test("isDirty",function(){var l=new c({fields:[{id:"name",type:"text",label:"Name"},{id:"description",type:"textarea",label:"Description"}]});this.$fixture.html(l.render().$el);var j=new e(this.$fixture.find("#name"));var k=new a(this.$fixture.find("#description"));ok(!l.isDirty(),"Should not be dirty.");j.value("name");ok(l.isDirty(),"Should be dirty.");j.value("");ok(!l.isDirty(),"Should not be dirty.");k.value("name");ok(l.isDirty(),"Should be dirty.");j.value("name");ok(l.isDirty(),"Should be dirty.");j.value("");k.value("");ok(!l.isDirty(),"Should not be dirty.")});test("Add Field With Content",function(){var j=new c({fields:[{content:function(){return i("<div>").attr("id","test-div")}},{id:"description",type:"textarea",label:"Description"}]});this.$fixture.html(j.render().$el);ok(this.$fixture.find("#test-div").length,"Added element with content.")})});