AJS.test.require(["com.atlassian.jira.jira-project-config-plugin:custom-fields","com.atlassian.jira.jira-project-config-plugin:custom-fields-impl"],function(){var d=require("jquery");var a=require("underscore");var g=require("jira-project-config/marionette");var c=require("jira-project-config/custom-fields/views/empty-type-item");var f=require("jira-project-config/custom-fields/steps/type/models/types");var e=require("jira-project-config/backbone");module("JIRA.Admin.CustomFields.FieldTypeCollectionView",{setup:function(){this.sandbox=sinon.sandbox.create();this.isSysadmin=this.sandbox.stub();this.context=AJS.test.mockableModuleContext();this.context.mock("jira/util/users/logged-in-user",{isSysadmin:this.isSysadmin});this.FieldTypeCollectionView=this.context.require("jira-project-config/custom-fields/views/field-type-collection");this.EmptyTypeItemView=c;this.Backbone=e;this.Types=f;this.types=new this.Types([{key:"a",name:"A",description:"A description"},{key:"b",name:"B",description:"B description"},{key:"c",name:"C",description:"C description"}]);this.a=this.types.models[0];this.b=this.types.models[1];this.c=this.types.models[2]},teardown:function(){this.sandbox.restore()}});var b=function(h){this.$el=h};a.extend(b.prototype,{data:function(){var h=[];this.$el.find("li.item").each(function(){var i=d(this);h.push({name:i.find("h3").text(),description:i.find("p").text(),selected:i.hasClass("selected")})});return h},hasEmpty:function(){return !!this.$el.find("li.empty").length},selectedIndex:function(){return this.$el.find(".customfields-types li.item.selected").index()},select:function(h){this.$el.find("li.item").each(function(){var i=d(this);if(i.find("h3").text()===h){i.click();return false}else{return true}})}});test("Custom field type items ordering is maintained despite add/remove from the collection",function(){var h=new this.FieldTypeCollectionView({collection:this.types});var i=new b(h.render().$el);deepEqual(a.pluck(i.data(),"name"),["A","B","C"],"Expected all types to be listed.");this.types.remove(this.b);deepEqual(a.pluck(i.data(),"name"),["A","C"],"Expected B to be omitted.");this.types.add(this.b);deepEqual(a.pluck(i.data(),"name"),["A","B","C"],"Expected all types, in their original order.");this.types.remove(this.a);this.types.remove(this.b);this.types.remove(this.c);deepEqual(a.pluck(i.data(),"name"),[],"Expected no types.")});test("When no types are in the collection, an empty message is displayed.",function(){var i=new this.Types([]);var h=new this.FieldTypeCollectionView({collection:i});var j=new b(h.render().$el);ok(j.hasEmpty(),"Expected an empty message.");i.add(this.a);ok(!j.hasEmpty(),"Expected the empty message to be removed.")});test("Modifying the collection resets the selection to the first item.",function(){var h=new this.FieldTypeCollectionView({collection:this.types});var i=new b(h.render().$el);equal(i.selectedIndex(),0,"Expected the first item to be selected.");h.selectByIndex(2);this.types.remove(this.a);equal(i.selectedIndex(),0,"Expected the new first item to still be selected.");h.selectByIndex(1);this.types.add(this.a);equal(i.selectedIndex(),0,"Expected the first item to be selected.")});test(".selectByIndex() uses 0-index",function(){var h=new this.FieldTypeCollectionView({collection:this.types});var i=new b(h.render().$el);equal(i.selectedIndex(),0,"Expected the first item to be selected.");h.selectByIndex(2);equal(i.selectedIndex(),2,"Expected the third item to be selected.")});test(".isEmpty() correctly reflects the current state",function(){var h=new this.FieldTypeCollectionView({collection:this.types});var i=new this.FieldTypeCollectionView({collection:new this.Types([])});equal(h.isEmpty(),false,"Expected the view to think it's not empty.");equal(i.isEmpty(),true,"Expected the view to think it is empty.")});test("._getEmptyView() returns the empty view instance when empty, otherwise returns false",function(){var h=new this.FieldTypeCollectionView();var k=this.sandbox.stub(h,"isEmpty");var j=g.ItemView;var i=new j();h.children.add(i);k.returns(true);ok(h._getEmptyView()===i,"Expected the empty view to be returned.");k.returns(false);ok(!h._getEmptyView(),"Expected no view to be returned.")});test("When empty, the empty view changes depending on if there are matches in other collections.",function(){var i=new this.FieldTypeCollectionView();var j={setEmptyState:this.sandbox.spy()};var h=this.sandbox.stub(i,"_getEmptyView");this.isSysadmin.returns(false);h.returns(j);j.setEmptyState.reset();i.setHasMatches(false);ok(j.setEmptyState.calledOnce,"Expected the empty view to be configured.");deepEqual(j.setEmptyState.firstCall.args,[this.EmptyTypeItemView.EMPTY],"Expected the empty view to be told not to make any suggestions.");j.setEmptyState.reset();this.isSysadmin.returns(true);i.setHasMatches(false);ok(j.setEmptyState.calledOnce,"Expected the empty view to be configured.");deepEqual(j.setEmptyState.firstCall.args,[this.EmptyTypeItemView.MARKETPLACE],"Expected the empty view to suggest checking Marketplace.");j.setEmptyState.reset();this.isSysadmin.returns(true);i.setHasMatches(true);ok(j.setEmptyState.calledOnce,"Expected the empty view to be configured.");deepEqual(j.setEmptyState.firstCall.args,[this.EmptyTypeItemView.CHANGE_TAB],"Expected the empty view to suggest other category.");j.setEmptyState.reset();this.isSysadmin.returns(false);i.setHasMatches(true);ok(j.setEmptyState.calledOnce,"Expected the empty view to be configured.");deepEqual(j.setEmptyState.firstCall.args,[this.EmptyTypeItemView.CHANGE_TAB],"Expected the empty view to suggest other category even when not sysadmin.");j.setEmptyState.reset();h.returns(false);i.setHasMatches(true);i.setHasMatches(false);ok(!j.setEmptyState.called,"Never tried to render the view.")});test("When the collection is empty, there should not be a selected item.",function(){var i=new this.FieldTypeCollectionView({collection:new this.Types([])});var h=new this.FieldTypeCollectionView({collection:this.types});ok(!i.getSelectedKey(),"When there's nothing in the collection, nothing should be selected.");ok(!i.getSelectedModel(),"When there's nothing in the collection, nothing should be selected.");this.types.reset();ok(!h.getSelectedKey(),"When the collection becomes empty, nothing should be selected.");ok(!h.getSelectedModel(),"When the collection becomes empty, nothing should be selected.")});test("When the collection is populated, it should have a selected item.",function(){var j=new this.Types([]);var i=new this.FieldTypeCollectionView({collection:j});var h=new this.FieldTypeCollectionView({collection:this.types});i.render();h.render();j.add({key:"foo",name:"Foo"});ok(i.getSelectedKey(),"As soon as an item is added to an empty collection, it should be selected.");ok(i.getSelectedModel(),"As soon as an item is added to an empty collection, it should be selected.");ok(h.getSelectedKey(),"Collections that are already full, should have a selected item.");ok(h.getSelectedModel(),"Collections that are already full, should have a selected item.")});test("Able to get selected key from view.",function(){var h=new this.FieldTypeCollectionView({collection:this.types});var m=new b(h.render().$el);equal(this.types.at(0).get("key"),h.getSelectedKey(),"Correct key being returned.");ok(this.types.at(0)===h.getSelectedModel(),"Correct model being returned.");for(var l=0;l<this.types.length;l++){var k=this.types.at(l);var j=k.get("name");m.select(j);equal(h.getSelectedKey(),k.get("key"),"Correct key being returned for '"+j+"'.");ok(k===h.getSelectedModel(),"Correct model being returned for '"+j+"'.")}})});