AJS.test.require(["jira.webresources:jira-global","jira.webresources:set-focus","com.atlassian.jira.jira-project-config-plugin:custom-fields","com.atlassian.jira.jira-project-config-plugin:custom-fields-impl"],function(){var e=require("jquery");var b=require("underscore");var g=require("jira-project-config/backbone");var f=require("jira-project-config/marionette");var a=require("jira-project-config/libs/ajshelper");var d=require("jira-project-config/custom-fields/steps/type");module("JIRA.Admin.CustomFields.TypeStep.Views.TypeChoice",{setup:function(){this.sandbox=sinon.sandbox.create();this.isSysadmin=this.sandbox.stub();this.context=AJS.test.mockableModuleContext();this.context.mock("jira/util/users/logged-in-user",{isSysadmin:this.isSysadmin});this.context.mock("jira-project-config/libs/ajshelper",a);this.TypeChoice=this.context.require("jira-project-config/custom-fields/steps/type/views/type-choice");this.Models=d.Models;this.categories=[{initial:true,id:"foo",name:"Foo",types:new this.Models.Types([{key:"a",name:"AAA",description:"A description"},{key:"b",name:"BBB",description:"B description"}])},{initial:false,id:"bar",name:"Bar",types:new this.Models.Types([{key:"c",name:"C name",description:"C description"}])}]},teardown:function(){this.sandbox.restore()}});var c=function(h){this.dialog=h};b.extend(c.prototype,{press:function(h){var i=e.ui.keyCode[h];e.event.trigger({type:"keydown",which:i,keyCode:i});return this},data:function(){var h=[];this.dialog.$el.find("ol.customfields-types:visible > li").each(function(){var i=e(this);h.push({name:i.find("h3").text(),description:i.find("p").text(),selected:i.hasClass("selected")})});return h},hasNotification:function(){return this.dialog.$el.find(".jira-dialog-notification").length>0},hasHeading:function(){var h=this.dialog.$el.find(".dialog-title").text();return !!h},hasContent:function(){return !!this.dialog.$el.find(".dialog-panel-body > div").children()},selected:function(){return b.find(this.data(),function(h){return h.selected})},selectCategory:function(h){this.dialog.$el.find(".page-menu-item:nth-child("+h+") button").click()},dblclick:function(){return this.selectedElement().dblclick()},selectedElement:function(){var h=this.dialog.$el.find(".page-menu-item.selected").index();return this.dialog.$el.find(".dialog-panel-body:nth-child("+(h+1)+") .customfields-types li.selected")},marketplaceLink:function(){return this.dialog.$el.find(".jira-icon-marketplace").parent()},visible:function(){return this.dialog.$el.is(":visible")},hasError:function(){return !!this.dialog.$el.find(".aui-message").text()},nextButton:function(){return this.dialog.$el.find(".aui-button-primary")},cancelButton:function(){return this.dialog.$el.find(".button-panel-link:last-child")},searchHasFocus:function(){return !!this.dialog.$el.find(".search input:focus").length},typeInto:function(i,h){h.val(i);h.trigger(e.Event("input"))},search:function(h){var i=this.dialog.$el.find(".search input");this.typeInto(h,i)},isDestroyed:function(){return !this.dialog.$el.parent().length}});test("Searching filters the list of types.",function(){var h=new this.TypeChoice(this.categories);h.show();var k=h.dialog;var l=new c(k);var j=l.data();var i=j[0].name;ok(j.length>0,"Expected some types to be displayed.");l.search(j[0].name);equal(l.data().length,1,"Expected the types to be limited to a single item.");equal(l.data()[0].name,i,"Expected the remaining item to be the one we searched for.");k.destroy()});test("Marketplace link is not shown on for non-sysadmins",function(){var h=new this.TypeChoice(this.categories);this.isSysadmin.returns(false);h.show();var i=h.dialog;var j=new c(i);equal(0,j.marketplaceLink().length,"Market Place link should not be visible.");i.destroy()});test("Marketplace link is shown for sysadmins",function(){var h=new this.TypeChoice(this.categories);this.isSysadmin.returns(true);h.show();var i=h.dialog;var k=new c(i);var j=k.marketplaceLink();ok(j.length,"Market Place link should be visible.");ok(j.attr("href").match(/marketplace/),"Market Place link URL should probably include 'marketplace'.");i.destroy()});test("Type choice dialog has a heading and content",function(){var h=new this.TypeChoice(this.categories);h.show();var i=h.dialog;var j=new c(i);ok(j.hasHeading(),"Dialog should have a heading.");ok(j.hasContent(),"Dialog should have content.");i.destroy()});test("Keyboard navigation works for items",function(){var h=new this.TypeChoice(this.categories);h.show();var j=h.dialog;var k=new c(j);var i=k.selected().name;k.press("DOWN");notEqual(k.selected().name,i,"Expected another item to be selected.");k.press("UP");equal(k.selected().name,i,"The original item should be selected again.");j.destroy()});test("Clicking next, pressing Enter, or double clicking proceeds to the next step",function(){var i=new this.TypeChoice(this.categories);var k=[];var h=this.categories[0].types.models[0].get("key");i.show();i.on("submit",function(m){k.push(m.get("key"))});var j=i.dialog;var l=new c(j);l.nextButton().click();equal(1,k.length,"'submit' should be triggered when clicking the next button.");equal(h,k[0],"The current key should be sent with the event.");l.press("ENTER");equal(2,k.length,"'submit' should be triggered when pressing enter.");equal(h,k[1],"The current key should be sent with the event.");l.dblclick();equal(3,k.length,"'submit' should be triggered when double clicking an item.");equal(h,k[2],"The current key should be sent with the event.");j.destroy()});test("Clicking cancel or pressing ESC attempts fires cancel event",function(){var h=new this.TypeChoice(this.categories);h.show();var j=new c(h.dialog);var i=this.sandbox.stub();h.on("cancel",i);j.cancelButton().click();ok(i.calledOnce,"The dialog should be destroyed after clicking cancel.");deepEqual(i.firstCall.args,[false],"No confirm on cancel link.");j.press("ESCAPE");ok(i.calledTwice,"The dialog should be destroyed after pressing escape.");deepEqual(i.secondCall.args,[true],"Confirm on cancel.");h.hide()});test("Shared by warning shown",function(){var i=f.ItemView.extend({render:function(){return this}});var h=new this.TypeChoice(this.categories,0,new i());h.show();var j=new c(h.dialog);ok(j.hasNotification(),"Shared by message should be shown.");h.hide()});test("Shared by warning not shown",function(){var h=new this.TypeChoice(this.categories,0);h.show();var i=new c(h.dialog);ok(!i.hasNotification(),"Shared by message should not be shown.");h.hide()});test("Analytics events are fired when the category is changed",function(){var h=new this.TypeChoice(this.categories);var j=this.sandbox.stub(a,"trigger");h.show();var k=h.dialog;var l=new c(k);function i(){var o=[];var p;for(var m=0,q=j.callCount;m<q;m++){p=j.getCall(m);if(p.args[0]==="analytics"){o.push(p)}}return o}deepEqual(i(),[],"No analytics should have occurred yet.");l.press("ENTER");equal(i().length,1,"Expected a single analytics event.");deepEqual(i()[0].args[1],{name:"administration.customfields.addwizard.submittype",data:{key:"a",category:"foo"}},"Check the content of the event.");l.selectCategory(2);equal(i().length,2,"Expected a second analytics event.");deepEqual(i()[1].args[1],{name:"administration.customfields.addwizard.changecategory",data:{id:"bar",name:"Bar"}},"Check the content of the event.");l.dblclick();equal(i().length,3,"Expected a third analytics event.");deepEqual(i()[2].args[1],{name:"administration.customfields.addwizard.submittype",data:{key:"c",category:"bar"}},"Check the content of the event.");l.nextButton().click();equal(i().length,4,"Expected a fourth analytics event.");deepEqual(i()[3].args[1],{name:"administration.customfields.addwizard.submittype",data:{key:"c",category:"bar"}},"Check the content of the event.");k.destroy()});test("When a collection view fires 'changeToAll', the first panel is shown.",function(){var m=[];var k=[];var i=this.sandbox;this.context.mock("jira-project-config/custom-fields/views/field-type-collection",function(){var p=b.extend({render:i.stub().returnsThis()},g.Events);m.push(p);return p});this.context.mock("jira-project-config/custom-fields/views/dialog/panel",function(){var q={show:i.spy(),_triggerShow:i.spy(),_triggerHide:i.spy()};k.push(q);return q});var o=this.context.require("jira-project-config/custom-fields/steps/type/views/type-choice");var h=new o(this.categories);var l;var n;var j;h.show();l=h.dialog;n=k[0];j=m[1];ok(n.show.calledOnce,"Expected the first panel to not be shown again.");j.trigger("changeToAll");ok(n.show.calledTwice,"Expected the first panel to be shown once.");j.trigger("changeToAll");ok(n.show.calledThrice,"Expected the first panel to be shown a second time.");l.destroy()});test("When the search changes, all collection views are notified if there are any matches.",function(){var m=[];var i=this.sandbox;this.context.mock("jira-project-config/custom-fields/views/field-type-collection",function(){var p=b.extend({render:i.stub().returnsThis(),setHasMatches:i.spy(),triggerMethod:i.spy()},g.Events);m.push(p);return p});var n=b.extend({render:this.sandbox.stub().returnsThis()},g.Events);this.context.mock("jira-project-config/custom-fields/views/quick-search",this.sandbox.stub().returns(n));var o=this.context.require("jira-project-config/custom-fields/steps/type/views/type-choice");var h=new o(this.categories);var l;var j;var k;h.show();l=h.dialog;j=m[0];k=m[1];n.trigger("change",{value:"AAA"});ok(j.setHasMatches.calledOnce,"Expected the first view's .setHasMatches() to be called.");ok(k.setHasMatches.calledOnce,"Expected the second view's .setHasMatches() to be called.");deepEqual(j.setHasMatches.firstCall.args,[true],"Expected the view to be told results exist.");deepEqual(k.setHasMatches.firstCall.args,[true],"Expected the view to be told results exist.");l.destroy()})});