AJS.test.require(["com.atlassian.jira.jira-project-config-plugin:custom-fields","com.atlassian.jira.jira-project-config-plugin:custom-fields-impl"],function(){var b=require("jquery");var c=require("jira-project-config/backbone");var a=require("jira/jquery/deferred");module("JIRA.Admin.CustomFields.FieldWisherStep",{setup:function(){this.sandbox=sinon.sandbox.create();this.context=AJS.test.mockableModuleContext();this.fields=[{id:"id",name:"name"}];this.api=this.mockApi({succeeds:true,args:[this.fields]});this.errorApi=this.mockApi({succeeds:false,args:["error","message"]});this.abortApi=this.mockApi({succeeds:false,args:["abort","message"]});this.dialog=this.mockDialog();this.FieldWisherStepDialog=this.sandbox.stub().returns(this.dialog);b.extend(this.FieldWisherStepDialog.prototype,{text:{heading:"heading"}});this.context.mock("jira-project-config/custom-fields/steps/field-wisher/views/dialog",this.FieldWisherStepDialog);this.errorDialog=this.mockDialog();this.ErrorDialog=this.sandbox.stub().returns(this.errorDialog);this.context.mock("jira-project-config/custom-fields/error-dialog",this.ErrorDialog);this.FieldWisherStep=this.context.require("jira-project-config/custom-fields/steps/field-wisher")},teardown:function(){this.sandbox.restore()},mockApi:function(d){return{addableFields:this.sandbox.spy(function(){var e;var f;e=a();f=d.succeeds?e.resolve:e.reject;return f.apply(e,d.args).promise()})}},mockDialog:function(){var e;var d=this.sandbox;e=b.extend({},c.Events,{showLoading:d.stub(),hideLoading:d.stub(),show:d.stub(),hide:d.stub(),destroy:d.stub(),isDirty:d.stub(),resetCanSubmit:d.stub(),resetIsSubmitted:d.stub()});return e}});test("showLoading() delegates to the dialog",function(){var d;d=new this.FieldWisherStep({api:this.api});d.start();ok(!this.dialog.showLoading.called,"showLoading() should not yet have been called.");d.showLoading();ok(this.dialog.showLoading.calledOnce,"showLoading() should not yet have been called.")});test("hideLoading() delegates to the dialog",function(){var d;d=new this.FieldWisherStep({api:this.api});d.start();ok(!this.dialog.hideLoading.called,"hideLoading() should not yet have been called.");d.hideLoading();ok(this.dialog.hideLoading.calledOnce,"hideLoading() should not yet have been called.")});test("start() creates a dialog",function(){var d;d=new this.FieldWisherStep({api:this.api});d.start();ok(this.FieldWisherStepDialog({fields:this.fields}))});test("start() creates an error dialog",function(){var d;d=new this.FieldWisherStep({api:this.errorApi});d.start();deepEqual(this.ErrorDialog.firstCall.args[0],{heading:"heading",message:"message"})});test("AJAX abort causes cancel",function(){var d;d=new this.FieldWisherStep({api:this.abortApi});var e=this.sandbox.spy(d,"fireCancel");d.start();ok(!this.errorDialog.show.called,"show() should not have been called on the error dialog");ok(!this.dialog.show.called,"show() should not have been called on the normal dialog");ok(e.calledOnce,"cancel() should have been called once")});test("dialog cancel bubbles",function(){var d;d=new this.FieldWisherStep({api:this.api});var e=this.sandbox.spy(d,"fireCancel");d.start();this.dialog.trigger("cancel",true);ok(e.calledOnce,"cancel() should be called once");ok(e.calledWith(true),"cancel() should be called with true")});test("error dialog cancel bubbles",function(){var d;d=new this.FieldWisherStep({api:this.errorApi});var e=this.sandbox.spy(d,"fireCancel");d.start();this.errorDialog.trigger("cancel");ok(e.calledOnce,"onCancelRequested should have been called once");equal(e.getCall(0).args.length,0,"There should be no arguments")});test("show() shows dialog",function(){var d;d=new this.FieldWisherStep({api:this.api});d.show();d.start();ok(!this.dialog.show.called,"show() should not yet have been called on the dialog");d.show();ok(this.dialog.show.calledOnce,"show() should have been called once on the dialog")});test("pauseStep() hides the dialog and resets it",function(){var d;d=new this.FieldWisherStep({api:this.api});d.pauseStep();d.start();ok(!d.dialog.hide.called,"pauseStep() should not yet have called hide on the dialog");ok(!d.dialog.resetCanSubmit.called,"pauseStep() should not yet have called resetCanSubmit on the dialog");ok(!d.dialog.resetIsSubmitted.called,"pauseStep() should not yet have called resetIsSubmitted on the dialog");d.pauseStep();ok(d.dialog.hide.calledOnce,"pauseStep() should have called hide on the dialog");ok(d.dialog.resetCanSubmit.calledOnce,"pauseStep() should have called resetCanSubmit on the dialog");ok(d.dialog.resetIsSubmitted.calledOnce,"pauseStep() should have called resetIsSubmitted on the dialog")});test("stopStep() destroys the dialog appropriately",function(){var d;d=new this.FieldWisherStep({api:this.api});d.stopStep();d.start();ok(!this.dialog.destroy.called,"destroy() should not yet have been called on the dialog");d.stopStep();ok(this.dialog.destroy.calledOnce,"destroy() should have been called once on the dialog")});test("doComplete() passes putFieldOnIssue and refreshIssue completes to executeCompletes when addField is true",function(){var g;g=new this.FieldWisherStep({api:this.api});g.stepData.addField=true;g.stepData.field={};var h=a();var d=this.sandbox.stub(g,"executeCompletes").returns(h.promise());var f=this.sandbox.spy();g.doComplete().done(f);var e=[g.putFieldOnIssue,g.refreshIssue];ok(d.calledOnce,"executeCompletes() should have been called once");ok(d.firstCall.calledWith(e),"executeCompletes() should have been passed the expected completes");ok(!f.called,"spy should not yet have been called");h.resolve();ok(f.calledOnce,"spy should have been called once")});test("doComplete() passes empty completes to executeCompletes when addField is false",function(){var e;e=new this.FieldWisherStep({api:this.api});e.stepData.addField=false;var d=this.sandbox.stub(e,"executeCompletes");e.doComplete();ok(d.calledOnce,"executeCompletes() should have been called once");ok(d.firstCall.calledWith([]),"executeCompletes() should have been passed the expected completes")});test("doComplete() returns rejected promise when executeCompletes returns rejected promise",function(){var d=this.sandbox.spy();var e;e=new this.FieldWisherStep({api:this.api});e.stepData.addField=true;e.stepData.field={};var f=a();this.sandbox.stub(e,"executeCompletes").returns(f.reject().promise());e.doComplete().fail(d);ok(d.calledOnce,"spy should have been called once")});test("isDirty()",function(){var d=new this.FieldWisherStep({api:this.api});ok(!d.isDirty(),"Not dirty on initial load.");d.start();this.dialog.isDirty.returns(true);ok(d.isDirty(),"Dirty if the dialog says so.");d.stepData={field:{name:"foo",id:"10101"}};ok(d.isDirty(),"Dirty when currentData exists and dialog is dirty.");this.dialog.isDirty.returns(false);ok(d.isDirty(),"Dirty when stepData has field, field.name and field.id set.")})});