/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.util;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.util.ProjectConfigRequestCache;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class ServletRequestProjectConfigRequestCache
implements ProjectConfigRequestCache {
    private static final String KEY_PREFIX = ServletRequestProjectConfigRequestCache.class.getName() + ":";
    private static final String KEY_PROJECT = "project";

    @Override
    public Project getProject() {
        Project project = (Project)this.get(KEY_PROJECT);
        if (project == null) {
            throw new IllegalStateException("The current project has not been set.");
        }
        return project;
    }

    @Override
    public void setProject(Project project) {
        this.put(KEY_PROJECT, project);
    }

    @Override
    public Object get(String key) {
        return this.getRequest().getAttribute(ServletRequestProjectConfigRequestCache.createKey(key));
    }

    @Override
    public void put(String key, Object object) {
        this.getRequest().setAttribute(ServletRequestProjectConfigRequestCache.createKey(key), object);
    }

    private static String createKey(String key) {
        return KEY_PREFIX + key;
    }

    HttpServletRequest getRequest() {
        HttpServletRequest request = ExecutingHttpRequest.get();
        if (request == null) {
            throw new IllegalStateException("No current web request is running.");
        }
        return request;
    }
}

