/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.util;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.beans.ProjectContext;
import com.atlassian.jira.projectconfig.util.ProjectContextLocator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultProjectContextLocator
implements ProjectContextLocator {
    private final ProjectService projectService;
    private final JiraAuthenticationContext authContext;

    @Autowired
    public DefaultProjectContextLocator(@ComponentImport ProjectService projectService, @ComponentImport JiraAuthenticationContext authContext) {
        this.projectService = projectService;
        this.authContext = authContext;
    }

    @Override
    @Nonnull
    public ServiceOutcome<ProjectContext> getContext(@Nonnull String projectKey, long issueTypeId) {
        ProjectService.GetProjectResult projectResult = this.projectService.getProjectByKeyForAction(this.authContext.getUser(), projectKey, ProjectAction.EDIT_PROJECT_CONFIG);
        if (!projectResult.isValid()) {
            return ServiceOutcomeImpl.from((ErrorCollection)projectResult.getErrorCollection());
        }
        IssueType type = this.getIssueType(projectResult.getProject(), issueTypeId);
        if (type != null) {
            return ServiceOutcomeImpl.ok((Object)new ProjectContext(projectResult.getProject(), type));
        }
        return ServiceOutcomeImpl.error((String)this.authContext.getI18nHelper().getText("admin.issue.type.not.in.project"), (ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND);
    }

    private IssueType getIssueType(Project project, long issueTypeId) {
        String issueTypeIdString = String.valueOf(issueTypeId);
        for (IssueType issueType : project.getIssueTypes()) {
            if (!issueType.getId().equals(issueTypeIdString)) continue;
            return issueType;
        }
        return null;
    }
}

