/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.tab;

import com.atlassian.jira.projectconfig.tab.ProjectConfigTab;
import com.atlassian.jira.projectconfig.tab.ProjectConfigTabRenderContext;
import com.atlassian.jira.projectconfig.util.VelocityContextFactory;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.model.WebPanel;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class WebPanelTab
implements ProjectConfigTab {
    private static final Logger log = Logger.getLogger(WebPanelTab.class);
    static final String HEADER_TAB_LOCATION = "tabs.admin.projectconfig.header";
    public static final String CURRENT_PROJECT = "atl.jira.admin.current.project";
    public static final String CURRENT_TAB_NAME = "atl.jira.admin.current.project.tab";
    public static final String EXTRA_URL_PARAM = "pathInfo";
    private final VelocityContextFactory factory;
    private final String id;
    private final String linkId;
    private final WebInterfaceManager webInterfaceManager;

    public WebPanelTab(WebInterfaceManager webInterfaceManager, VelocityContextFactory factory, String id, String linkId) {
        this.webInterfaceManager = webInterfaceManager;
        this.factory = factory;
        this.id = id;
        this.linkId = linkId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getLinkId() {
        return this.linkId;
    }

    @Override
    public String getTab(ProjectConfigTabRenderContext context) {
        StringBuilder contents = new StringBuilder();
        ImmutableMap velocityContext = ImmutableMap.builder().putAll(this.factory.createDefaultVelocityContext()).put((Object)CURRENT_PROJECT, (Object)context.getProject()).put((Object)CURRENT_TAB_NAME, (Object)this.id).put((Object)EXTRA_URL_PARAM, (Object)Strings.nullToEmpty((String)context.getPathInfo())).build();
        SafePluginPointAccess.to().runnable(new Runnable((Map)velocityContext, contents){
            final /* synthetic */ Map val$velocityContext;
            final /* synthetic */ StringBuilder val$contents;
            {
                this.val$velocityContext = map;
                this.val$contents = stringBuilder;
            }

            @Override
            public void run() {
                WebPanel headerPanel = WebPanelTab.this.getHeaderWebPanel(this.val$velocityContext);
                if (headerPanel != null) {
                    this.val$contents.append(headerPanel.getHtml(this.val$velocityContext));
                }
            }
        });
        SafePluginPointAccess.to().runnable(new Runnable((Map)velocityContext, contents){
            final /* synthetic */ Map val$velocityContext;
            final /* synthetic */ StringBuilder val$contents;
            {
                this.val$velocityContext = map;
                this.val$contents = stringBuilder;
            }

            @Override
            public void run() {
                WebPanel bodyPanel = WebPanelTab.this.getBodyWebPanel(this.val$velocityContext);
                if (bodyPanel != null) {
                    this.val$contents.append(bodyPanel.getHtml(this.val$velocityContext));
                }
            }
        });
        return contents.toString();
    }

    @Override
    public void addResourceForProject(ProjectConfigTabRenderContext context) {
    }

    private WebPanel getBodyWebPanel(Map<String, Object> velocityContext) {
        String panelLocation = String.format("tabs.admin.projectconfig.%s", this.id);
        return this.getWebPanel(panelLocation, velocityContext, true);
    }

    private WebPanel getHeaderWebPanel(Map<String, Object> velocityContext) {
        return this.getWebPanel(HEADER_TAB_LOCATION, velocityContext, false);
    }

    private WebPanel getWebPanel(String location, Map<String, Object> velocityContext, boolean logWarns) {
        List panels = this.webInterfaceManager.getDisplayableWebPanelDescriptors(location, velocityContext);
        if (panels.isEmpty()) {
            if (logWarns) {
                log.warn((Object)("There are no panels that match '" + location + "'."));
            }
            return null;
        }
        if (panels.size() > 1 && logWarns) {
            log.warn((Object)("There are " + panels.size() + " panels that match '" + location + "', using the first."));
        }
        return (WebPanel)((WebPanelModuleDescriptor)panels.get(0)).getModule();
    }
}

