/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.tab;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.projectconfig.tab.ProjectConfigTabRenderContext;
import com.atlassian.jira.projectconfig.tab.WebPanelTab;
import com.atlassian.jira.projectconfig.util.VelocityContextFactory;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.webresource.WebResourceManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RolesTab
extends WebPanelTab {
    private static final String OLD_ROLES_SCREEN_FEATURE_KEY = "jira.project.config.old.roles.screen";
    private final FeatureManager featureManager;

    @Autowired
    public RolesTab(WebInterfaceManager webInterfaceManager, VelocityContextFactory factory, FeatureManager featureManager) {
        super(webInterfaceManager, factory, "roles", "");
        this.featureManager = featureManager;
    }

    @Override
    public String getTitle(ProjectConfigTabRenderContext context) {
        if (this.featureManager.isEnabled(OLD_ROLES_SCREEN_FEATURE_KEY)) {
            return context.getI18NHelper().getText("admin.project.people.title", context.getProject().getName());
        }
        return context.getI18NHelper().getText("admin.project.roles.title", context.getProject().getName());
    }

    @Override
    public void addResourceForProject(ProjectConfigTabRenderContext renderContext) {
        if (this.featureManager.isEnabled(OLD_ROLES_SCREEN_FEATURE_KEY)) {
            WebResourceManager manager = renderContext.getResourceManager();
            manager.requireResource("com.atlassian.jira.jira-project-config-plugin:project-config-people");
        } else {
            renderContext.getPageBuilderService().assembler().resources().requireWebResource("com.atlassian.jira.jira-project-config-plugin:project-config-roles-init");
        }
    }

    @Override
    public String getLinkId() {
        if (this.featureManager.isEnabled(OLD_ROLES_SCREEN_FEATURE_KEY)) {
            return "view_project_people";
        }
        return "view_project_roles";
    }
}

