/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.tab;

import com.atlassian.jira.projectconfig.tab.ProjectConfigTab;
import com.atlassian.jira.projectconfig.tab.ProjectConfigTabManager;
import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultProjectConfigTabManager
implements ProjectConfigTabManager,
BeanFactoryAware,
InitializingBean,
DisposableBean {
    private final BundleContext bundleContext;
    private volatile ListableBeanFactory factory;
    @VisibleForTesting
    ServiceTracker<ProjectConfigTab, ProjectConfigTab> serviceTracker;

    @Autowired
    public DefaultProjectConfigTabManager(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (!(beanFactory instanceof ListableBeanFactory)) {
            throw new BeanInitializationException("Expecting a ListableBeanFactory.");
        }
        this.factory = (ListableBeanFactory)beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        this.serviceTracker = new ServiceTracker(this.bundleContext, ProjectConfigTab.class, null);
        this.serviceTracker.open();
    }

    @Override
    public ProjectConfigTab getTabForId(String id) {
        return this.getTabs().filter(tab -> tab.getId().equals(id)).findFirst().orElse(null);
    }

    private Stream<ProjectConfigTab> getTabs() {
        List<Object> services = Arrays.asList(this.serviceTracker.getServices((Object[])new ProjectConfigTab[0]));
        Collection localBeans = this.factory.getBeansOfType(ProjectConfigTab.class).values();
        return Stream.concat(localBeans.stream(), services.stream());
    }

    public void destroy() throws Exception {
        this.serviceTracker.close();
    }
}

