/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.shared;

import com.atlassian.jira.project.Project;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class SharedEntitiesUtils {
    public static List<Project> filterNotEqualProject(@Nullable Project currentProject, List<Project> projects) {
        return projects.stream().filter(SharedEntitiesUtils.projectNotEqual(currentProject)).collect(Collectors.toList());
    }

    public static String getOrDefaultWorkflowName(Map<String, String> issueTypeToWorkflowMap, @Nullable String issueTypeId, String defaultWorkflowName) {
        String workflowName = issueTypeToWorkflowMap.get(issueTypeId);
        return workflowName == null ? defaultWorkflowName : workflowName;
    }

    private static Predicate<Project> projectNotEqual(@Nullable Project currentProject) {
        if (currentProject == null) {
            return project -> true;
        }
        return project -> !Objects.equals(currentProject.getId(), project.getId());
    }
}

