/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.shared;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.order.OrderFactory;
import com.atlassian.jira.projectconfig.shared.SharedEntitiesUtils;
import com.atlassian.jira.projectconfig.shared.SharedIssueTypeWorkflowData;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.ProjectWorkflowSchemeHelper;
import com.atlassian.jira.workflow.WorkflowManager;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SharedEntitiesHelper {
    private final OrderFactory orderFactory;
    private final ProjectService projectService;
    private final WorkflowManager workflowManager;
    private final JiraAuthenticationContext authenticationContext;
    private final ProjectWorkflowSchemeHelper projectWorkflowSchemeHelper;

    @Autowired
    public SharedEntitiesHelper(OrderFactory orderFactory, ProjectService projectService, WorkflowManager workflowManager, JiraAuthenticationContext authenticationContext, ProjectWorkflowSchemeHelper projectWorkflowSchemeHelper) {
        this.orderFactory = orderFactory;
        this.projectService = projectService;
        this.workflowManager = workflowManager;
        this.authenticationContext = authenticationContext;
        this.projectWorkflowSchemeHelper = projectWorkflowSchemeHelper;
    }

    public SharedIssueTypeWorkflowData getSharedData(Project project, IssueType issueType, String workflowName) {
        List<Project> projects = this.getProjectsForWorkflow(project, workflowName);
        List<IssueType> issueTypes = this.getSharingIssueTypes(project, issueType, workflowName);
        List<Project> allowedProjects = this.filterSharingProjects(projects);
        return new SharedIssueTypeWorkflowData(allowedProjects, issueTypes, projects.size());
    }

    public List<Project> getProjectsForScheme(Project currentProject, Long schemeId) {
        return SharedEntitiesUtils.filterNotEqualProject(currentProject, this.projectWorkflowSchemeHelper.getProjectsForScheme(schemeId));
    }

    public List<Project> getProjectsForWorkflow(Project currentProject, String workflowName) {
        return SharedEntitiesUtils.filterNotEqualProject(currentProject, this.projectWorkflowSchemeHelper.getProjectsForWorkflow(workflowName));
    }

    public List<Project> filterSharingProjects(List<Project> allProjects) {
        return this.getAllAccessibleProjects().stream().filter(allProjects::contains).collect(Collectors.toList());
    }

    private List<IssueType> getSharingIssueTypes(Project project, IssueType currentIssueType, String workflowName) {
        List result = project.getIssueTypes().stream().filter(issueType -> !Objects.equals(issueType.getId(), currentIssueType.getId())).filter(issueType -> {
            String issueTypeWorkflowName = this.workflowManager.getWorkflow(project.getId(), issueType.getId()).getName();
            return Objects.equals(issueTypeWorkflowName, workflowName);
        }).collect(Collectors.toList());
        return this.orderFactory.createTranslatedNameOrder().immutableSortedCopy(result);
    }

    private List<Project> getAllAccessibleProjects() {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        ServiceOutcome result = this.projectService.getAllProjectsForAction(user, ProjectAction.EDIT_PROJECT_CONFIG);
        if (!result.isValid()) {
            return Collections.emptyList();
        }
        return (List)result.getReturnedValue();
    }
}

