/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.shared;

import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.projectconfig.shared.SharedEntitiesUtils;
import com.atlassian.jira.workflow.ProjectWorkflowSchemeHelper;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AllProjectsWorkflowSchemeHelper
implements ProjectWorkflowSchemeHelper {
    private final ProjectManager projectManager;
    private final WorkflowSchemeManager workflowSchemeManager;

    @Autowired
    public AllProjectsWorkflowSchemeHelper(ProjectManager projectManager, WorkflowSchemeManager workflowSchemeManager) {
        this.projectManager = projectManager;
        this.workflowSchemeManager = workflowSchemeManager;
    }

    public List<Project> getProjectsForScheme(Long schemeId) {
        return this.getAllProjects().stream().filter(project -> Objects.equals(this.getSchemeIdForProject((Project)project), schemeId)).collect(Collectors.toList());
    }

    public List<Project> getProjectsForWorkflow(String workflowName) {
        Multimap<String, Project> projectsForWorkflow = this.getProjectsForWorkflow(Collections.singleton(workflowName));
        return Lists.newArrayList((Iterable)projectsForWorkflow.get((Object)workflowName));
    }

    public Multimap<String, Project> getProjectsForWorkflow(Set<String> workflows) {
        LinkedHashMultimap result = LinkedHashMultimap.create();
        for (Project project : this.getAllProjects()) {
            Map issueTypeWorkflowMap = this.workflowSchemeManager.getWorkflowMap(project);
            String defaultWorkflow = SharedEntitiesUtils.getOrDefaultWorkflowName(issueTypeWorkflowMap, null, "jira");
            project.getIssueTypes().stream().map(IssueConstant::getId).map(issueTypeWorkflowMap::get).map(workflow -> workflow == null ? defaultWorkflow : workflow).filter(workflows::contains).forEach(arg_0 -> AllProjectsWorkflowSchemeHelper.lambda$getProjectsForWorkflow$2((Multimap)result, project, arg_0));
        }
        return result;
    }

    private List<Project> getAllProjects() {
        return this.projectManager.getProjectObjects();
    }

    private Long getSchemeIdForProject(Project project) {
        try {
            GenericValue workflowScheme = this.workflowSchemeManager.getWorkflowScheme(project);
            if (workflowScheme == null) {
                return null;
            }
            return workflowScheme.getLong("id");
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    private static /* synthetic */ void lambda$getProjectsForWorkflow$2(Multimap result, Project project, String workflow) {
        result.put((Object)workflow, (Object)project);
    }
}

