/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.rest.project;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.workflow.WorkflowSchemeService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.rest.WorkflowSchemeRestHelper;
import com.atlassian.jira.projectconfig.workflow.ProjectConfigWorkflowDispatcher;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.DraftWorkflowScheme;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.migration.WorkflowSchemeMigrationTaskAccessor;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="workflowscheme")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class WorkflowSchemeResource {
    private final JiraAuthenticationContext authContext;
    private final ProjectService projectService;
    private final ProjectConfigWorkflowDispatcher dispatcher;
    private final WorkflowSchemeService workflowSchemeService;
    private final WorkflowSchemeRestHelper helper;
    private final PermissionManager permissionManager;
    private final WorkflowSchemeMigrationTaskAccessor taskAccessor;

    public WorkflowSchemeResource(JiraAuthenticationContext authContext, ProjectService projectService, ProjectConfigWorkflowDispatcher dispatcher, WorkflowSchemeService workflowSchemeService, WorkflowSchemeRestHelper helper, PermissionManager permissionManager, WorkflowSchemeMigrationTaskAccessor taskAccessor) {
        this.authContext = authContext;
        this.projectService = projectService;
        this.dispatcher = dispatcher;
        this.workflowSchemeService = workflowSchemeService;
        this.helper = helper;
        this.permissionManager = permissionManager;
        this.taskAccessor = taskAccessor;
    }

    @GET
    @Path(value="{projectKey}")
    public Response getWorkflowSchemeInfo(@PathParam(value="projectKey") String projectKey, @QueryParam(value="original") boolean original) {
        ProjectService.GetProjectResult result = this.projectService.getProjectByKeyForAction(this.authContext.getLoggedInUser(), projectKey, ProjectAction.EDIT_PROJECT_CONFIG);
        if (result.getErrorCollection().hasAnyErrors()) {
            ErrorCollection errors = ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)result.getErrorCollection());
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errors).cacheControl(CacheControl.never()).build();
        }
        return this.generateSchemeData(result.getProject(), original);
    }

    @WebSudoRequired
    @POST
    @Path(value="{projectKey}")
    public Response createDraftWorkflowSchemeForProject(@PathParam(value="projectKey") String projectKey) {
        ServiceOutcome<ProjectConfigWorkflowDispatcher.EditSchemeResult> editResult = this.dispatcher.editScheme(projectKey);
        if (editResult.isValid()) {
            ProjectConfigWorkflowDispatcher.EditSchemeResult returnedValue = (ProjectConfigWorkflowDispatcher.EditSchemeResult)editResult.getReturnedValue();
            return this.generateSchemeData(returnedValue.getProject(), returnedValue.getWorkflowScheme(), returnedValue.getDraftWorkflowScheme());
        }
        return WorkflowSchemeRestHelper.createErrorResponse(editResult);
    }

    @WebSudoRequired
    @DELETE
    @Path(value="{projectKey}")
    public Response discardDraftWorkflowSchemeForProject(@PathParam(value="projectKey") String projectKey) {
        ApplicationUser user = this.authContext.getLoggedInUser();
        I18nHelper i18nHelper = this.authContext.getI18nHelper();
        ProjectService.GetProjectResult projectResult = this.projectService.getProjectByKeyForAction(user, projectKey, ProjectAction.EDIT_PROJECT_CONFIG);
        if (!projectResult.isValid()) {
            return WorkflowSchemeRestHelper.createErrorResponse((ServiceResult)projectResult);
        }
        Project project = projectResult.getProject();
        TaskDescriptor taskDescriptor = this.taskAccessor.getActive(project);
        if (taskDescriptor != null) {
            return WorkflowSchemeRestHelper.createErrorResponse(Response.Status.BAD_REQUEST, "admin.project.workflows.migration.progress", i18nHelper);
        }
        ServiceOutcome workflowSchemeOutcome = this.workflowSchemeService.getSchemeForProject(user, project);
        if (!workflowSchemeOutcome.isValid()) {
            return WorkflowSchemeRestHelper.createErrorResponse((ServiceResult)workflowSchemeOutcome);
        }
        AssignableWorkflowScheme scheme = (AssignableWorkflowScheme)workflowSchemeOutcome.getReturnedValue();
        ServiceOutcome draftWorkflowSchemeOutcome = this.workflowSchemeService.getDraftWorkflowSchemeNotNull(user, scheme);
        if (!draftWorkflowSchemeOutcome.isValid()) {
            return WorkflowSchemeRestHelper.createErrorResponse((ServiceResult)draftWorkflowSchemeOutcome);
        }
        DraftWorkflowScheme draftWorkflowScheme = (DraftWorkflowScheme)draftWorkflowSchemeOutcome.getReturnedValue();
        ServiceOutcome deleteWorkflowSchemeOutcome = this.workflowSchemeService.deleteWorkflowScheme(user, (WorkflowScheme)draftWorkflowScheme);
        if (!deleteWorkflowSchemeOutcome.isValid()) {
            return WorkflowSchemeRestHelper.createErrorResponse((ServiceResult)deleteWorkflowSchemeOutcome);
        }
        return this.generateSchemeData(project, scheme, null);
    }

    private Response generateSchemeData(Project project, boolean original) {
        ApplicationUser user = this.authContext.getLoggedInUser();
        ServiceOutcome originalResult = this.workflowSchemeService.getSchemeForProject(user, project);
        if (!originalResult.isValid()) {
            return WorkflowSchemeRestHelper.createErrorResponse((ServiceResult)originalResult);
        }
        AssignableWorkflowScheme originalScheme = (AssignableWorkflowScheme)originalResult.getReturnedValue();
        WorkflowSchemeRestHelper.ResponseDataBuilder builder = this.helper.builder().setUser(user).setProject(project).setAssignableWorkflowScheme(originalScheme);
        if (original || !this.permissionManager.hasPermission(0, user)) {
            return builder.build();
        }
        ServiceOutcome draftResult = this.workflowSchemeService.getDraftWorkflowScheme(user, originalScheme);
        if (!draftResult.isValid()) {
            return WorkflowSchemeRestHelper.createErrorResponse((ServiceResult)draftResult);
        }
        return builder.setDraftWorkflowScheme((DraftWorkflowScheme)draftResult.getReturnedValue()).build();
    }

    private Response generateSchemeData(Project project, AssignableWorkflowScheme currentWorkflowScheme, DraftWorkflowScheme workflowScheme) {
        return this.helper.builder().setUser(this.authContext.getLoggedInUser()).setProject(project).setAssignableWorkflowScheme(currentWorkflowScheme).setDraftWorkflowScheme(workflowScheme).build();
    }
}

