/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.rest.project;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.status.SimpleStatus;
import com.atlassian.jira.issue.status.category.StatusCategory;
import com.atlassian.jira.projectconfig.workflow.ProjectConfigWorkflowDispatcher;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowActionsBean;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@Path(value="workflow")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class WorkflowResource {
    private final ProjectConfigWorkflowDispatcher wfDispatcher;
    private final WorkflowManager workflowManager;
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionManager permissionManager;
    private final ProjectService service;
    private final WorkflowSchemeManager workflowSchemeManager;

    public WorkflowResource(ProjectConfigWorkflowDispatcher wfDispatcher, WorkflowManager workflowManager, JiraAuthenticationContext authenticationContext, PermissionManager permissionManager, ProjectService service, WorkflowSchemeManager workflowSchemeManager) {
        this.wfDispatcher = wfDispatcher;
        this.workflowManager = workflowManager;
        this.authenticationContext = authenticationContext;
        this.permissionManager = permissionManager;
        this.service = service;
        this.workflowSchemeManager = workflowSchemeManager;
    }

    @POST
    @WebSudoRequired
    public Response editWorkflowDispatcher(long projectId) {
        ServiceOutcome<Pair<String, Long>> outcome = this.wfDispatcher.editWorkflow(projectId);
        if (outcome.isValid()) {
            Pair pair = (Pair)outcome.getReturnedValue();
            return Response.ok((Object)new EditWorkflowResult((String)pair.first(), (Long)pair.second())).cacheControl(CacheControl.never()).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)outcome.getErrorCollection())).cacheControl(CacheControl.never()).build();
    }

    @GET
    public Response getWorkflow(@QueryParam(value="workflowName") String workflowName, @QueryParam(value="projectKey") String projectKey) {
        if ((workflowName = StringUtils.stripToNull((String)workflowName)) == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.never()).build();
        }
        Response response = this.hasPermission(projectKey, workflowName);
        if (response != null) {
            return response;
        }
        JiraWorkflow workflow = this.workflowManager.getWorkflow(workflowName);
        if (workflow == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.never()).build();
        }
        return Response.ok((Object)this.createWorkflowResponse(workflow)).cacheControl(CacheControl.never()).build();
    }

    WorkflowResponse createWorkflowResponse(JiraWorkflow workflow) {
        WorkflowActionsBean bean = this.createActionsBean();
        WorkflowDescriptor descriptor = workflow.getDescriptor();
        List steps = descriptor.getSteps();
        ArrayList<SimpleWorkflowSource> sources = new ArrayList<SimpleWorkflowSource>(steps.size());
        for (StepDescriptor step : steps) {
            List actions = step.getActions();
            ArrayList<SimpleWorkflowTarget> targets = new ArrayList<SimpleWorkflowTarget>(actions.size());
            SimpleStatus sourceStatus = workflow.getLinkedStatusObject(step).getSimpleStatus();
            for (ActionDescriptor action : actions) {
                int targetStepId = action.getUnconditionalResult().getStep();
                SimpleStatus targetStatus = targetStepId == -1 ? sourceStatus : workflow.getLinkedStatusObject(descriptor.getStep(targetStepId)).getSimpleStatus();
                FieldScreen fieldScreen = bean.getFieldScreenForView(action);
                SimpleScreen transitionScreen = null;
                if (fieldScreen != null) {
                    transitionScreen = new SimpleScreen(fieldScreen);
                }
                targets.add(new SimpleWorkflowTarget(WorkflowResource.status(targetStatus), action.getName(), transitionScreen));
            }
            sources.add(new SimpleWorkflowSource(WorkflowResource.status(sourceStatus), targets));
        }
        boolean isAdmin = this.permissionManager.hasPermission(0, this.authenticationContext.getLoggedInUser());
        return new WorkflowResponse(descriptor.getEntityId(), workflow.getName(), workflow.getDisplayName(), workflow.getDescription(), sources, isAdmin);
    }

    Response hasPermission(String projectKey, String workflowName) {
        ApplicationUser loggedInUser = this.authenticationContext.getLoggedInUser();
        if (this.permissionManager.hasPermission(0, loggedInUser)) {
            return null;
        }
        if ((projectKey = StringUtils.stripToNull((String)projectKey)) == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.never()).build();
        }
        ProjectService.GetProjectResult result = this.service.getProjectByKeyForAction(loggedInUser, projectKey, ProjectAction.EDIT_PROJECT_CONFIG);
        if (!result.isValid() || result.getProject() == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)result.getProject()).cacheControl(CacheControl.never()).build();
        }
        Map workflowMap = this.workflowSchemeManager.getWorkflowMap(result.getProject());
        for (IssueType types : result.getProject().getIssueTypes()) {
            String workflow = (String)workflowMap.get(types.getId());
            if (workflow == null && (workflow = (String)workflowMap.get(null)) == null) {
                workflow = "jira";
            }
            if (!workflow.equals(workflowName)) continue;
            return null;
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.never()).build();
    }

    WorkflowActionsBean createActionsBean() {
        return new WorkflowActionsBean();
    }

    private static DelegatedJsonSimpleStatus status(SimpleStatus simpleStatus) {
        return new DelegatedJsonSimpleStatus(simpleStatus);
    }

    @JsonAutoDetect
    public static class SimpleScreen {
        private final Long id;
        private final String name;

        SimpleScreen(FieldScreen screen) {
            this.id = screen.getId();
            this.name = screen.getName();
        }

        public Long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleScreen that = (SimpleScreen)o;
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
                return false;
            }
            return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
        }

        public int hashCode() {
            int result = this.id != null ? this.id.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", (Object)this.id).append("name", (Object)this.name).toString();
        }
    }

    @JsonAutoDetect
    public static class DelegatedJsonStatusCategory
    implements StatusCategory {
        private final StatusCategory statusCategory;

        public DelegatedJsonStatusCategory(StatusCategory statusCategory) {
            this.statusCategory = statusCategory;
        }

        public String getTranslatedName() {
            return this.statusCategory.getTranslatedName();
        }

        public String getTranslatedName(I18nHelper i18n) {
            return this.statusCategory.getTranslatedName(i18n);
        }

        public String getTranslatedName(String locale) {
            return this.statusCategory.getTranslatedName(locale);
        }

        public Long getId() {
            return this.statusCategory.getId();
        }

        public String getKey() {
            return this.statusCategory.getKey();
        }

        public String getName() {
            return this.statusCategory.getName();
        }

        public List<String> getAliases() {
            return this.statusCategory.getAliases();
        }

        public String getPrimaryAlias() {
            return this.statusCategory.getPrimaryAlias();
        }

        public String getColorName() {
            return this.statusCategory.getColorName();
        }

        public Long getSequence() {
            return this.statusCategory.getSequence();
        }

        public int compareTo(StatusCategory o) {
            return this.statusCategory.compareTo((Object)o);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DelegatedJsonStatusCategory that = (DelegatedJsonStatusCategory)o;
            return !(this.statusCategory != null ? !this.statusCategory.equals(that.statusCategory) : that.statusCategory != null);
        }

        public int hashCode() {
            return this.statusCategory != null ? this.statusCategory.hashCode() : 0;
        }
    }

    @JsonAutoDetect
    public static class DelegatedJsonSimpleStatus
    implements SimpleStatus {
        private final SimpleStatus delegate;
        private final DelegatedJsonStatusCategory statusCategory;

        public DelegatedJsonSimpleStatus(SimpleStatus delegate) {
            this.delegate = delegate;
            this.statusCategory = delegate.getStatusCategory() != null ? new DelegatedJsonStatusCategory(delegate.getStatusCategory()) : null;
        }

        public String getId() {
            return this.delegate.getId();
        }

        public String getName() {
            return this.delegate.getName();
        }

        public String getDescription() {
            return this.delegate.getDescription();
        }

        public StatusCategory getStatusCategory() {
            return this.statusCategory;
        }

        public String getIconUrl() {
            return this.delegate.getIconUrl();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DelegatedJsonSimpleStatus that = (DelegatedJsonSimpleStatus)o;
            return !(this.delegate != null ? !this.delegate.equals(that.delegate) : that.delegate != null);
        }

        public int hashCode() {
            return this.delegate != null ? this.delegate.hashCode() : 0;
        }
    }

    @JsonAutoDetect
    public static class SimpleWorkflowTarget {
        private final DelegatedJsonSimpleStatus toStatus;
        private final String transitionName;
        private final SimpleScreen screen;

        SimpleWorkflowTarget(DelegatedJsonSimpleStatus toStatus, String transitionName, SimpleScreen screen) {
            this.screen = screen;
            this.toStatus = toStatus;
            this.transitionName = transitionName;
        }

        SimpleWorkflowTarget(DelegatedJsonSimpleStatus toStatus, String transitionName, FieldScreen screen) {
            this(toStatus, transitionName, screen == null ? null : new SimpleScreen(screen));
        }

        public SimpleScreen getScreen() {
            return this.screen;
        }

        public DelegatedJsonSimpleStatus getToStatus() {
            return this.toStatus;
        }

        public String getTransitionName() {
            return this.transitionName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleWorkflowTarget that = (SimpleWorkflowTarget)o;
            if (this.screen != null ? !this.screen.equals(that.screen) : that.screen != null) {
                return false;
            }
            if (this.toStatus != null ? !this.toStatus.equals(that.toStatus) : that.toStatus != null) {
                return false;
            }
            return !(this.transitionName != null ? !this.transitionName.equals(that.transitionName) : that.transitionName != null);
        }

        public int hashCode() {
            int result = this.toStatus != null ? this.toStatus.hashCode() : 0;
            result = 31 * result + (this.transitionName != null ? this.transitionName.hashCode() : 0);
            result = 31 * result + (this.screen != null ? this.screen.hashCode() : 0);
            return result;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("screen", (Object)this.screen).append("toStatus", (Object)this.toStatus).append("transitionName", (Object)this.transitionName).toString();
        }
    }

    @JsonAutoDetect
    public static class SimpleWorkflowSource {
        private final DelegatedJsonSimpleStatus fromStatus;
        private final List<SimpleWorkflowTarget> targets;

        SimpleWorkflowSource(DelegatedJsonSimpleStatus fromStatus, List<SimpleWorkflowTarget> targets) {
            this.fromStatus = fromStatus;
            this.targets = targets;
        }

        public DelegatedJsonSimpleStatus getFromStatus() {
            return this.fromStatus;
        }

        public List<SimpleWorkflowTarget> getTargets() {
            return this.targets;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleWorkflowSource that = (SimpleWorkflowSource)o;
            if (this.fromStatus != null ? !this.fromStatus.equals(that.fromStatus) : that.fromStatus != null) {
                return false;
            }
            return !(this.targets != null ? !this.targets.equals(that.targets) : that.targets != null);
        }

        public int hashCode() {
            int result = this.fromStatus != null ? this.fromStatus.hashCode() : 0;
            result = 31 * result + (this.targets != null ? this.targets.hashCode() : 0);
            return result;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("fromStatus", (Object)this.fromStatus).append("targets", this.targets).toString();
        }
    }

    @JsonAutoDetect
    public static class WorkflowResponse {
        private final String name;
        private final String description;
        private final List<SimpleWorkflowSource> sources;
        private final Integer id;
        private final boolean isAdmin;
        private final String displayName;

        WorkflowResponse(Integer id, String name, String displayName, String description, List<SimpleWorkflowSource> sources, boolean isAdmin) {
            this.id = id;
            this.displayName = displayName;
            this.description = description;
            this.name = name;
            this.sources = sources;
            this.isAdmin = isAdmin;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public List<SimpleWorkflowSource> getSources() {
            return this.sources;
        }

        public Integer getId() {
            return this.id;
        }

        public boolean isAdmin() {
            return this.isAdmin;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WorkflowResponse that = (WorkflowResponse)o;
            if (this.isAdmin != that.isAdmin) {
                return false;
            }
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
                return false;
            }
            if (this.displayName != null ? !this.displayName.equals(that.displayName) : that.displayName != null) {
                return false;
            }
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            return !(this.sources != null ? !this.sources.equals(that.sources) : that.sources != null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.sources != null ? this.sources.hashCode() : 0);
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            result = 31 * result + (this.isAdmin ? 1 : 0);
            result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
            return result;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("description", (Object)this.description).append("name", (Object)this.name).append("sources", this.sources).append("id", (Object)this.id).append("isAdmin", this.isAdmin).toString();
        }
    }

    @JsonAutoDetect
    public static class EditWorkflowResult {
        private final String workflowName;
        private final Long taskId;

        EditWorkflowResult(String workflowName, Long taskId) {
            this.workflowName = workflowName;
            this.taskId = taskId;
        }

        public String getWorkflowName() {
            return this.workflowName;
        }

        public Long getTaskId() {
            return this.taskId;
        }
    }
}

