/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.rest.project;

import com.atlassian.fugue.Option;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.bc.security.login.LoginInfo;
import com.atlassian.jira.bc.security.login.LoginService;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.issue.comparator.UserCachingComparator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.rest.beans.GroupResponse;
import com.atlassian.jira.projectconfig.rest.beans.RoleActorsAddResponse;
import com.atlassian.jira.projectconfig.rest.beans.RoleMembersResponse;
import com.atlassian.jira.projectconfig.rest.beans.RolesResponse;
import com.atlassian.jira.projectconfig.rest.beans.UserResponse;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@Path(value="roles/{projectKey}")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class RolesResource {
    private static final String APPLICATION_ROLE_PREFIX = "JIRA ";
    private final ProjectRoleService roleService;
    private final ProjectService projectService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final AvatarService avatarService;
    private final LoginService loginService;
    private final DateTimeFormatter dateTimeFormatter;
    private final EmailFormatter emailFormatter;
    private final ApplicationRoleManager applicationRoleManager;
    private final UserManager userManager;

    public RolesResource(ProjectRoleService roleService, ProjectService projectService, JiraAuthenticationContext jiraAuthenticationContext, AvatarService avatarService, LoginService loginService, DateTimeFormatter dateTimeFormatter, EmailFormatter emailFormatter, ApplicationRoleManager applicationRoleManager, UserManager userManager) {
        this.roleService = roleService;
        this.projectService = projectService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.avatarService = avatarService;
        this.loginService = loginService;
        this.dateTimeFormatter = dateTimeFormatter;
        this.emailFormatter = emailFormatter;
        this.applicationRoleManager = applicationRoleManager;
        this.userManager = userManager;
    }

    @GET
    public Response getRoles(@PathParam(value="projectKey") String projectKey, @QueryParam(value="roleId") Long roleId, @QueryParam(value="query") String query, @QueryParam(value="pageNumber") @DefaultValue(value="1") int pageNumber, @QueryParam(value="pageSize") @DefaultValue(value="5") int pageSize) {
        ProjectService.GetProjectResult projectResult = this.getProjectByKey(projectKey);
        if (!projectResult.isValid()) {
            return this.toErrorResponse(projectResult.getErrorCollection());
        }
        Project project = projectResult.getProject();
        UserCachingComparator userComparator = new UserCachingComparator(this.jiraAuthenticationContext.getLocale());
        SimpleErrorCollection errors = new SimpleErrorCollection();
        Optional<String> optionalQuery = Optional.ofNullable(query).filter(q -> !q.isEmpty()).map(String::trim);
        Collection<ProjectRole> projectRoles = this.getProjectRolesById(Optional.ofNullable(roleId), errors);
        if (errors.hasAnyErrors()) {
            return this.toErrorResponse((com.atlassian.jira.util.ErrorCollection)errors);
        }
        if (pageNumber <= 0) {
            errors.addErrorMessage(this.jiraAuthenticationContext.getI18nHelper().getText("admin.project.roles.actions.search.invalid.page.num"));
            return this.toErrorResponse((com.atlassian.jira.util.ErrorCollection)errors);
        }
        if (pageSize <= 0) {
            errors.addErrorMessage(this.jiraAuthenticationContext.getI18nHelper().getText("admin.project.roles.actions.search.invalid.page.size"));
            return this.toErrorResponse((com.atlassian.jira.util.ErrorCollection)errors);
        }
        ApplicationUser loggedInUser = this.jiraAuthenticationContext.getLoggedInUser();
        int startIndex = pageSize * (pageNumber - 1);
        List<RoleMembersResponse> roleResponses = projectRoles.stream().map(this.toRoleMembersResponse(loggedInUser, project, optionalQuery, startIndex, pageSize, userComparator, errors)).collect(Collectors.toList());
        boolean showApplicationRole = this.applicationRoleManager.rolesEnabled() && this.applicationRoleManager.getRoles().size() > 1;
        return Response.ok((Object)new RolesResponse(roleResponses, showApplicationRole)).build();
    }

    @POST
    @Path(value="{roleId}")
    public Response addActorsToRole(@PathParam(value="projectKey") String projectKey, @PathParam(value="roleId") Long roleId, Map<String, String[]> actors) {
        ProjectService.GetProjectResult projectResult = this.getProjectByKey(projectKey);
        if (!projectResult.isValid()) {
            return this.toErrorResponse(projectResult.getErrorCollection());
        }
        Project project = projectResult.getProject();
        SimpleErrorCollection errors = new SimpleErrorCollection();
        ProjectRole projectRole = this.roleService.getProjectRole(roleId, (com.atlassian.jira.util.ErrorCollection)errors);
        if (errors.hasAnyErrors()) {
            return this.toErrorResponse((com.atlassian.jira.util.ErrorCollection)errors);
        }
        Optional<List<String>> groups = Optional.ofNullable(actors.get("groups")).map(Arrays::asList);
        Optional<List<String>> users = Optional.ofNullable(actors.get("users")).map(Arrays::asList);
        return this.addActorsToProjectRole(project, projectRole, groups, users, errors);
    }

    private ProjectService.GetProjectResult getProjectByKey(String projectIdOrKey) {
        return this.projectService.getProjectByKeyForAction(this.jiraAuthenticationContext.getLoggedInUser(), projectIdOrKey, ProjectAction.EDIT_PROJECT_CONFIG);
    }

    private Response toErrorResponse(com.atlassian.jira.util.ErrorCollection errors) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errors)).build();
    }

    private Collection<ProjectRole> getProjectRolesById(Optional<Long> roleId, SimpleErrorCollection errors) {
        if (roleId.isPresent()) {
            ArrayList result = Lists.newArrayList();
            ProjectRole projectRole = this.roleService.getProjectRole(roleId.get(), (com.atlassian.jira.util.ErrorCollection)errors);
            if (projectRole == null) {
                String error = this.jiraAuthenticationContext.getI18nHelper().getText("project.roles.service.error.project.role.actors.null.project.role");
                errors.addErrorMessage(error);
            } else {
                result.add(projectRole);
            }
            return result;
        }
        return this.roleService.getProjectRoles((com.atlassian.jira.util.ErrorCollection)errors);
    }

    private Function<ProjectRole, RoleMembersResponse> toRoleMembersResponse(ApplicationUser loggedInUser, Project project, Optional<String> optionalQuery, int startIndex, int pageSize, UserCachingComparator userComparator, SimpleErrorCollection errors) {
        return projectRole -> {
            List<Object> userResults;
            ProjectRoleActors projectRoleActors = this.roleService.getProjectRoleActors(projectRole, project, (com.atlassian.jira.util.ErrorCollection)errors);
            List<RoleActor> groupRoleActors = this.getGroupRoleActorsByQuery(projectRoleActors, optionalQuery);
            int totalGroups = groupRoleActors.size();
            List<GroupResponse> groupResults = this.sortAndLimitGroupResults(groupRoleActors, startIndex, pageSize);
            List<ApplicationUser> users = this.getUsersByQuery(projectRoleActors, optionalQuery);
            long totalUsers = users.size();
            int remainingPageSize = pageSize - groupResults.size();
            if (remainingPageSize > 0) {
                int userListStartIndex = startIndex + groupResults.size() - totalGroups;
                userResults = this.sortAndLimitUserResults(users, userComparator, userListStartIndex, remainingPageSize, loggedInUser);
            } else {
                userResults = Lists.newArrayList();
            }
            return new RoleMembersResponse(projectRole.getId(), projectRole.getName(), (long)totalGroups + totalUsers, groupResults, userResults);
        };
    }

    private List<RoleActor> getGroupRoleActorsByQuery(ProjectRoleActors projectRoleActors, Optional<String> query) {
        Stream<Object> roleActorStream = projectRoleActors.getRoleActorsByType("atlassian-group-role-actor").stream();
        if (query.isPresent()) {
            roleActorStream = roleActorStream.filter(roleActor -> StringUtils.containsIgnoreCase((String)roleActor.getParameter(), (String)((String)query.get())));
        }
        return roleActorStream.collect(Collectors.toList());
    }

    private List<GroupResponse> sortAndLimitGroupResults(List<RoleActor> groupRoleActors, int startIndex, int maxResults) {
        return groupRoleActors.stream().sorted((group1, group2) -> group1.getParameter().compareTo(group2.getParameter())).skip(startIndex).limit(maxResults).map(group -> new GroupResponse(group.getId(), group.getParameter())).collect(Collectors.toList());
    }

    @VisibleForTesting
    List<ApplicationUser> getUsersByQuery(ProjectRoleActors projectRoleActors, Optional<String> query) {
        Stream<ApplicationUser> userStream = projectRoleActors.getRoleActorsByType("atlassian-user-role-actor").stream().flatMap(actor -> actor.getUsers().stream()).filter(arg_0 -> ((UserManager)this.userManager).isUserExisting(arg_0));
        if (query.isPresent()) {
            String queryStr = query.get();
            userStream = userStream.filter(user -> StringUtils.containsIgnoreCase((String)user.getName(), (String)queryStr) || StringUtils.containsIgnoreCase((String)user.getDisplayName(), (String)queryStr) || StringUtils.containsIgnoreCase((String)user.getEmailAddress(), (String)queryStr));
        }
        return userStream.collect(Collectors.toList());
    }

    private List<UserResponse> sortAndLimitUserResults(List<ApplicationUser> users, UserCachingComparator userComparator, int userListStartIndex, int remainingPageSize, ApplicationUser loggedInUser) {
        boolean isEmailVisible = this.emailFormatter.emailVisible(loggedInUser);
        return users.stream().sorted((arg_0, arg_1) -> ((UserCachingComparator)userComparator).compare(arg_0, arg_1)).skip(userListStartIndex).limit(remainingPageSize).map(this.toUserResponse(loggedInUser, isEmailVisible)).collect(Collectors.toList());
    }

    private Function<ApplicationUser, UserResponse> toUserResponse(ApplicationUser loggedInUser, boolean isEmailVisible) {
        return user -> {
            String avatarUrl = this.avatarService.getAvatarURL(loggedInUser, user, Avatar.Size.SMALL).toString();
            LoginInfo loginInfo = this.loginService.getLoginInfo(user.getName());
            Option lastSession = Option.option((Object)loginInfo.getLastLoginTime()).map(lastLoginTime -> this.dateTimeFormatter.forLoggedInUser().format(new Date((long)lastLoginTime)));
            List<String> applicationRoleNames = Collections.emptyList();
            if (this.applicationRoleManager.rolesEnabled()) {
                applicationRoleNames = this.applicationRoleManager.getRolesForUser(user).stream().map(applicationRole -> {
                    String name = applicationRole.getName();
                    if (name.indexOf(APPLICATION_ROLE_PREFIX) > -1) {
                        name = name.substring(APPLICATION_ROLE_PREFIX.length());
                    }
                    return name;
                }).collect(Collectors.toList());
            }
            return UserResponse.fromApplicationUser(user, avatarUrl, (Option<String>)lastSession, isEmailVisible, applicationRoleNames);
        };
    }

    private Response addActorsToProjectRole(Project project, ProjectRole projectRole, Optional<List<String>> groups, Optional<List<String>> users, SimpleErrorCollection errors) {
        if (!groups.isPresent() && !users.isPresent()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        ProjectRoleActors allExistingRoleActors = this.roleService.getProjectRoleActors(projectRole, project, (com.atlassian.jira.util.ErrorCollection)errors);
        if (errors.hasAnyErrors()) {
            return this.toErrorResponse((com.atlassian.jira.util.ErrorCollection)errors);
        }
        int numberOfGroupsAdded = 0;
        if (groups.isPresent()) {
            List<String> groupsToAdd = this.filterActorsToAdd(groups, allExistingRoleActors, "atlassian-group-role-actor");
            this.roleService.addActorsToProjectRole(groupsToAdd, projectRole, project, "atlassian-group-role-actor", (com.atlassian.jira.util.ErrorCollection)errors);
            if (errors.hasAnyErrors()) {
                return this.toErrorResponse((com.atlassian.jira.util.ErrorCollection)errors);
            }
            numberOfGroupsAdded = groupsToAdd.size();
        }
        int numberOfUsersAdded = 0;
        if (users.isPresent()) {
            List<String> usersToAdd = this.filterActorsToAdd(users, allExistingRoleActors, "atlassian-user-role-actor");
            this.roleService.addActorsToProjectRole(usersToAdd, projectRole, project, "atlassian-user-role-actor", (com.atlassian.jira.util.ErrorCollection)errors);
            if (errors.hasAnyErrors()) {
                return this.toErrorResponse((com.atlassian.jira.util.ErrorCollection)errors);
            }
            numberOfUsersAdded = usersToAdd.size();
        }
        return Response.ok((Object)new RoleActorsAddResponse(numberOfGroupsAdded, numberOfUsersAdded)).build();
    }

    private List<String> filterActorsToAdd(Optional<List<String>> actorsToAdd, ProjectRoleActors allExistingRoleActors, String actorType) {
        Set existingActors = allExistingRoleActors.getRoleActorsByType(actorType).stream().map(RoleActor::getParameter).collect(Collectors.toSet());
        return actorsToAdd.get().stream().filter(actorToAdd -> !existingActors.contains(actorToAdd)).collect(Collectors.toList());
    }
}

