/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.rest.project;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.projectconfig.beans.ProjectContext;
import com.atlassian.jira.projectconfig.issuetypes.fields.IssueTypeConfigFieldsHelper;
import com.atlassian.jira.projectconfig.rest.Responses;
import com.atlassian.jira.projectconfig.rest.beans.SharedByData;
import com.atlassian.jira.projectconfig.util.ProjectContextLocator;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.annotate.JsonProperty;

@Path(value="issuetype/{project}/{issuetype}/fields")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IssueTypeConfigFieldsResource {
    private final IssueTypeConfigFieldsHelper fieldsHelper;
    private final ProjectContextLocator projectContextLocator;

    public IssueTypeConfigFieldsResource(IssueTypeConfigFieldsHelper fieldsHelper, ProjectContextLocator projectContextLocator) {
        this.fieldsHelper = fieldsHelper;
        this.projectContextLocator = projectContextLocator;
    }

    @GET
    public Response getFieldsData(@PathParam(value="project") String projectKey, @PathParam(value="issuetype") long issueTypeId) {
        ServiceOutcome<ProjectContext> context = this.projectContextLocator.getContext(projectKey, issueTypeId);
        if (!context.isValid()) {
            return Responses.forOutcome(context);
        }
        return Responses.ok(new FieldsDetails(this.fieldsHelper.getFieldsData((ProjectContext)context.get())));
    }

    public static class FieldsDetails
    extends SharedByData {
        @JsonProperty
        private long viewScreenId;
        @JsonProperty
        private String screenName;

        private FieldsDetails(IssueTypeConfigFieldsHelper.FieldsResult fieldsResult) {
            super(fieldsResult.getSharedBy());
            this.viewScreenId = fieldsResult.getFieldScreen().getId();
            this.screenName = fieldsResult.getFieldScreen().getName();
        }

        public long getViewScreenId() {
            return this.viewScreenId;
        }

        public String getScreenName() {
            return this.screenName;
        }

        public void setScreenName(String screenName) {
            this.screenName = screenName;
        }

        public void setViewScreenId(long viewScreenId) {
            this.viewScreenId = viewScreenId;
        }
    }
}

