/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.rest.project;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.workflow.WorkflowSchemeService;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.rest.WorkflowSchemeRestHelper;
import com.atlassian.jira.projectconfig.workflow.DraftWorkflowSchemeEditor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.DraftWorkflowScheme;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.migration.WorkflowSchemeMigrationTaskAccessor;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@Path(value="draftworkflowscheme")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class DraftWorkflowSchemeResource {
    private final DraftWorkflowSchemeEditor draftWorkflowSchemeEditor;
    private final JiraAuthenticationContext authContext;
    private final ProjectService projectService;
    private final WorkflowSchemeService workflowSchemeService;
    private final WorkflowSchemeRestHelper helper;
    private final WorkflowManager workflowManager;
    private final PermissionManager permissionManager;
    private final WorkflowSchemeMigrationTaskAccessor taskAccessor;

    public DraftWorkflowSchemeResource(JiraAuthenticationContext authContext, ProjectService projectService, WorkflowSchemeService workflowSchemeService, WorkflowSchemeRestHelper helper, WorkflowManager workflowManager, DraftWorkflowSchemeEditor draftWorkflowSchemeEditor, PermissionManager permissionManager, WorkflowSchemeMigrationTaskAccessor taskAccessor) {
        this.authContext = authContext;
        this.projectService = projectService;
        this.workflowSchemeService = workflowSchemeService;
        this.helper = helper;
        this.workflowManager = workflowManager;
        this.draftWorkflowSchemeEditor = draftWorkflowSchemeEditor;
        this.permissionManager = permissionManager;
        this.taskAccessor = taskAccessor;
    }

    @WebSudoRequired
    @PUT
    @Path(value="{projectKey}")
    public Response assignIssueTypes(@PathParam(value="projectKey") String projectKey, final AssignIssueTypesRequest request) {
        if ((projectKey = StringUtils.stripToNull((String)projectKey)) == null || !request.isValid()) {
            return WorkflowSchemeRestHelper.badRequest();
        }
        return this.changeWorkflowScheme(new ModifyOperation(){

            @Override
            public Response validate(DraftWorkflowScheme scheme, Project project, JiraWorkflow workflow) {
                HashSet projectIssueTypeIds = Sets.newHashSet((Iterable)Iterables.transform((Iterable)project.getIssueTypes(), IssueConstant::getId));
                for (String issueTypeId : request.issueTypes) {
                    if (projectIssueTypeIds.contains(issueTypeId)) continue;
                    return WorkflowSchemeRestHelper.createErrorResponse(Response.Status.BAD_REQUEST, "admin.project.workflows.bad.issue.type.for.project", DraftWorkflowSchemeResource.this.authContext.getI18nHelper());
                }
                return null;
            }

            @Override
            public DraftWorkflowScheme execute(DraftWorkflowScheme scheme, Project project, JiraWorkflow workflow) {
                return DraftWorkflowSchemeResource.this.draftWorkflowSchemeEditor.assign(scheme, request.issueTypes, request.name, project);
            }
        }, projectKey, request.name);
    }

    @WebSudoRequired
    @DELETE
    @Path(value="{projectKey}")
    public Response removeWorkflow(@PathParam(value="projectKey") String projectKey, String workflowName) {
        projectKey = StringUtils.stripToNull((String)projectKey);
        workflowName = StringUtils.stripToNull((String)workflowName);
        if (projectKey == null || workflowName == null) {
            return WorkflowSchemeRestHelper.badRequest();
        }
        return this.changeWorkflowScheme(new ModifyOperation(){

            @Override
            public Response validate(DraftWorkflowScheme scheme, Project project, JiraWorkflow workflow) {
                return null;
            }

            @Override
            public DraftWorkflowScheme execute(DraftWorkflowScheme scheme, Project project, JiraWorkflow workflow) {
                return DraftWorkflowSchemeResource.this.draftWorkflowSchemeEditor.delete(scheme, workflow.getName(), project);
            }
        }, projectKey, workflowName);
    }

    private Response changeWorkflowScheme(ModifyOperation mutator, String projectKey, String workflowName) {
        ApplicationUser user = this.authContext.getLoggedInUser();
        I18nHelper i18nHelper = this.authContext.getI18nHelper();
        if (!this.permissionManager.hasPermission(0, user)) {
            return WorkflowSchemeRestHelper.createErrorResponse(Response.Status.FORBIDDEN, "admin.workflowschemes.service.error.no.admin.permission", i18nHelper);
        }
        ProjectService.GetProjectResult projectResult = this.projectService.getProjectByKeyForAction(user, projectKey, ProjectAction.EDIT_PROJECT_CONFIG);
        if (!projectResult.isValid()) {
            return WorkflowSchemeRestHelper.createErrorResponse((ServiceResult)projectResult);
        }
        Project project = projectResult.getProject();
        TaskDescriptor taskDescriptor = this.taskAccessor.getActive(project);
        if (taskDescriptor != null) {
            return WorkflowSchemeRestHelper.createErrorResponse(Response.Status.BAD_REQUEST, "admin.project.workflows.migration.progress", i18nHelper);
        }
        JiraWorkflow workflow = this.workflowManager.getWorkflow(workflowName);
        if (workflow == null) {
            return WorkflowSchemeRestHelper.notFound();
        }
        ServiceOutcome schemeResult = this.workflowSchemeService.getSchemeForProject(user, project);
        if (!schemeResult.isValid()) {
            return WorkflowSchemeRestHelper.createErrorResponse((ServiceResult)schemeResult);
        }
        AssignableWorkflowScheme originalScheme = (AssignableWorkflowScheme)schemeResult.getReturnedValue();
        ServiceOutcome draftSchemeResult = this.workflowSchemeService.getDraftWorkflowSchemeNotNull(user, originalScheme);
        if (!draftSchemeResult.isValid()) {
            return WorkflowSchemeRestHelper.createErrorResponse((ServiceResult)draftSchemeResult);
        }
        if (this.workflowSchemeService.getUsageCount(originalScheme) != 1) {
            return WorkflowSchemeRestHelper.createErrorResponse(Response.Status.BAD_REQUEST, "admin.project.workflows.only.one.project", this.authContext.getI18nHelper());
        }
        Response validate = mutator.validate((DraftWorkflowScheme)draftSchemeResult.getReturnedValue(), project, workflow);
        if (validate != null) {
            return validate;
        }
        DraftWorkflowScheme draftWorkflowScheme = mutator.execute((DraftWorkflowScheme)draftSchemeResult.getReturnedValue(), project, workflow);
        ServiceOutcome schemeSaveResult = this.workflowSchemeService.updateWorkflowScheme(user, draftWorkflowScheme);
        if (!schemeSaveResult.isValid()) {
            return WorkflowSchemeRestHelper.createErrorResponse((ServiceResult)schemeSaveResult);
        }
        return this.helper.builder().setUser(user).setProject(project).setAssignableWorkflowScheme(originalScheme).setDraftWorkflowScheme((DraftWorkflowScheme)schemeSaveResult.getReturnedValue()).build();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AssignIssueTypesRequest {
        private final String name;
        private final List<String> issueTypes;

        @JsonCreator
        public AssignIssueTypesRequest(@JsonProperty(value="name") String name, @JsonProperty(value="issueTypes") List<String> issueTypes) {
            this.issueTypes = issueTypes;
            this.name = StringUtils.stripToNull((String)name);
        }

        public boolean isValid() {
            return this.name != null && this.issueTypes != null && !this.issueTypes.isEmpty();
        }
    }

    private static interface ModifyOperation {
        public Response validate(DraftWorkflowScheme var1, Project var2, JiraWorkflow var3);

        public DraftWorkflowScheme execute(DraftWorkflowScheme var1, Project var2, JiraWorkflow var3);
    }
}

