/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.rest.interceptor;

import com.atlassian.jira.projectconfig.rest.AdminRequired;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugins.rest.common.interceptor.MethodInvocation;
import com.atlassian.plugins.rest.common.interceptor.ResourceInterceptor;
import java.lang.reflect.InvocationTargetException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;

@Provider
public class SecurityInterceptor
implements ResourceInterceptor {
    private final JiraAuthenticationContext jac;
    private final PermissionManager permissionManager;

    public SecurityInterceptor(JiraAuthenticationContext jac, PermissionManager permissionManager) {
        this.jac = jac;
        this.permissionManager = permissionManager;
    }

    public void intercept(MethodInvocation methodInvocation) throws IllegalAccessException, InvocationTargetException {
        ApplicationUser user = this.jac.getUser();
        if (this.adminRequired(methodInvocation) && !this.permissionManager.hasPermission(0, user)) {
            methodInvocation.getHttpContext().getResponse().setResponse(Response.status((Response.Status)(user == null ? Response.Status.UNAUTHORIZED : Response.Status.FORBIDDEN)).entity((Object)ErrorCollection.of((String[])new String[]{this.jac.getI18nHelper().getText("rest.security.admin.required")})).cacheControl(CacheControl.never()).build());
        } else {
            methodInvocation.invoke();
        }
    }

    private boolean adminRequired(MethodInvocation method) {
        return method.getResource().getClass().getAnnotation(AdminRequired.class) != null;
    }
}

