/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.rest.global;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.workflow.WorkflowSchemeService;
import com.atlassian.jira.projectconfig.rest.WorkflowSchemeRestHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.DraftWorkflowScheme;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonProperty;

@Path(value="workflowschemeeditor")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@WebSudoRequired
public class WorkflowSchemeEditorResource {
    private final WorkflowSchemeService workflowSchemeService;
    private final JiraAuthenticationContext authenticationContext;
    private final WorkflowSchemeRestHelper helper;

    public WorkflowSchemeEditorResource(WorkflowSchemeService workflowSchemeService, JiraAuthenticationContext authenticationContext, WorkflowSchemeRestHelper helper) {
        this.workflowSchemeService = workflowSchemeService;
        this.authenticationContext = authenticationContext;
        this.helper = helper;
    }

    @GET
    @Path(value="{id}")
    public Response getScheme(@PathParam(value="id") long id) {
        ApplicationUser user = this.getUser();
        ServiceOutcome workflowSchemeOutcome = this.workflowSchemeService.getWorkflowScheme(user, id);
        if (!workflowSchemeOutcome.isValid()) {
            return WorkflowSchemeRestHelper.createErrorResponse((ServiceResult)workflowSchemeOutcome);
        }
        AssignableWorkflowScheme workflowScheme = (AssignableWorkflowScheme)workflowSchemeOutcome.getReturnedValue();
        ServiceOutcome draftWorkflowSchemeOutcome = this.workflowSchemeService.getDraftWorkflowScheme(user, workflowScheme);
        if (!draftWorkflowSchemeOutcome.isValid()) {
            return WorkflowSchemeRestHelper.createErrorResponse((ServiceResult)draftWorkflowSchemeOutcome);
        }
        DraftWorkflowScheme draftWorkflowScheme = (DraftWorkflowScheme)draftWorkflowSchemeOutcome.getReturnedValue();
        return this.helper.builder().setUser(user).setAssignableWorkflowScheme(workflowScheme).setDraftWorkflowScheme(draftWorkflowScheme).build();
    }

    @DELETE
    @Path(value="{id}/draft")
    public Response discardDraft(@PathParam(value="id") long id) {
        ServiceOutcome deleteOutcome;
        ApplicationUser user = this.getUser();
        ServiceOutcome workflowSchemeOutcome = this.workflowSchemeService.getWorkflowScheme(user, id);
        if (!workflowSchemeOutcome.isValid()) {
            return WorkflowSchemeRestHelper.createErrorResponse((ServiceResult)workflowSchemeOutcome);
        }
        AssignableWorkflowScheme workflowScheme = (AssignableWorkflowScheme)workflowSchemeOutcome.getReturnedValue();
        ServiceOutcome draftWorkflowSchemeOutcome = this.workflowSchemeService.getDraftWorkflowScheme(user, workflowScheme);
        if (!draftWorkflowSchemeOutcome.isValid()) {
            return WorkflowSchemeRestHelper.createErrorResponse((ServiceResult)draftWorkflowSchemeOutcome);
        }
        DraftWorkflowScheme draftWorkflowScheme = (DraftWorkflowScheme)draftWorkflowSchemeOutcome.getReturnedValue();
        if (draftWorkflowScheme != null && !(deleteOutcome = this.workflowSchemeService.deleteWorkflowScheme(user, (WorkflowScheme)draftWorkflowScheme)).isValid()) {
            return WorkflowSchemeRestHelper.createErrorResponse((ServiceResult)deleteOutcome);
        }
        return this.helper.builder().setUser(user).setAssignableWorkflowScheme(workflowScheme).build();
    }

    @PUT
    @Path(value="{id}")
    public Response assignIssueType(@PathParam(value="id") long id, final WorkflowSchemeRequest request) {
        if (StringUtils.isEmpty((String)request.workflow)) {
            return WorkflowSchemeRestHelper.badRequest();
        }
        return this.editScheme(id, new Editor(){

            @Override
            public AssignableWorkflowScheme edit(AssignableWorkflowScheme scheme) {
                AssignableWorkflowScheme.Builder builder = scheme.builder();
                WorkflowSchemeEditorResource.processAssignRequest((WorkflowScheme.Builder)builder, request);
                return builder.build();
            }

            @Override
            public DraftWorkflowScheme edit(DraftWorkflowScheme scheme) {
                DraftWorkflowScheme.Builder builder = scheme.builder();
                WorkflowSchemeEditorResource.processAssignRequest((WorkflowScheme.Builder)builder, request);
                return builder.build();
            }
        });
    }

    @DELETE
    @Path(value="{id}/workflow")
    public Response removeWorkflow(@PathParam(value="id") long id, final RemoveWorkflowRequest request) {
        if (StringUtils.isEmpty((String)request.workflow)) {
            return WorkflowSchemeRestHelper.badRequest();
        }
        return this.editScheme(id, new Editor(){

            @Override
            public AssignableWorkflowScheme edit(AssignableWorkflowScheme scheme) {
                AssignableWorkflowScheme.Builder builder = scheme.builder();
                WorkflowSchemeEditorResource.removeAndReassignDefault((WorkflowScheme.Builder)builder, request);
                return builder.build();
            }

            @Override
            public DraftWorkflowScheme edit(DraftWorkflowScheme scheme) {
                DraftWorkflowScheme.Builder builder = scheme.builder();
                WorkflowSchemeEditorResource.removeAndReassignDefault((WorkflowScheme.Builder)builder, request);
                return builder.build();
            }
        });
    }

    @DELETE
    @Path(value="{id}/issuetype")
    public Response removeIssueTypes(@PathParam(value="id") long id, final WorkflowSchemeRequest request) {
        if (StringUtils.isEmpty((String)request.workflow)) {
            return WorkflowSchemeRestHelper.badRequest();
        }
        return this.editScheme(id, new Editor(){

            @Override
            public AssignableWorkflowScheme edit(AssignableWorkflowScheme scheme) {
                AssignableWorkflowScheme.Builder builder = scheme.builder();
                WorkflowSchemeEditorResource.removeIssueTypes((WorkflowScheme.Builder)builder, request);
                return builder.build();
            }

            @Override
            public DraftWorkflowScheme edit(DraftWorkflowScheme scheme) {
                DraftWorkflowScheme.Builder builder = scheme.builder();
                WorkflowSchemeEditorResource.removeIssueTypes((WorkflowScheme.Builder)builder, request);
                return builder.build();
            }
        });
    }

    @PUT
    @Path(value="{id}/name")
    public Response updateName(@PathParam(value="id") long id, final String name) {
        if (StringUtils.isEmpty((String)name)) {
            return WorkflowSchemeRestHelper.badRequest();
        }
        return this.editScheme(id, new Function<AssignableWorkflowScheme.Builder, Void>(){

            public Void apply(AssignableWorkflowScheme.Builder input) {
                input.setName(name);
                return null;
            }
        });
    }

    @PUT
    @Path(value="{id}/description")
    public Response updateDescription(@PathParam(value="id") long id, final String description) {
        return this.editScheme(id, new Function<AssignableWorkflowScheme.Builder, Void>(){

            public Void apply(AssignableWorkflowScheme.Builder input) {
                input.setDescription(description);
                return null;
            }
        });
    }

    private Response editScheme(long id, Function<AssignableWorkflowScheme.Builder, Void> function) {
        ApplicationUser user = this.getUser();
        ServiceOutcome workflowSchemeOutcome = this.workflowSchemeService.getWorkflowScheme(user, id);
        if (!workflowSchemeOutcome.isValid()) {
            return WorkflowSchemeRestHelper.createErrorResponse((ServiceResult)workflowSchemeOutcome);
        }
        AssignableWorkflowScheme workflowScheme = (AssignableWorkflowScheme)workflowSchemeOutcome.getReturnedValue();
        AssignableWorkflowScheme.Builder builder = workflowScheme.builder();
        function.apply((Object)builder);
        workflowScheme = builder.build();
        workflowSchemeOutcome = this.workflowSchemeService.updateWorkflowScheme(user, workflowScheme);
        if (!workflowSchemeOutcome.isValid()) {
            return WorkflowSchemeRestHelper.createErrorResponse((ServiceResult)workflowSchemeOutcome);
        }
        workflowScheme = (AssignableWorkflowScheme)workflowSchemeOutcome.getReturnedValue();
        ServiceOutcome draftWorkflowSchemeOutcome = this.workflowSchemeService.getDraftWorkflowScheme(user, workflowScheme);
        if (!draftWorkflowSchemeOutcome.isValid()) {
            return WorkflowSchemeRestHelper.createErrorResponse((ServiceResult)draftWorkflowSchemeOutcome);
        }
        DraftWorkflowScheme draftWorkflowScheme = (DraftWorkflowScheme)draftWorkflowSchemeOutcome.getReturnedValue();
        return this.helper.builder().setUser(user).setAssignableWorkflowScheme(workflowScheme).setDraftWorkflowScheme(draftWorkflowScheme).build();
    }

    private Response editScheme(long id, Editor editor) {
        ApplicationUser user = this.getUser();
        ServiceOutcome workflowSchemeOutcome = this.workflowSchemeService.getWorkflowScheme(user, id);
        if (!workflowSchemeOutcome.isValid()) {
            return WorkflowSchemeRestHelper.createErrorResponse((ServiceResult)workflowSchemeOutcome);
        }
        AssignableWorkflowScheme workflowScheme = (AssignableWorkflowScheme)workflowSchemeOutcome.getReturnedValue();
        if (this.workflowSchemeService.isActive((WorkflowScheme)workflowScheme)) {
            ServiceOutcome draftWorkflowSchemeOutcome = this.workflowSchemeService.getDraftWorkflowScheme(user, workflowScheme);
            if (!draftWorkflowSchemeOutcome.isValid()) {
                return WorkflowSchemeRestHelper.createErrorResponse((ServiceResult)draftWorkflowSchemeOutcome);
            }
            DraftWorkflowScheme draftWorkflowScheme = (DraftWorkflowScheme)draftWorkflowSchemeOutcome.getReturnedValue();
            if (draftWorkflowScheme == null) {
                draftWorkflowSchemeOutcome = this.workflowSchemeService.createDraft(user, workflowScheme.getId().longValue());
                if (!draftWorkflowSchemeOutcome.isValid()) {
                    return WorkflowSchemeRestHelper.createErrorResponse((ServiceResult)draftWorkflowSchemeOutcome);
                }
                draftWorkflowScheme = (DraftWorkflowScheme)draftWorkflowSchemeOutcome.getReturnedValue();
            }
            if (!(draftWorkflowSchemeOutcome = this.workflowSchemeService.updateWorkflowScheme(user, draftWorkflowScheme = editor.edit(draftWorkflowScheme))).isValid()) {
                return WorkflowSchemeRestHelper.createErrorResponse((ServiceResult)draftWorkflowSchemeOutcome);
            }
            draftWorkflowScheme = (DraftWorkflowScheme)draftWorkflowSchemeOutcome.getReturnedValue();
            return this.helper.builder().setUser(user).setAssignableWorkflowScheme(workflowScheme).setDraftWorkflowScheme(draftWorkflowScheme).build();
        }
        workflowSchemeOutcome = this.workflowSchemeService.updateWorkflowScheme(user, workflowScheme = editor.edit(workflowScheme));
        if (!workflowSchemeOutcome.isValid()) {
            return WorkflowSchemeRestHelper.createErrorResponse((ServiceResult)workflowSchemeOutcome);
        }
        workflowScheme = (AssignableWorkflowScheme)workflowSchemeOutcome.getReturnedValue();
        return this.helper.builder().setUser(user).setAssignableWorkflowScheme(workflowScheme).build();
    }

    private ApplicationUser getUser() {
        return this.authenticationContext.getLoggedInUser();
    }

    private static void processAssignRequest(WorkflowScheme.Builder<?> builder, WorkflowSchemeRequest request) {
        if (request.issueTypes != null) {
            for (String issueType : request.issueTypes) {
                builder.setMapping(issueType, request.workflow);
            }
        }
        if (request.defaultWorkflow) {
            builder.setDefaultWorkflow(request.workflow);
        }
    }

    private static void removeIssueTypes(WorkflowScheme.Builder<?> builder, WorkflowSchemeRequest request) {
        for (String issueType : request.issueTypes) {
            if (!Objects.equal((Object)builder.getMapping(issueType), (Object)request.workflow)) continue;
            builder.removeMapping(issueType);
        }
    }

    private static void removeAndReassignDefault(WorkflowScheme.Builder<?> builder, RemoveWorkflowRequest request) {
        String defaultWorkflow = builder.getDefaultWorkflow();
        defaultWorkflow = defaultWorkflow != null ? defaultWorkflow : "jira";
        builder.removeWorkflow(request.workflow);
        if (StringUtils.isNotBlank((String)request.nextDefaultWorkflow) && Iterables.contains(builder.getMappings().values(), (Object)request.nextDefaultWorkflow)) {
            builder.setDefaultWorkflow(request.nextDefaultWorkflow);
        } else if (request.workflow.equals(defaultWorkflow) && !builder.getMappings().isEmpty()) {
            builder.setDefaultWorkflow((String)Collections.min(builder.getMappings().values(), String.CASE_INSENSITIVE_ORDER));
        }
    }

    public static class RemoveWorkflowRequest {
        @JsonProperty
        private String workflow;
        @JsonProperty
        private String nextDefaultWorkflow;
    }

    public static class WorkflowSchemeRequest {
        @JsonProperty
        private String workflow;
        @JsonProperty
        private Set<String> issueTypes;
        @JsonProperty
        private boolean defaultWorkflow;
    }

    private static interface Editor {
        public AssignableWorkflowScheme edit(AssignableWorkflowScheme var1);

        public DraftWorkflowScheme edit(DraftWorkflowScheme var1);
    }
}

