/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.rest.global;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.projectconfig.fields.IssueFields;
import com.atlassian.jira.projectconfig.rest.AdminRequired;
import com.atlassian.jira.projectconfig.rest.beans.SimpleRestProject;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.annotate.JsonProperty;

@AdminRequired
@WebSudoRequired
@Path(value="issuecustomfields")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IssueCustomFieldsResource {
    private final IssueManager issueManager;
    private final CustomFieldManager fieldManager;
    private final IssueFields fields;

    public IssueCustomFieldsResource(IssueManager issueManager, CustomFieldManager fieldManager, IssueFields fields) {
        this.issueManager = issueManager;
        this.fieldManager = fieldManager;
        this.fields = fields;
    }

    @POST
    @Path(value="{issue}")
    public Response addCustomField(@PathParam(value="issue") long issueId, String fieldId) {
        Either<Issue, Response> either = this.getIssue(issueId);
        if (either.isRight()) {
            return (Response)either.right().get();
        }
        CustomField field = this.fieldManager.getCustomFieldObject(fieldId);
        if (field == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.never()).build();
        }
        this.fields.addFieldToIssueScreens((Field)field, (Issue)either.left().get());
        return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="{issue}/affectedProjects")
    public Response getAffectedProjects(@PathParam(value="issue") long issueId) {
        Either<Issue, Response> either = this.getIssue(issueId);
        if (either.isRight()) {
            return (Response)either.right().get();
        }
        Issue issue = (Issue)either.left().get();
        Iterable affectedProjects = Iterables.filter(this.fields.getAffectedProjects(issue), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)issue.getProjectObject())));
        Iterable names = Iterables.transform((Iterable)affectedProjects, SimpleRestProject.fullBeanFunc());
        return Response.ok((Object)Lists.newArrayList((Iterable)names)).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="{issue}/fields")
    public Response getFields(@PathParam(value="issue") long issueId, @DefaultValue(value="false") @QueryParam(value="onAllScreensFlag") boolean onAllScreensFlag) {
        Either<Issue, Response> either = this.getIssue(issueId);
        if (either.isRight()) {
            return (Response)either.right().get();
        }
        Issue issue = (Issue)either.left().get();
        if (onAllScreensFlag) {
            Iterable beans = Iterables.transform(this.fields.getAllCustomFieldsWithOnAllScreensFlag(issue), FieldBeanWithVisiblityFlag.toBean());
            return Response.ok((Object)Lists.newArrayList((Iterable)beans)).cacheControl(CacheControl.never()).build();
        }
        Iterable beans = Iterables.transform(this.fields.getAllCustomFields(issue), FieldBean.toBean());
        return Response.ok((Object)Lists.newArrayList((Iterable)beans)).cacheControl(CacheControl.never()).build();
    }

    private Either<Issue, Response> getIssue(long issueId) {
        MutableIssue issueObject = this.issueManager.getIssueObject(Long.valueOf(issueId));
        if (issueObject == null) {
            return Either.right((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.never()).build());
        }
        return Either.left((Object)issueObject);
    }

    public static class FieldBeanWithVisiblityFlag
    extends AbstractFieldBean {
        private static final Function<Pair<OrderableField, Boolean>, FieldBeanWithVisiblityFlag> TO_BEAN = new Function<Pair<OrderableField, Boolean>, FieldBeanWithVisiblityFlag>(){

            public FieldBeanWithVisiblityFlag apply(Pair<OrderableField, Boolean> input) {
                return new FieldBeanWithVisiblityFlag((Field)input.first(), (Boolean)input.second());
            }
        };
        private final boolean onAllScreens;

        public static Function<Pair<OrderableField, Boolean>, FieldBeanWithVisiblityFlag> toBean() {
            return TO_BEAN;
        }

        private FieldBeanWithVisiblityFlag(Field field, boolean onAllScreens) {
            super(field);
            this.onAllScreens = onAllScreens;
        }

        @JsonProperty
        public boolean isOnAllScreens() {
            return this.onAllScreens;
        }
    }

    public static class FieldBean
    extends AbstractFieldBean {
        private static final Function<Field, FieldBean> TO_BEAN = new Function<Field, FieldBean>(){

            public FieldBean apply(Field input) {
                return new FieldBean(input);
            }
        };

        public static Function<Field, FieldBean> toBean() {
            return TO_BEAN;
        }

        private FieldBean(Field field) {
            super(field);
        }
    }

    public static abstract class AbstractFieldBean {
        private final String name;
        private final String id;

        private AbstractFieldBean(Field field) {
            this.id = field.getId();
            this.name = field.getName();
        }

        @JsonProperty
        public String getId() {
            return this.id;
        }

        @JsonProperty
        public String getName() {
            return this.name;
        }
    }
}

