/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.rest.beans;

import com.atlassian.gzipfilter.org.apache.commons.lang.builder.ToStringBuilder;
import com.atlassian.gzipfilter.org.apache.commons.lang.builder.ToStringStyle;
import com.atlassian.jira.project.Project;
import com.google.common.base.Function;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonProperty;

public class SimpleRestProject {
    private static final Function<Project, SimpleRestProject> FULL_BEAN_FUNC = new Function<Project, SimpleRestProject>(){

        public SimpleRestProject apply(Project input) {
            return SimpleRestProject.fullProject(input);
        }
    };
    private static final Function<Project, SimpleRestProject> SHORT_BEAN_FUNC = new Function<Project, SimpleRestProject>(){

        public SimpleRestProject apply(Project input) {
            return SimpleRestProject.shortProject(input);
        }
    };
    private final long id;
    private final String key;
    private final String name;
    private final String url;
    private final String description;

    public static Function<Project, SimpleRestProject> fullBeanFunc() {
        return FULL_BEAN_FUNC;
    }

    public static Function<Project, SimpleRestProject> shortBeanFunc() {
        return SHORT_BEAN_FUNC;
    }

    public static SimpleRestProject fullProject(Project project) {
        return new SimpleRestProject(project);
    }

    public static SimpleRestProject shortProject(Project project) {
        return new SimpleRestProject(project.getId(), project.getKey(), project.getName());
    }

    private SimpleRestProject(Project project) {
        this.key = StringUtils.stripToNull((String)project.getKey());
        this.id = project.getId();
        this.name = StringUtils.stripToNull((String)project.getName());
        this.url = StringUtils.stripToNull((String)project.getUrl());
        this.description = StringUtils.stripToNull((String)project.getDescription());
    }

    private SimpleRestProject(long id, String key, String name) {
        this.id = id;
        this.key = key;
        this.name = name;
        this.url = null;
        this.description = null;
    }

    @JsonProperty
    public long getId() {
        return this.id;
    }

    @JsonProperty
    public String getKey() {
        return this.key;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getUrl() {
        return this.url;
    }

    @JsonProperty
    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleRestProject that = (SimpleRestProject)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

