/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.rest;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.beans.NamedDefault;
import com.atlassian.jira.projectconfig.order.OrderFactory;
import com.atlassian.jira.projectconfig.rest.beans.SharedByData;
import com.atlassian.jira.projectconfig.rest.beans.SimpleRestProject;
import com.atlassian.jira.projectconfig.shared.SharedEntitiesHelper;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.DraftWorkflowScheme;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.migration.WorkflowSchemeMigrationTaskAccessor;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowSchemeRestHelper {
    private final PermissionManager permissionManager;
    private final WorkflowManager workflowManager;
    private final SharedEntitiesHelper helper;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final OrderFactory orderFactory;
    private final DateTimeFormatter dateTimeFormatter;
    private final AvatarService avatarService;
    private final IssueTypeManager issueTypeManager;
    private final WorkflowSchemeMigrationTaskAccessor workflowSchemeMigrationTaskAccessor;

    @Autowired
    public WorkflowSchemeRestHelper(PermissionManager permissionManager, WorkflowManager workflowManager, SharedEntitiesHelper helper, IssueTypeSchemeManager issueTypeSchemeManager, OrderFactory orderFactory, DateTimeFormatter dateTimeFormatter, AvatarService avatarService, IssueTypeManager issueTypeManager, WorkflowSchemeMigrationTaskAccessor workflowSchemeMigrationTaskAccessor) {
        this.permissionManager = permissionManager;
        this.workflowManager = workflowManager;
        this.helper = helper;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.orderFactory = orderFactory;
        this.dateTimeFormatter = dateTimeFormatter;
        this.avatarService = avatarService;
        this.issueTypeManager = issueTypeManager;
        this.workflowSchemeMigrationTaskAccessor = workflowSchemeMigrationTaskAccessor;
    }

    public static Response notFound() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.never()).build();
    }

    public static Response badRequest() {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.never()).build();
    }

    public static Response ok(Object response) {
        return Response.ok((Object)response).cacheControl(CacheControl.never()).build();
    }

    public static Response createErrorResponse(ServiceResult result) {
        Set reasons = result.getErrorCollection().getReasons();
        ErrorCollection.Reason worstReason = ErrorCollection.Reason.getWorstReason((Collection)reasons);
        if (worstReason == null) {
            worstReason = ErrorCollection.Reason.NOT_FOUND;
        }
        return Response.status((int)worstReason.getHttpStatusCode()).entity((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)result.getErrorCollection())).cacheControl(CacheControl.never()).build();
    }

    public static Response createErrorResponse(Response.Status status, String key, I18nHelper i18nHelper) {
        return Response.status((Response.Status)status).entity((Object)ErrorCollection.of((String[])new String[]{i18nHelper.getText(key)})).cacheControl(CacheControl.never()).build();
    }

    public ResponseDataBuilder builder() {
        return new ResponseDataBuilder();
    }

    public static class SimpleIssueType
    implements com.atlassian.jira.projectconfig.beans.SimpleIssueType {
        private final String iconUrl;
        private final String name;
        private final String description;
        private final String id;
        private final boolean subTask;
        private final boolean defaultIssueType;

        public SimpleIssueType(IssueType issueType) {
            this(issueType, false);
        }

        public SimpleIssueType(IssueType issueType, boolean defaultIssueType) {
            this.id = issueType.getId();
            this.name = StringUtils.stripToNull((String)issueType.getNameTranslation());
            this.description = StringUtils.stripToNull((String)issueType.getDescTranslation());
            this.iconUrl = issueType.getCompleteIconUrl();
            this.subTask = issueType.isSubTask();
            this.defaultIssueType = defaultIssueType;
        }

        @Override
        @JsonProperty
        public String getIconUrl() {
            return this.iconUrl;
        }

        @Override
        @JsonProperty
        public String getName() {
            return this.name;
        }

        @Override
        @JsonIgnore
        public boolean isDefault() {
            return this.defaultIssueType;
        }

        @Override
        @JsonProperty
        public String getDescription() {
            return this.description;
        }

        @Override
        @JsonProperty
        public String getId() {
            return this.id;
        }

        @Override
        @JsonProperty
        public boolean isSubTask() {
            return this.subTask;
        }

        @Override
        @JsonProperty
        public boolean isDefaultIssueType() {
            return this.defaultIssueType;
        }

        @Override
        public IssueType getConstant() {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleIssueType that = (SimpleIssueType)o;
            return this.id.equals(that.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }

    public static class SimpleUser {
        private final String name;
        private final String displayName;
        private final boolean active;
        private final Map<String, URI> avatarUrls;

        public SimpleUser(ApplicationUser applicationUser, URI avatarUrl) {
            this.displayName = applicationUser.getDisplayName();
            this.name = applicationUser.getUsername();
            this.active = applicationUser.isActive();
            this.avatarUrls = Collections.singletonMap("16x16", avatarUrl);
        }

        @JsonProperty
        public String getDisplayName() {
            return this.displayName;
        }

        @JsonProperty
        public String getName() {
            return this.name;
        }

        @JsonProperty
        public boolean isActive() {
            return this.active;
        }

        @JsonProperty
        public Map<String, URI> getAvatarUrls() {
            return this.avatarUrls;
        }

        public static SimpleUser asSimpleUser(ApplicationUser user, URI avatarUrl) {
            if (user == null) {
                return null;
            }
            return new SimpleUser(user, avatarUrl);
        }
    }

    public static class WorkflowSchemeResponse {
        private String name;
        private String description;
        private Long id;
        private SharedByData shared;
        private Iterable<SimpleWorkflow> mappings;
        private Iterable<SimpleWorkflow> originalMappings;
        private Iterable<SimpleIssueType> issueTypes;
        private boolean admin;
        private boolean sysAdmin;
        private String lastModifiedDate;
        private SimpleUser lastModifiedUser;
        private boolean defaultScheme;
        private int totalWorkflows;
        private boolean draftScheme;
        private String currentUser;
        private Long parentId;
        private String migrationProgressURL;

        public WorkflowSchemeResponse(WorkflowScheme scheme) {
            this.setWorkflowScheme(scheme);
        }

        public WorkflowSchemeResponse setWorkflowScheme(WorkflowScheme scheme) {
            this.setDefaultScheme(scheme.isDefault());
            this.setDescription(scheme.getDescription());
            this.setId(scheme.getId());
            this.setName(scheme.getName());
            this.setDraftScheme(scheme.isDraft());
            return this;
        }

        public WorkflowSchemeResponse setAdmin(boolean admin) {
            this.admin = admin;
            return this;
        }

        public WorkflowSchemeResponse setSysAdmin(boolean sysAdmin) {
            this.sysAdmin = sysAdmin;
            return this;
        }

        public WorkflowSchemeResponse setDefaultScheme(boolean defaultScheme) {
            this.defaultScheme = defaultScheme;
            return this;
        }

        public WorkflowSchemeResponse setDescription(String description) {
            this.description = StringUtils.stripToNull((String)description);
            return this;
        }

        public WorkflowSchemeResponse setDraftScheme(boolean draftScheme) {
            this.draftScheme = draftScheme;
            return this;
        }

        public WorkflowSchemeResponse setMigrationProgressURL(String migrationProgressURL) {
            this.migrationProgressURL = migrationProgressURL;
            return this;
        }

        public WorkflowSchemeResponse setId(Long id) {
            this.id = id;
            return this;
        }

        public WorkflowSchemeResponse setIssueTypes(Iterable<SimpleIssueType> issueTypes) {
            this.issueTypes = issueTypes;
            return this;
        }

        public WorkflowSchemeResponse setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = StringUtils.stripToNull((String)lastModifiedDate);
            return this;
        }

        public WorkflowSchemeResponse setLastModifiedUser(ApplicationUser user, URI avatarUrl) {
            this.lastModifiedUser = SimpleUser.asSimpleUser(user, avatarUrl);
            return this;
        }

        public WorkflowSchemeResponse setName(String name) {
            this.name = StringUtils.stripToNull((String)name);
            return this;
        }

        public WorkflowSchemeResponse setShared(SharedByData shared) {
            this.shared = shared;
            return this;
        }

        public WorkflowSchemeResponse setTotalWorkflows(int totalWorkflows) {
            this.totalWorkflows = totalWorkflows;
            return this;
        }

        public WorkflowSchemeResponse setMappings(Iterable<SimpleWorkflow> mappings) {
            this.mappings = mappings;
            return this;
        }

        public WorkflowSchemeResponse setOriginalMappings(Iterable<SimpleWorkflow> mappings) {
            this.originalMappings = mappings;
            return this;
        }

        @JsonProperty
        public String getDescription() {
            return this.description;
        }

        @JsonProperty
        public Long getId() {
            return this.id;
        }

        @JsonProperty
        public String getName() {
            return this.name;
        }

        @JsonProperty
        public Iterable<SimpleWorkflow> getMappings() {
            return this.mappings;
        }

        @JsonProperty
        public Iterable<SimpleIssueType> getIssueTypes() {
            return this.issueTypes;
        }

        @JsonProperty
        public SharedByData getShared() {
            return this.shared;
        }

        @JsonProperty
        public boolean isAdmin() {
            return this.admin;
        }

        @JsonProperty
        public boolean isSysAdmin() {
            return this.sysAdmin;
        }

        @JsonProperty
        public boolean isDefaultScheme() {
            return this.defaultScheme;
        }

        @JsonProperty
        public int getTotalWorkflows() {
            return this.totalWorkflows;
        }

        @JsonProperty
        public boolean isDraftScheme() {
            return this.draftScheme;
        }

        @JsonProperty
        public String getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @JsonProperty
        public SimpleUser getLastModifiedUser() {
            return this.lastModifiedUser;
        }

        @JsonProperty
        public Iterable<SimpleWorkflow> getOriginalMappings() {
            return this.originalMappings;
        }

        @JsonProperty
        public String getCurrentUser() {
            return this.currentUser;
        }

        @JsonProperty
        public String getMigrationProgressURL() {
            return this.migrationProgressURL;
        }

        public WorkflowSchemeResponse setCurrentUser(String currentUser) {
            this.currentUser = currentUser;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WorkflowSchemeResponse that = (WorkflowSchemeResponse)o;
            if (this.draftScheme != that.draftScheme) {
                return false;
            }
            return !(this.id != null ? !this.id.equals(that.id) : that.id != null);
        }

        public int hashCode() {
            int result = this.id != null ? this.id.hashCode() : 0;
            result = 31 * result + (this.draftScheme ? 1 : 0);
            return result;
        }

        @JsonProperty
        public Long getParentId() {
            return this.parentId;
        }

        public WorkflowSchemeResponse setParentId(Long parentId) {
            this.parentId = parentId;
            return this;
        }
    }

    public static class SimpleWorkflow
    implements NamedDefault {
        private final String name;
        private final String displayName;
        private final String description;
        private final boolean defaultWorkflow;
        private final boolean systemWorkflow;
        private final Iterable<String> issueTypes;
        private final boolean jiraDefault;
        private final SharedByData sharedBy;

        public SimpleWorkflow(JiraWorkflow workflow, boolean defaultWorkflow, Iterable<String> issueTypes, SharedByData sharedBy) {
            this.name = workflow.getName();
            this.displayName = workflow.getDisplayName();
            this.description = StringUtils.stripToNull((String)workflow.getDescription());
            this.defaultWorkflow = defaultWorkflow;
            this.systemWorkflow = workflow.isSystemWorkflow();
            this.jiraDefault = workflow.isDefault();
            this.issueTypes = issueTypes;
            this.sharedBy = sharedBy;
        }

        @JsonProperty
        public Iterable<String> getIssueTypes() {
            return this.issueTypes;
        }

        @Override
        @JsonProperty
        public String getName() {
            return this.name;
        }

        @Override
        @JsonProperty
        public boolean isDefault() {
            return this.defaultWorkflow;
        }

        @JsonProperty
        public String getDescription() {
            return this.description;
        }

        @JsonProperty
        public boolean isSystem() {
            return this.systemWorkflow;
        }

        @JsonProperty
        public boolean isJiraDefault() {
            return this.jiraDefault;
        }

        @JsonProperty
        public String getDisplayName() {
            return this.displayName;
        }

        @JsonProperty
        public SharedByData getSharedBy() {
            return this.sharedBy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleWorkflow that = (SimpleWorkflow)o;
            return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }
    }

    public class ResponseDataBuilder {
        private AssignableWorkflowScheme assignableWorkflowScheme;
        private DraftWorkflowScheme draftWorkflowScheme;
        private ApplicationUser user;
        private Project project;
        private Comparator<NamedDefault> namedDefaultComparator;
        private Comparator<com.atlassian.jira.projectconfig.beans.SimpleIssueType> simpleIssueTypeComparator;

        private ResponseDataBuilder() {
        }

        public ResponseDataBuilder setAssignableWorkflowScheme(AssignableWorkflowScheme assignableWorkflowScheme) {
            this.assignableWorkflowScheme = assignableWorkflowScheme;
            return this;
        }

        public ResponseDataBuilder setDraftWorkflowScheme(DraftWorkflowScheme draftWorkflowScheme) {
            this.draftWorkflowScheme = draftWorkflowScheme;
            return this;
        }

        public ResponseDataBuilder setUser(ApplicationUser user) {
            this.user = user;
            return this;
        }

        public ResponseDataBuilder setProject(Project project) {
            this.project = project;
            return this;
        }

        private WorkflowScheme getWorkflowScheme() {
            return this.draftWorkflowScheme != null ? this.draftWorkflowScheme : this.assignableWorkflowScheme;
        }

        public Response build() {
            WorkflowScheme workingScheme = this.getWorkflowScheme();
            WorkflowSchemeResponse response = new WorkflowSchemeResponse(workingScheme);
            if (this.project != null) {
                this.addWorkflowData(this.project, workingScheme, response);
            } else {
                this.addWorkflowData(workingScheme, response);
            }
            if (this.user != null) {
                response.setCurrentUser(this.user.getName());
            }
            response.setAdmin(WorkflowSchemeRestHelper.this.permissionManager.hasPermission(0, this.user));
            response.setSysAdmin(WorkflowSchemeRestHelper.this.permissionManager.hasPermission(44, this.user));
            response.setTotalWorkflows(WorkflowSchemeRestHelper.this.workflowManager.getWorkflows().size());
            response.setParentId(this.assignableWorkflowScheme.getId());
            this.addProjectInformation(response);
            this.addDraftInfo(workingScheme, response);
            TaskDescriptor taskDescriptor = this.draftWorkflowScheme != null ? WorkflowSchemeRestHelper.this.workflowSchemeMigrationTaskAccessor.getActiveByProjects(this.draftWorkflowScheme, true) : WorkflowSchemeRestHelper.this.workflowSchemeMigrationTaskAccessor.getActive((WorkflowScheme)this.assignableWorkflowScheme);
            if (taskDescriptor != null) {
                response.setMigrationProgressURL(taskDescriptor.getProgressURL());
            }
            return WorkflowSchemeRestHelper.ok(response);
        }

        private void addDraftInfo(WorkflowScheme scheme, WorkflowSchemeResponse response) {
            if (scheme instanceof DraftWorkflowScheme) {
                DraftWorkflowScheme draftScheme = (DraftWorkflowScheme)scheme;
                ApplicationUser lastModifiedUser = draftScheme.getLastModifiedUser();
                if (lastModifiedUser != null) {
                    URI avatarUrl = WorkflowSchemeRestHelper.this.avatarService.getAvatarAbsoluteURL(lastModifiedUser, lastModifiedUser, Avatar.Size.SMALL);
                    response.setLastModifiedUser(draftScheme.getLastModifiedUser(), avatarUrl);
                }
                response.setLastModifiedDate(WorkflowSchemeRestHelper.this.dateTimeFormatter.forUser(this.user).format(draftScheme.getLastModifiedDate()));
            }
        }

        private void addProjectInformation(WorkflowSchemeResponse response) {
            List<Project> projects = WorkflowSchemeRestHelper.this.helper.getProjectsForScheme(this.project, this.assignableWorkflowScheme.getId());
            SharedByData sharedByData = this.getSharedData(projects);
            response.setShared(sharedByData);
        }

        private SharedByData getWorkflowSharedByData(String workflowName) {
            List<Project> projects = WorkflowSchemeRestHelper.this.helper.getProjectsForWorkflow(this.project, workflowName);
            return this.getSharedData(projects);
        }

        private SharedByData getSharedData(List<Project> projects) {
            List<Project> allowedProjects = WorkflowSchemeRestHelper.this.helper.filterSharingProjects(projects);
            List<SimpleRestProject> restProjects = allowedProjects.stream().map(SimpleRestProject::fullProject).collect(Collectors.toList());
            return new SharedByData(restProjects, projects.size());
        }

        private Multimap<String, IssueType> getInvertedWorkflowMap(Project project, WorkflowScheme workflowScheme) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            for (IssueType type : project.getIssueTypes()) {
                builder.put((Object)workflowScheme.getActualWorkflow(type.getId()), (Object)type);
            }
            return builder.build();
        }

        private void addWorkflowData(Project project, WorkflowScheme workflowScheme, WorkflowSchemeResponse response) {
            Multimap<String, IssueType> invertedWorkflowMap = this.getInvertedWorkflowMap(project, workflowScheme);
            ArrayList mappings = Lists.newArrayList();
            ArrayList usedIssueTypes = Lists.newArrayList();
            IssueType defaultIssueType = WorkflowSchemeRestHelper.this.issueTypeSchemeManager.getDefaultIssueType(project);
            String defaultWorkflowName = workflowScheme.getActualDefaultWorkflow();
            for (Map.Entry entry : invertedWorkflowMap.asMap().entrySet()) {
                String name = (String)entry.getKey();
                JiraWorkflow workflow = WorkflowSchemeRestHelper.this.workflowManager.getWorkflow(name);
                List<SimpleIssueType> entryTypes = this.createIssueTypes((Iterable)entry.getValue(), defaultIssueType);
                usedIssueTypes.addAll(entryTypes);
                boolean isDefault = name.equals(defaultWorkflowName);
                Iterable issueTypeIds = Iterables.transform(entryTypes, SimpleIssueType::getId);
                SharedByData sharedByData = this.getWorkflowSharedByData(name);
                mappings.add(new SimpleWorkflow(workflow, isDefault, issueTypeIds, sharedByData));
            }
            response.setMappings(this.sortNamedDefault(mappings)).setIssueTypes(this.sortTypes(usedIssueTypes));
        }

        private List<SimpleIssueType> createIssueTypes(Iterable<? extends IssueType> value, IssueType defaultIssueType) {
            ArrayList issueTypes = Lists.newArrayList();
            for (IssueType issueType : value) {
                issueTypes.add(new SimpleIssueType(issueType, defaultIssueType != null && issueType.getId().equals(defaultIssueType.getId())));
            }
            return this.sortTypes(issueTypes);
        }

        private void addWorkflowData(WorkflowScheme workflowScheme, WorkflowSchemeResponse response) {
            HashMap issueTypeMap = Maps.newHashMap();
            for (IssueType issueType : WorkflowSchemeRestHelper.this.issueTypeManager.getIssueTypes()) {
                SimpleIssueType type = new SimpleIssueType(issueType);
                issueTypeMap.put(type.getId(), type);
            }
            response.setMappings(this.sortNamedDefault(this.getMappings(workflowScheme, issueTypeMap)));
            if (workflowScheme instanceof DraftWorkflowScheme) {
                List<SimpleWorkflow> originalMappings = this.getMappings((WorkflowScheme)((DraftWorkflowScheme)workflowScheme).getParentScheme(), issueTypeMap);
                response.setOriginalMappings(this.sortNamedDefault(originalMappings));
            }
            response.setIssueTypes(this.sortTypes(Lists.newArrayList(issueTypeMap.values())));
        }

        private List<SimpleWorkflow> getMappings(WorkflowScheme workflowScheme, Map<String, SimpleIssueType> issueTypeMap) {
            String workflow;
            String defaultWorkflow = null;
            HashMultimap invertedMap = HashMultimap.create();
            for (Map.Entry entry : workflowScheme.getMappings().entrySet()) {
                String string = (String)entry.getKey();
                workflow = (String)entry.getValue();
                if (string != null) {
                    SimpleIssueType type = issueTypeMap.get(string);
                    if (type == null) continue;
                    invertedMap.put((Object)workflow, (Object)type);
                    continue;
                }
                defaultWorkflow = workflow;
            }
            if (defaultWorkflow == null) {
                defaultWorkflow = "jira";
            }
            ArrayList mappings = Lists.newArrayList();
            for (Map.Entry entry : invertedMap.asMap().entrySet()) {
                workflow = WorkflowSchemeRestHelper.this.workflowManager.getWorkflow((String)entry.getKey());
                String workflowName = workflow.getName();
                boolean isDefault = defaultWorkflow.equals(workflowName);
                List<SimpleIssueType> types = this.sortTypes(Lists.newArrayList((Iterable)((Iterable)entry.getValue())));
                Iterable issueTypeIds = Iterables.transform(types, SimpleIssueType::getId);
                SharedByData sharedByData = this.getWorkflowSharedByData(workflowName);
                mappings.add(new SimpleWorkflow((JiraWorkflow)workflow, isDefault, issueTypeIds, sharedByData));
            }
            if (!invertedMap.containsKey((Object)defaultWorkflow)) {
                JiraWorkflow jiraWorkflow = WorkflowSchemeRestHelper.this.workflowManager.getWorkflow(defaultWorkflow);
                SharedByData sharedByData = this.getWorkflowSharedByData(defaultWorkflow);
                mappings.add(new SimpleWorkflow(jiraWorkflow, true, Collections.emptyList(), sharedByData));
            }
            return mappings;
        }

        public <T extends NamedDefault> List<T> sortNamedDefault(List<T> list) {
            Collections.sort(list, this.getNamedDefaultComparator());
            return list;
        }

        public List<SimpleIssueType> sortTypes(List<SimpleIssueType> list) {
            Collections.sort(list, this.getIssueTypeCompatator());
            return list;
        }

        private Comparator<NamedDefault> getNamedDefaultComparator() {
            if (this.namedDefaultComparator == null) {
                this.namedDefaultComparator = WorkflowSchemeRestHelper.this.orderFactory.createNamedDefaultComparator();
            }
            return this.namedDefaultComparator;
        }

        private Comparator<? super SimpleIssueType> getIssueTypeCompatator() {
            if (this.simpleIssueTypeComparator == null) {
                this.simpleIssueTypeComparator = WorkflowSchemeRestHelper.this.orderFactory.createIssueTypeComparator();
            }
            return this.simpleIssueTypeComparator;
        }
    }
}

