/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.issuetypes.workflow;

import com.atlassian.jira.projectconfig.beans.ProjectContext;
import com.atlassian.jira.projectconfig.shared.SharedIssueTypeWorkflowData;
import com.atlassian.jira.workflow.JiraWorkflow;
import java.util.Locale;
import javax.annotation.Nonnull;

public interface IssueTypeConfigWorkflowHelper {
    @Nonnull
    public WorkflowResult getWorkflowData(@Nonnull ProjectContext var1);

    public static enum WorkflowState {
        NO_PERMISSION,
        READ_ONLY,
        READ_ONLY_DELEGATED_SHARED,
        READ_ONLY_DELEGATED_SYSTEM,
        EDITABLE,
        EDITABLE_DELEGATED,
        MIGRATE;


        public String simpleName() {
            return this.name().toLowerCase(Locale.ENGLISH).replace("_", "");
        }
    }

    public static class WorkflowResult {
        private final JiraWorkflow workflow;
        private final WorkflowState workflowState;
        private final SharedIssueTypeWorkflowData sharedBy;

        public WorkflowResult(JiraWorkflow workflow, WorkflowState workflowState, SharedIssueTypeWorkflowData sharedBy) {
            this.workflow = workflow;
            this.workflowState = workflowState;
            this.sharedBy = sharedBy;
        }

        public JiraWorkflow getWorkflow() {
            return this.workflow;
        }

        public WorkflowState getWorkflowState() {
            return this.workflowState;
        }

        public SharedIssueTypeWorkflowData getSharedBy() {
            return this.sharedBy;
        }
    }
}

