/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.issuetypes.workflow;

import com.atlassian.jira.bc.workflow.DefaultWorkflowService;
import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.beans.ProjectContext;
import com.atlassian.jira.projectconfig.issuetypes.workflow.IssueTypeConfigWorkflowHelper;
import com.atlassian.jira.projectconfig.shared.SharedEntitiesHelper;
import com.atlassian.jira.projectconfig.shared.SharedIssueTypeWorkflowData;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultIssueTypeConfigWorkflowHelper
implements IssueTypeConfigWorkflowHelper {
    private final JiraAuthenticationContext context;
    private final PermissionManager permissionManager;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final WorkflowManager workflowManager;
    private final WorkflowService workflowService;
    private final SharedEntitiesHelper sharedHelper;
    private final FeatureManager featureManager;

    @Autowired
    public DefaultIssueTypeConfigWorkflowHelper(JiraAuthenticationContext context, PermissionManager permissionManager, WorkflowSchemeManager workflowSchemeManager, WorkflowManager workflowManager, WorkflowService workflowService, SharedEntitiesHelper sharedHelper, FeatureManager featureManager) {
        this.context = context;
        this.permissionManager = permissionManager;
        this.workflowSchemeManager = workflowSchemeManager;
        this.workflowManager = workflowManager;
        this.workflowService = workflowService;
        this.sharedHelper = sharedHelper;
        this.featureManager = featureManager;
    }

    @Override
    @Nonnull
    public IssueTypeConfigWorkflowHelper.WorkflowResult getWorkflowData(@Nonnull ProjectContext issueContext) {
        return this.getWorkflowData(issueContext.getProject(), issueContext.getType());
    }

    private IssueTypeConfigWorkflowHelper.WorkflowResult getWorkflowData(@Nonnull Project project, @Nonnull IssueType type) {
        JiraWorkflow jiraWorkflow = this.workflowManager.getWorkflow(project.getId(), type.getId());
        IssueTypeConfigWorkflowHelper.WorkflowState workflowState = this.getWorkflowState(project, jiraWorkflow);
        SharedIssueTypeWorkflowData sharedBy = this.sharedHelper.getSharedData(project, type, jiraWorkflow.getName());
        return new IssueTypeConfigWorkflowHelper.WorkflowResult(jiraWorkflow, workflowState, sharedBy);
    }

    private IssueTypeConfigWorkflowHelper.WorkflowState getWorkflowState(Project project, JiraWorkflow workflow) {
        boolean notGlobalAdmin;
        boolean editWorkflowPermissionInProject = this.hasEditWorkflowPermissionInProjects(project);
        boolean bl = notGlobalAdmin = !this.permissionManager.hasPermission(0, this.context.getUser());
        if (notGlobalAdmin) {
            if (!editWorkflowPermissionInProject) {
                return IssueTypeConfigWorkflowHelper.WorkflowState.NO_PERMISSION;
            }
            if (workflow.isSystemWorkflow()) {
                return IssueTypeConfigWorkflowHelper.WorkflowState.READ_ONLY_DELEGATED_SYSTEM;
            }
            boolean canEditWorkflowPermission = this.workflowService.hasEditWorkflowPermission(this.context.getLoggedInUser(), workflow);
            if (canEditWorkflowPermission) {
                return IssueTypeConfigWorkflowHelper.WorkflowState.EDITABLE_DELEGATED;
            }
            return IssueTypeConfigWorkflowHelper.WorkflowState.READ_ONLY_DELEGATED_SHARED;
        }
        if (this.workflowSchemeManager.isUsingDefaultScheme(project)) {
            return IssueTypeConfigWorkflowHelper.WorkflowState.MIGRATE;
        }
        if (workflow.isSystemWorkflow()) {
            return IssueTypeConfigWorkflowHelper.WorkflowState.READ_ONLY;
        }
        return IssueTypeConfigWorkflowHelper.WorkflowState.EDITABLE;
    }

    private boolean hasEditWorkflowPermissionInProjects(Project project) {
        return this.featureManager.isEnabled(DefaultWorkflowService.PROJECT_LEVEL_ADMIN_EDIT_WORKFLOW_FEATURE) && this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, this.context.getLoggedInUser());
    }
}

