/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.issuetypes.fields;

import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.ProjectFieldScreenHelper;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.beans.ProjectContext;
import com.atlassian.jira.projectconfig.issuetypes.fields.IssueTypeConfigFieldsHelper;
import com.atlassian.jira.projectconfig.order.OrderFactory;
import com.atlassian.jira.projectconfig.shared.SharedEntitiesUtils;
import com.atlassian.jira.projectconfig.shared.SharedIssueTypeWorkflowData;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultIssueTypeConfigFieldsHelper
implements IssueTypeConfigFieldsHelper {
    private final IssueTypeScreenSchemeManager issueTypeScreenManager;
    private final ProjectFieldScreenHelper projectFieldScreenHelper;
    private final OrderFactory orderFactory;

    @Autowired
    public DefaultIssueTypeConfigFieldsHelper(@ComponentImport IssueTypeScreenSchemeManager issueTypeScreenManager, @ComponentImport ProjectFieldScreenHelper projectFieldScreenHelper, OrderFactory orderFactory) {
        this.issueTypeScreenManager = issueTypeScreenManager;
        this.projectFieldScreenHelper = projectFieldScreenHelper;
        this.orderFactory = orderFactory;
    }

    @Override
    @Nonnull
    public IssueTypeConfigFieldsHelper.FieldsResult getFieldsData(@Nonnull ProjectContext context) {
        FieldScreen fieldScreen = this.getFieldScreen(context.getProject(), context.getType());
        List<Project> otherProject = this.getOtherProjectsSharingScreen(fieldScreen, context.getProject());
        List<IssueType> otherIssueTypes = this.getOtherIssueTypesSharingScreen(fieldScreen, context);
        SharedIssueTypeWorkflowData sharedBy = new SharedIssueTypeWorkflowData(otherProject, otherIssueTypes);
        return new IssueTypeConfigFieldsHelper.FieldsResult(fieldScreen, sharedBy);
    }

    private FieldScreen getFieldScreen(Project project, IssueType type) {
        return this.issueTypeScreenManager.getIssueTypeScreenScheme(project).getEffectiveFieldScreenScheme(type).getFieldScreen((IssueOperation)IssueOperations.VIEW_ISSUE_OPERATION);
    }

    private List<Project> getOtherProjectsSharingScreen(FieldScreen fieldScreen, Project project) {
        return SharedEntitiesUtils.filterNotEqualProject(project, this.projectFieldScreenHelper.getProjectsForFieldScreen(fieldScreen));
    }

    private List<IssueType> getOtherIssueTypesSharingScreen(FieldScreen fieldScreen, ProjectContext context) {
        Project project = context.getProject();
        String currentIssueTypeId = context.getType().getId();
        Long currentViewId = fieldScreen.getId();
        List result = project.getIssueTypes().stream().filter(otherIssueType -> !Objects.equals(currentIssueTypeId, otherIssueType.getId())).filter(otherIssueType -> {
            FieldScreen otherFieldScreen = this.getFieldScreen(project, (IssueType)otherIssueType);
            return currentViewId.equals(otherFieldScreen.getId());
        }).collect(Collectors.toList());
        return this.orderFactory.createTranslatedNameOrder().immutableSortedCopy(result);
    }
}

