/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.dataproviders;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class EmailVisibilityProvider
implements WebResourceDataProvider {
    private final JiraAuthenticationContext authenticationContext;
    private final EmailFormatter emailFormatter;

    public EmailVisibilityProvider(JiraAuthenticationContext authenticationContext, EmailFormatter emailFormatter) {
        this.authenticationContext = authenticationContext;
        this.emailFormatter = emailFormatter;
    }

    public Jsonable get() {
        return writer -> {
            try {
                this.getJsonData().write(writer);
            }
            catch (JSONException e) {
                throw new Jsonable.JsonMappingException((Throwable)e);
            }
        };
    }

    private JSONObject getJsonData() {
        ApplicationUser loggedInUser = this.authenticationContext.getLoggedInUser();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"isEmailVisible", (Object)this.emailFormatter.emailVisible(loggedInUser));
        return new JSONObject((Map)builder.build());
    }
}

