/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.contextproviders;

import com.atlassian.gzipfilter.org.apache.commons.lang.builder.ToStringBuilder;
import com.atlassian.gzipfilter.org.apache.commons.lang.builder.ToStringStyle;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.beans.NamedDefault;
import com.atlassian.jira.projectconfig.contextproviders.ContextProviderUtils;
import com.atlassian.jira.projectconfig.order.OrderFactory;
import com.atlassian.jira.projectconfig.shared.SharedEntitiesHelper;
import com.atlassian.jira.projectconfig.shared.SharedEntitiesUtils;
import com.atlassian.jira.projectconfig.shared.SharedIssueTypeWorkflowData;
import com.atlassian.jira.projectconfig.util.TabUrlFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.plugin.PluginParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class WorkflowSummaryPanelContextProvider
implements CacheableContextProvider {
    private final ContextProviderUtils utils;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final JiraAuthenticationContext authenticationContext;
    private final TabUrlFactory factory;
    private final OrderFactory orderFactory;
    private final WorkflowManager workflowManager;
    private final SharedEntitiesHelper sharedHelper;

    public WorkflowSummaryPanelContextProvider(ContextProviderUtils utils, WorkflowSchemeManager workflowSchemeManager, JiraAuthenticationContext authenticationContext, TabUrlFactory factory, OrderFactory orderFactory, WorkflowManager workflowManager, SharedEntitiesHelper sharedHelper) {
        this.utils = utils;
        this.workflowSchemeManager = workflowSchemeManager;
        this.authenticationContext = authenticationContext;
        this.factory = factory;
        this.orderFactory = orderFactory;
        this.workflowManager = workflowManager;
        this.sharedHelper = sharedHelper;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        Project project = this.utils.getProject();
        MapBuilder builder = MapBuilder.newBuilder(context);
        builder.add((Object)"project", (Object)project.getId());
        this.addWorkflows((MapBuilder<String, Object>)builder, project);
        this.addSchemeData((MapBuilder<String, Object>)builder, project);
        return builder.toMap();
    }

    private MapBuilder<String, Object> addWorkflows(MapBuilder<String, Object> builder, Project project) {
        Map issueTypeToWorkflowMap = this.workflowSchemeManager.getWorkflowMap(project);
        String defaultWorkflow = SharedEntitiesUtils.getOrDefaultWorkflowName(issueTypeToWorkflowMap, null, "jira");
        HashSet<String> addedWorkflows = new HashSet<String>();
        ArrayList<SimpleWorkflow> ordered = new ArrayList<SimpleWorkflow>();
        for (IssueType issueType : project.getIssueTypes()) {
            String workflowName = SharedEntitiesUtils.getOrDefaultWorkflowName(issueTypeToWorkflowMap, issueType.getId(), defaultWorkflow);
            if (!addedWorkflows.add(workflowName)) continue;
            SharedIssueTypeWorkflowData sharedBy = this.sharedHelper.getSharedData(project, issueType, workflowName);
            JiraWorkflow jiraWorkflow = this.workflowManager.getWorkflow(workflowName);
            String workflowUrl = this.getWorkflowUrl(workflowName);
            boolean isDefaultWorkflow = defaultWorkflow.equals(workflowName);
            ordered.add(new SimpleWorkflow(jiraWorkflow, workflowUrl, isDefaultWorkflow, sharedBy));
        }
        Collections.sort(ordered, this.orderFactory.createNamedDefaultComparator());
        return builder.add((Object)"workflows", ordered);
    }

    private MapBuilder<String, Object> addSchemeData(MapBuilder<String, Object> builder, Project project) {
        try {
            GenericValue workflowScheme = this.workflowSchemeManager.getWorkflowScheme(project.getGenericValue());
            if (workflowScheme != null) {
                builder.add((Object)"schemeName", (Object)workflowScheme.getString("name"));
                builder.add((Object)"schemeDescription", (Object)workflowScheme.getString("description"));
            } else {
                builder.add((Object)"schemeName", (Object)this.authenticationContext.getI18nHelper().getText("admin.schemes.workflows.default"));
            }
            builder.add((Object)"schemeLink", (Object)this.factory.forWorkflows());
            builder.add((Object)"schemeDefault", (Object)this.workflowSchemeManager.isUsingDefaultScheme(project));
        }
        catch (GenericEntityException e) {
            builder.add((Object)"error", (Object)true);
        }
        return builder;
    }

    String getWorkflowUrl(String workflowName) {
        return this.createUrlBuilder("/secure/admin/workflows/ViewWorkflowSteps.jspa?workflowMode=live").addParameter("workflowName", workflowName).asUrlString();
    }

    private UrlBuilder createUrlBuilder(String operation) {
        return this.utils.createUrlBuilder(operation);
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        return this.getClass().getName();
    }

    public static class SimpleWorkflow
    implements NamedDefault {
        private final String name;
        private final String urlName;
        private final String description;
        private final boolean isDefault;
        private final boolean isSystem;
        private final boolean isJiraDefault;
        private final String displayName;
        private final SharedIssueTypeWorkflowData sharedBy;

        SimpleWorkflow(String name, String urlName, String description, boolean isDefault, boolean system, boolean isJiraDefault, String displayName, SharedIssueTypeWorkflowData sharedBy) {
            this.description = description;
            this.name = name;
            this.urlName = urlName;
            this.isDefault = isDefault;
            this.isSystem = system;
            this.isJiraDefault = isJiraDefault;
            this.displayName = displayName;
            this.sharedBy = sharedBy;
        }

        SimpleWorkflow(JiraWorkflow workflow, String urlName, boolean isDefault, SharedIssueTypeWorkflowData sharedBy) {
            this.name = workflow.getName();
            this.urlName = urlName;
            this.description = workflow.getDescription();
            this.isDefault = isDefault;
            this.isSystem = workflow.isSystemWorkflow();
            this.isJiraDefault = workflow.isDefault();
            this.displayName = workflow.getDisplayName();
            this.sharedBy = sharedBy;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.urlName;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean isDefault() {
            return this.isDefault;
        }

        public boolean isSystem() {
            return this.isSystem;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public SharedIssueTypeWorkflowData getSharedBy() {
            return this.sharedBy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleWorkflow that = (SimpleWorkflow)o;
            if (this.isDefault != that.isDefault) {
                return false;
            }
            if (this.isJiraDefault != that.isJiraDefault) {
                return false;
            }
            if (this.isSystem != that.isSystem) {
                return false;
            }
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
                return false;
            }
            if (this.displayName != null ? !this.displayName.equals(that.displayName) : that.displayName != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            if (this.urlName != null ? !this.urlName.equals(that.urlName) : that.urlName != null) {
                return false;
            }
            return !(this.sharedBy != null ? !this.sharedBy.equals(that.sharedBy) : that.sharedBy != null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.urlName != null ? this.urlName.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.isDefault ? 1 : 0);
            result = 31 * result + (this.isSystem ? 1 : 0);
            result = 31 * result + (this.isJiraDefault ? 1 : 0);
            result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
            result = 31 * result + (this.sharedBy != null ? this.sharedBy.hashCode() : 0);
            return result;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

