/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.contextproviders;

import com.atlassian.jira.bc.project.version.VersionService;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.projectconfig.contextproviders.ContextProviderUtils;
import com.atlassian.jira.projectconfig.util.TabUrlFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.DateFieldFormat;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.PluginParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class VersionsSummaryPanelContextProvider
implements CacheableContextProvider {
    private static final int MAX_VERSIONS_DISPLAYED = 5;
    private final ContextProviderUtils providerUtils;
    private final VersionService service;
    private final JiraAuthenticationContext authContext;
    private final TabUrlFactory tabUrlFactory;
    private final DateFieldFormat dateFormat;

    public VersionsSummaryPanelContextProvider(ContextProviderUtils utils, VersionService service, JiraAuthenticationContext authContext, TabUrlFactory tabUrlFactory, DateFieldFormat dateFormat) {
        this.providerUtils = utils;
        this.service = service;
        this.authContext = authContext;
        this.tabUrlFactory = tabUrlFactory;
        this.dateFormat = dateFormat;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        Project project = this.providerUtils.getProject();
        VersionService.VersionsResult result = this.service.getVersionsByProject(this.authContext.getLoggedInUser(), project);
        ArrayList versions = result.getVersions() == null ? Collections.emptyList() : new ArrayList(result.getVersions());
        ArrayList<SimpleVersion> simpleVersions = new ArrayList<SimpleVersion>(5);
        Collections.reverse(versions);
        int count = 0;
        for (Version version : versions) {
            if (version.isArchived()) continue;
            if (count < 5) {
                String releaseDate = version.getReleaseDate() == null ? null : this.dateFormat.format(version.getReleaseDate());
                simpleVersions.add(new SimpleVersion(version.getName(), version.isReleased(), version.isArchived(), this.service.isOverdue(version), releaseDate));
            }
            ++count;
        }
        MapBuilder newContext = MapBuilder.newBuilder(context).add((Object)"versions", simpleVersions).add((Object)"errors", this.providerUtils.flattenErrors(result.getErrorCollection())).add((Object)"totalSize", (Object)count).add((Object)"actualSize", (Object)simpleVersions.size()).add((Object)"manageVersionLink", (Object)this.tabUrlFactory.forVersions());
        return newContext.toMap();
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        return this.getClass().getName();
    }

    public static class SimpleVersion {
        private final String name;
        private final String releaseDate;
        private final boolean released;
        private final boolean archived;
        private final boolean overdue;

        SimpleVersion(String name, boolean released, boolean archived, boolean overdue, String releaseDate) {
            this.name = name;
            this.released = released;
            this.archived = archived;
            this.overdue = overdue;
            this.releaseDate = releaseDate;
        }

        public String getName() {
            return this.name;
        }

        public boolean isReleased() {
            return this.released;
        }

        public boolean isArchived() {
            return this.archived;
        }

        public boolean isOverdue() {
            return this.overdue;
        }

        public String getReleaseDate() {
            return this.releaseDate;
        }

        public boolean isHasReleaseDate() {
            return this.releaseDate != null;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleVersion that = (SimpleVersion)o;
            if (this.archived != that.archived) {
                return false;
            }
            if (this.overdue != that.overdue) {
                return false;
            }
            if (this.released != that.released) {
                return false;
            }
            if (!this.name.equals(that.name)) {
                return false;
            }
            return !(this.releaseDate != null ? !this.releaseDate.equals(that.releaseDate) : that.releaseDate != null);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.releaseDate != null ? this.releaseDate.hashCode() : 0);
            result = 31 * result + (this.released ? 1 : 0);
            result = 31 * result + (this.archived ? 1 : 0);
            result = 31 * result + (this.overdue ? 1 : 0);
            return result;
        }
    }
}

