/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.contextproviders;

import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.renderer.ProjectDescriptionRenderer;
import com.atlassian.jira.projectconfig.beans.SimplePanel;
import com.atlassian.jira.projectconfig.beans.SimpleProject;
import com.atlassian.jira.projectconfig.contextproviders.ContextProviderUtils;
import com.atlassian.jira.projectconfig.discover.EditWorkflowDiscoverHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.web.component.ModuleWebComponent;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.model.WebLabel;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;

public class SummaryContextProvider
implements CacheableContextProvider {
    static final String SUMMARY_LEFT_PANELS_LOCATION = "webpanels.admin.summary.left-panels";
    static final String SUMMARY_RIGHT_PANELS_LOCATION = "webpanels.admin.summary.right-panels";
    static final String CONTEXT_PANEL_KEY = "panelKey";
    static final String CONTEXT_LEFT_COLUMN_KEY = "leftColumn";
    static final String CONTEXT_RIGHT_COLUMN_KEY = "rightColumn";
    static final String CONTEXT_SIMPLE_PROJECT_KEY = "simpleProject";
    static final String CONTEXT_PROJECT_DESCRIPTION_RENDERER_KEY = "projectDescriptionRenderer";
    static final String CONTEXT_SHOW_EDIT_WORKFLOW_DISCOVER_KEY = "showEditWorkflowDiscover";
    static final String CONTEXT_LEARN_MORE_URL = "learnMoreUrl";
    private final WebInterfaceManager webInterfaceManager;
    private final ContextProviderUtils contextProviderUtils;
    private final ModuleWebComponent moduleWebComponent;
    private final JiraAuthenticationContext authenticationContext;
    private final ProjectDescriptionRenderer projectDescriptionRenderer;
    private final EditWorkflowDiscoverHelper editWorkflowDiscoverHelper;
    private static final Logger log = Logger.getLogger(SummaryContextProvider.class);

    public SummaryContextProvider(WebInterfaceManager webInterfaceManager, ContextProviderUtils contextProviderUtils, ModuleWebComponent moduleWebComponent, JiraAuthenticationContext authenticationContext, ProjectDescriptionRenderer projectDescriptionRenderer, EditWorkflowDiscoverHelper editWorkflowDiscoverHelper) {
        this.webInterfaceManager = webInterfaceManager;
        this.contextProviderUtils = contextProviderUtils;
        this.moduleWebComponent = moduleWebComponent;
        this.authenticationContext = authenticationContext;
        this.projectDescriptionRenderer = projectDescriptionRenderer;
        this.editWorkflowDiscoverHelper = editWorkflowDiscoverHelper;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> appProvidedContext) {
        Map<String, Object> defaultContext = this.contextProviderUtils.getDefaultContext();
        Project project = (Project)defaultContext.get("project");
        Map defaultPanelContext = MapBuilder.newBuilder().addAll(appProvidedContext).addAll(defaultContext).toMap();
        List<SimplePanel> leftSummaryPanels = this.getPanels(SUMMARY_LEFT_PANELS_LOCATION, defaultPanelContext, project);
        List<SimplePanel> rightSummaryPanels = this.getPanels(SUMMARY_RIGHT_PANELS_LOCATION, defaultPanelContext, project);
        SimpleProject wrappedProject = new SimpleProject(project);
        boolean shouldShowEditWorkflowDiscover = this.editWorkflowDiscoverHelper.shouldShowEditWorkflowDiscover(this.authenticationContext.getLoggedInUser());
        String learnMoreUrl = this.editWorkflowDiscoverHelper.getLearnMoreUrl(project);
        return MapBuilder.newBuilder().addAll(defaultPanelContext).add((Object)CONTEXT_LEFT_COLUMN_KEY, leftSummaryPanels).add((Object)CONTEXT_RIGHT_COLUMN_KEY, rightSummaryPanels).add((Object)CONTEXT_SIMPLE_PROJECT_KEY, (Object)wrappedProject).add((Object)CONTEXT_PROJECT_DESCRIPTION_RENDERER_KEY, (Object)this.projectDescriptionRenderer).add((Object)CONTEXT_SHOW_EDIT_WORKFLOW_DISCOVER_KEY, (Object)shouldShowEditWorkflowDiscover).add((Object)CONTEXT_LEARN_MORE_URL, (Object)learnMoreUrl).toMap();
    }

    private List<SimplePanel> getPanels(String location, final Map<String, Object> defaultPanelContext, final Project project) {
        Map params = MapBuilder.build((Object)"project", (Object)project);
        List summaryPanels = this.webInterfaceManager.getDisplayableWebPanelDescriptors(location, params);
        ArrayList panels = Lists.newArrayListWithExpectedSize((int)summaryPanels.size());
        for (final WebPanelModuleDescriptor desc : summaryPanels) {
            CollectionUtils.addIgnoreNull((Collection)panels, (Object)SafePluginPointAccess.call((Callable)new Callable<SimplePanel>(){

                @Override
                public SimplePanel call() throws Exception {
                    return SummaryContextProvider.this.getPanelFromDescriptor(desc, defaultPanelContext, project);
                }
            }).getOrNull());
        }
        return panels;
    }

    private SimplePanel getPanelFromDescriptor(WebPanelModuleDescriptor desc, Map<String, Object> defaultPanelContext, Project project) {
        WebLabel webLabel = desc.getWebLabel();
        HttpServletRequest req = ExecutingHttpRequest.get();
        String name = webLabel != null ? webLabel.getDisplayableLabel(req, defaultPanelContext) : desc.getCompleteKey();
        String panelDescriptorKey = desc.getKey();
        Map panelContext = MapBuilder.newBuilder(defaultPanelContext).add((Object)CONTEXT_PANEL_KEY, (Object)panelDescriptorKey).add((Object)"helper", (Object)new JiraHelper(req, project)).add((Object)"prefix", (Object)"project-config-webpanel-").add((Object)"containerClass", (Object)"project-config-webpanel").add((Object)"isNotCollapsible", (Object)true).add((Object)"headingLevel", (Object)2).toMap();
        String content = this.moduleWebComponent.renderModule(this.authenticationContext.getLoggedInUser(), req, desc, panelContext);
        return new SimplePanel(name, panelDescriptorKey, content);
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        return this.getClass().getName();
    }
}

