/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.contextproviders;

import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.application.jira.JiraProjectEntityType;
import com.atlassian.applinks.host.spi.EntityReference;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.jira.bc.project.projectoperation.ProjectOperationManager;
import com.atlassian.jira.plugin.projectoperation.PluggableProjectOperation;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.contextproviders.ContextProviderUtils;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.PluginParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SettingsSummaryPanelContextProvider
implements CacheableContextProvider {
    private static final Logger log = Logger.getLogger(SettingsSummaryPanelContextProvider.class);
    private static final String CONTEXT_PLUGIN_HTML = "pluginsHtml";
    private static final String CONTEXT_ERROR = "error";
    private final ProjectOperationManager projectOperationManager;
    private final ContextProviderUtils utils;
    private final JiraAuthenticationContext context;
    private final ApplicationLinkService applicationLinkService;
    private final InternalHostApplication hostApplication;

    public SettingsSummaryPanelContextProvider(ProjectOperationManager projectOperationManager, ContextProviderUtils utils, JiraAuthenticationContext context, ApplicationLinkService applicationLinkService, InternalHostApplication hostApplication) {
        this.projectOperationManager = projectOperationManager;
        this.utils = utils;
        this.context = context;
        this.applicationLinkService = applicationLinkService;
        this.hostApplication = hostApplication;
    }

    public void init(Map<String, String> configParams) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> passedContext) {
        Project project = this.utils.getProject();
        List projectOperations = this.projectOperationManager.getVisibleProjectOperations(project, this.context.getLoggedInUser());
        MapBuilder contextBuilder = MapBuilder.newBuilder(passedContext);
        ArrayList<String> render = new ArrayList<String>(projectOperations.size());
        for (PluggableProjectOperation projectOperation : projectOperations) {
            render.add(projectOperation.getHtml(project, this.context.getLoggedInUser()));
        }
        contextBuilder.add((Object)CONTEXT_PLUGIN_HTML, render);
        contextBuilder.add((Object)"showAppLinks", (Object)this.showAppLinks(project));
        return contextBuilder.toMap();
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        return this.getClass().getName();
    }

    private boolean showAppLinks(Project project) {
        if (this.applicationLinkService.getApplicationLinks().iterator().hasNext()) {
            EntityReference entityReference = this.hostApplication.toEntityReference(project.getKey(), JiraProjectEntityType.class);
            return this.hostApplication.canManageEntityLinksFor(entityReference);
        }
        return false;
    }
}

