/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.contextproviders;

import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeEntity;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.beans.NamedDefault;
import com.atlassian.jira.projectconfig.contextproviders.ContextProviderUtils;
import com.atlassian.jira.projectconfig.order.OrderFactory;
import com.atlassian.jira.projectconfig.util.TabUrlFactory;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.PluginParseException;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ScreensSummaryPanelContextProvider
implements CacheableContextProvider {
    static final String CONTEXT_ISSUE_TYPE_SCREEN_SCHEME_KEY = "issueTypeScreenScheme";
    static final String CONTEXT_SCREEN_SCHEMES_KEY = "screenSchemes";
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private final ContextProviderUtils contextProviderUtils;
    private final TabUrlFactory tabUrlFactory;
    private final OrderFactory orderFactory;

    public ScreensSummaryPanelContextProvider(IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, ContextProviderUtils contextProviderUtils, TabUrlFactory tabUrlFactory, OrderFactory orderFactory) {
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
        this.contextProviderUtils = contextProviderUtils;
        this.tabUrlFactory = tabUrlFactory;
        this.orderFactory = orderFactory;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        Project project = (Project)context.get("project");
        IssueTypeScreenScheme issueTypeScreenScheme = this.issueTypeScreenSchemeManager.getIssueTypeScreenScheme(project.getGenericValue());
        SimpleIssueTypeScreenScheme simpleIssueTypeScreenScheme = new SimpleIssueTypeScreenScheme(issueTypeScreenScheme, this.getChangeSchemeUrl(project.getId()), this.getEditSchemeUrl());
        Set<SimpleScreenScheme> screenSchemes = this.getScreenSchemes(project, issueTypeScreenScheme);
        return MapBuilder.newBuilder().addAll(context).add((Object)CONTEXT_ISSUE_TYPE_SCREEN_SCHEME_KEY, (Object)simpleIssueTypeScreenScheme).add((Object)CONTEXT_SCREEN_SCHEMES_KEY, (Object)Lists.newArrayList(screenSchemes.iterator())).toMap();
    }

    private Set<SimpleScreenScheme> getScreenSchemes(Project project, IssueTypeScreenScheme issueTypeScreenScheme) {
        TreeSet operationScreens = Sets.newTreeSet(this.orderFactory.createNamedDefaultComparator());
        FieldScreenScheme defaultFieldScreenScheme = issueTypeScreenScheme.getEntity(null).getFieldScreenScheme();
        for (IssueType issueTypes : project.getIssueTypes()) {
            IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity = issueTypeScreenScheme.getEntity(issueTypes.getId());
            if (issueTypeScreenSchemeEntity == null || issueTypeScreenSchemeEntity.getFieldScreenScheme().getId().equals(defaultFieldScreenScheme.getId())) {
                operationScreens.add(new SimpleScreenScheme(defaultFieldScreenScheme, this.getScreenSchemeUrl(defaultFieldScreenScheme.getId()), true));
                continue;
            }
            FieldScreenScheme fieldScreenScheme = issueTypeScreenSchemeEntity.getFieldScreenScheme();
            operationScreens.add(new SimpleScreenScheme(fieldScreenScheme, this.getScreenSchemeUrl(fieldScreenScheme.getId()), false));
        }
        return operationScreens;
    }

    String getChangeSchemeUrl(Long id) {
        return this.createUrlBuilder("/secure/admin/SelectIssueTypeScreenScheme!default.jspa").addParameter("projectId", (Object)id).asUrlString();
    }

    String getEditSchemeUrl() {
        return this.tabUrlFactory.forScreens();
    }

    String getScreenSchemeUrl(Long id) {
        return this.createUrlBuilder("/secure/admin/ConfigureFieldScreenScheme.jspa").addParameter("id", (Object)id).asUrlString();
    }

    private UrlBuilder createUrlBuilder(String operation) {
        return this.contextProviderUtils.createUrlBuilder(operation);
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        return this.getClass().getName();
    }

    public static class SimpleIssueTypeScreenScheme {
        private final String name;
        private final String changeUrl;
        private final String editUrl;
        private final String description;

        public SimpleIssueTypeScreenScheme(IssueTypeScreenScheme issueTypeScreenScheme, String changeUrl, String editUrl) {
            this.name = issueTypeScreenScheme.getName();
            this.description = issueTypeScreenScheme.getDescription();
            this.changeUrl = changeUrl;
            this.editUrl = editUrl;
        }

        SimpleIssueTypeScreenScheme(String name, String description, String changeUrl, String editUrl) {
            this.name = name;
            this.changeUrl = changeUrl;
            this.editUrl = editUrl;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getChangeUrl() {
            return this.changeUrl;
        }

        public String getEditUrl() {
            return this.editUrl;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleIssueTypeScreenScheme that = (SimpleIssueTypeScreenScheme)o;
            if (this.changeUrl != null ? !this.changeUrl.equals(that.changeUrl) : that.changeUrl != null) {
                return false;
            }
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
                return false;
            }
            if (this.editUrl != null ? !this.editUrl.equals(that.editUrl) : that.editUrl != null) {
                return false;
            }
            return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.changeUrl != null ? this.changeUrl.hashCode() : 0);
            result = 31 * result + (this.editUrl != null ? this.editUrl.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            return result;
        }
    }

    public static class SimpleScreenScheme
    implements NamedDefault {
        private final String name;
        private final String description;
        private final Long id;
        private final String url;
        private final boolean defaultScreenScheme;

        public SimpleScreenScheme(FieldScreenScheme fieldScreenScheme, String url, boolean defaultScreenScheme) {
            this.name = fieldScreenScheme.getName();
            this.description = fieldScreenScheme.getDescription();
            this.id = fieldScreenScheme.getId();
            this.url = url;
            this.defaultScreenScheme = defaultScreenScheme;
        }

        SimpleScreenScheme(Long id, String name, String description, String url, boolean defaultScreenScheme) {
            this.id = id;
            this.name = name;
            this.description = description;
            this.url = url;
            this.defaultScreenScheme = defaultScreenScheme;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean isDefault() {
            return this.isDefaultScreenScheme();
        }

        public Long getId() {
            return this.id;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean isDefaultScreenScheme() {
            return this.defaultScreenScheme;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleScreenScheme that = (SimpleScreenScheme)o;
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
                return false;
            }
            return !(this.url != null ? !this.url.equals(that.url) : that.url != null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
            return result;
        }
    }
}

