/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.contextproviders;

import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeEntity;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.fields.screen.issuetype.ProjectIssueTypeScreenSchemeHelper;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.issue.operation.ScreenableIssueOperation;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.beans.NamedDefault;
import com.atlassian.jira.projectconfig.beans.SimpleIssueType;
import com.atlassian.jira.projectconfig.beans.SimpleIssueTypeImpl;
import com.atlassian.jira.projectconfig.contextproviders.ContextProviderUtils;
import com.atlassian.jira.projectconfig.order.OrderFactory;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.PluginParseException;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ProjectScreensContextProvider
implements CacheableContextProvider {
    private static final String CONTEXT_ISSUE_TYPE_SCREEN_SCHEME = "issueTypeScreenScheme";
    private static final String CONTEXT_SCREEN_SCHEMES = "screenSchemes";
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private final ContextProviderUtils contextProviderUtils;
    private final ProjectIssueTypeScreenSchemeHelper helper;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final OrderFactory orderFactory;

    public ProjectScreensContextProvider(IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, ContextProviderUtils contextProviderUtils, ProjectIssueTypeScreenSchemeHelper helper, IssueTypeSchemeManager issueTypeSchemeManager, OrderFactory orderFactory) {
        this.contextProviderUtils = contextProviderUtils;
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
        this.helper = helper;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.orderFactory = orderFactory;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        MapBuilder contextMap = MapBuilder.newBuilder().addAll(context);
        Map<String, Object> defaultContext = this.contextProviderUtils.getDefaultContext();
        contextMap.addAll(defaultContext);
        Project project = (Project)defaultContext.get("project");
        IssueTypeScreenScheme issueTypeScreenScheme = this.issueTypeScreenSchemeManager.getIssueTypeScreenScheme(project.getGenericValue());
        Long issueTypeScreenSchemeId = issueTypeScreenScheme.getId();
        SimpleIssueTypeScreenScheme simpleIssueTypeScreenScheme = new SimpleIssueTypeScreenScheme(issueTypeScreenScheme, this.getChangeSchemeUrl(project.getId()), this.getEditSchemeUrl(issueTypeScreenSchemeId), issueTypeScreenSchemeId);
        Set<SimpleScreenScheme> screenSchemes = this.getScreenSchemes(project, issueTypeScreenScheme);
        contextMap.add((Object)CONTEXT_ISSUE_TYPE_SCREEN_SCHEME, (Object)simpleIssueTypeScreenScheme);
        contextMap.add((Object)CONTEXT_SCREEN_SCHEMES, screenSchemes);
        return contextMap.toMap();
    }

    private Set<SimpleScreenScheme> getScreenSchemes(Project project, IssueTypeScreenScheme issueTypeScreenScheme) {
        ArrayList<SimpleIssueType> issueTypeList;
        FieldScreenScheme fieldScreenScheme;
        TreeSet screenSchemes = Sets.newTreeSet(this.orderFactory.createNamedDefaultComparator());
        FieldScreenScheme defaultFieldScreenScheme = issueTypeScreenScheme.getEntity(null).getFieldScreenScheme();
        IssueType defaultIssueType = this.issueTypeSchemeManager.getDefaultIssueType(project);
        HashMap<FieldScreenScheme, ArrayList<SimpleIssueType>> fieldScreenMap = new HashMap<FieldScreenScheme, ArrayList<SimpleIssueType>>();
        for (IssueType issueType : project.getIssueTypes()) {
            IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity = issueTypeScreenScheme.getEntity(issueType.getId());
            fieldScreenScheme = issueTypeScreenSchemeEntity == null ? defaultFieldScreenScheme : issueTypeScreenSchemeEntity.getFieldScreenScheme();
            issueTypeList = (ArrayList<SimpleIssueTypeImpl>)fieldScreenMap.get(fieldScreenScheme);
            if (issueTypeList == null) {
                issueTypeList = new ArrayList<SimpleIssueTypeImpl>();
                fieldScreenMap.put(fieldScreenScheme, issueTypeList);
            }
            issueTypeList.add(new SimpleIssueTypeImpl(issueType, issueType.equals(defaultIssueType)));
        }
        Multimap projectsForFieldScreenSchemes = this.helper.getProjectsForFieldScreenSchemes(fieldScreenMap.keySet());
        for (Map.Entry entry : fieldScreenMap.entrySet()) {
            fieldScreenScheme = (FieldScreenScheme)entry.getKey();
            issueTypeList = (List)entry.getValue();
            Collections.sort(issueTypeList, this.orderFactory.createIssueTypeComparator());
            boolean isDefault = fieldScreenScheme.getId().equals(defaultFieldScreenScheme.getId());
            Collection operations = IssueOperations.getIssueOperations();
            ArrayList<SimpleFieldScreen> screens = new ArrayList<SimpleFieldScreen>();
            for (ScreenableIssueOperation operation : operations) {
                FieldScreen fieldScreen = fieldScreenScheme.getFieldScreen((IssueOperation)operation);
                screens.add(new SimpleFieldScreen(operation, fieldScreen));
            }
            Collection projects = projectsForFieldScreenSchemes.get((Object)fieldScreenScheme);
            SimpleScreenScheme simpleScreenScheme = new SimpleScreenScheme(fieldScreenScheme, this.getScreenSchemeUrl(fieldScreenScheme.getId()), isDefault, issueTypeList, screens, projects);
            screenSchemes.add(simpleScreenScheme);
        }
        return screenSchemes;
    }

    String getChangeSchemeUrl(Long id) {
        return this.createUrlBuilder("/secure/admin/SelectIssueTypeScreenScheme!default.jspa").addParameter("projectId", (Object)id).asUrlString();
    }

    String getEditSchemeUrl(Long id) {
        return this.createUrlBuilder("/secure/admin/ConfigureIssueTypeScreenScheme.jspa").addParameter("id", (Object)id).asUrlString();
    }

    String getScreenSchemeUrl(Long id) {
        return this.createUrlBuilder("/secure/admin/ConfigureFieldScreenScheme.jspa").addParameter("id", (Object)id).asUrlString();
    }

    private UrlBuilder createUrlBuilder(String operation) {
        return this.contextProviderUtils.createUrlBuilder(operation);
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        return this.getClass().getName();
    }

    public static class SimpleIssueTypeScreenScheme {
        private final Long id;
        private final String name;
        private final String changeUrl;
        private final String editUrl;
        private final String description;

        public SimpleIssueTypeScreenScheme(IssueTypeScreenScheme issueTypeScreenScheme, String changeUrl, String editUrl, Long id) {
            this.id = id;
            this.name = issueTypeScreenScheme.getName();
            this.description = issueTypeScreenScheme.getDescription();
            this.changeUrl = changeUrl;
            this.editUrl = editUrl;
        }

        public Long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getChangeUrl() {
            return this.changeUrl;
        }

        public String getEditUrl() {
            return this.editUrl;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleIssueTypeScreenScheme that = (SimpleIssueTypeScreenScheme)o;
            return !(this.id != null ? !this.id.equals(that.id) : that.id != null);
        }

        public int hashCode() {
            return this.id != null ? this.id.hashCode() : 0;
        }
    }

    public static class SimpleFieldScreen
    implements Comparable<SimpleFieldScreen> {
        private final ScreenableIssueOperation operation;
        private final FieldScreen fieldScreen;

        public SimpleFieldScreen(ScreenableIssueOperation operation, FieldScreen fieldScreen) {
            this.operation = operation;
            this.fieldScreen = fieldScreen;
        }

        public IssueOperation getOperation() {
            return this.operation;
        }

        public FieldScreen getFieldScreen() {
            return this.fieldScreen;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleFieldScreen that = (SimpleFieldScreen)o;
            if (this.fieldScreen != null ? !this.fieldScreen.equals(that.fieldScreen) : that.fieldScreen != null) {
                return false;
            }
            return !(this.operation != null ? !this.operation.equals(that.operation) : that.operation != null);
        }

        public int hashCode() {
            int result = this.operation != null ? this.operation.hashCode() : 0;
            result = 31 * result + (this.fieldScreen != null ? this.fieldScreen.hashCode() : 0);
            return result;
        }

        @Override
        public int compareTo(SimpleFieldScreen o) {
            return this.operation.getId().compareTo(o.operation.getId());
        }
    }

    public static class SimpleScreenScheme
    implements NamedDefault {
        private final FieldScreenScheme fieldScreenScheme;
        private final String name;
        private final String description;
        private final Long id;
        private final String url;
        private final boolean defaultScreenScheme;
        private final List<SimpleIssueType> issueTypes;
        private final List<SimpleFieldScreen> screens;
        private final Collection<Project> schemeProjectList;

        public SimpleScreenScheme(FieldScreenScheme fieldScreenScheme, String url, boolean defaultScreenScheme, List<SimpleIssueType> issueTypes, List<SimpleFieldScreen> screens, Collection<Project> projects) {
            this.fieldScreenScheme = fieldScreenScheme;
            this.name = fieldScreenScheme.getName();
            this.description = fieldScreenScheme.getDescription();
            this.id = fieldScreenScheme.getId();
            this.url = url;
            this.defaultScreenScheme = defaultScreenScheme;
            this.issueTypes = issueTypes;
            this.screens = screens;
            this.schemeProjectList = projects;
        }

        public FieldScreenScheme getFieldScreenScheme() {
            return this.fieldScreenScheme;
        }

        public Long getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean isDefault() {
            return this.isDefaultScreenScheme();
        }

        public String getUrl() {
            return this.url;
        }

        public boolean isDefaultScreenScheme() {
            return this.defaultScreenScheme;
        }

        public List<SimpleIssueType> getIssueTypes() {
            return this.issueTypes;
        }

        public List<SimpleFieldScreen> getScreens() {
            return this.screens;
        }

        public Collection<Project> getSchemeProjectList() {
            return this.schemeProjectList;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleScreenScheme that = (SimpleScreenScheme)o;
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
                return false;
            }
            return !(this.url != null ? !this.url.equals(that.url) : that.url != null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
            return result;
        }
    }
}

