/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.contextproviders;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.plugin.profile.UserFormatManager;
import com.atlassian.jira.projectconfig.contextproviders.ContextProviderUtils;
import com.atlassian.jira.projectconfig.contextproviders.ProjectPeopleContextProvider;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import java.util.Map;

public class ProjectRoleContextProvider
extends ProjectPeopleContextProvider {
    static final String CONTEXT_DEFAULT_ASSIGNEE_AVATAR_URL_KEY = "defaultAssigneeAvatarUrl";
    private final AvatarService avatarService;
    private final I18nHelper i18nHelper;

    public ProjectRoleContextProvider(PermissionManager permissionManager, UserFormatManager userFormatManager, UserManager userManager, AvatarService avatarService, ContextProviderUtils contextProviderUtils, JiraAuthenticationContext authenticationContext, I18nHelper i18nHelper) {
        super(permissionManager, userFormatManager, userManager, avatarService, contextProviderUtils, authenticationContext);
        this.avatarService = avatarService;
        this.i18nHelper = i18nHelper;
    }

    @Override
    public Map<String, Object> getContextMap(Map<String, Object> context) {
        Map<String, Object> contextMap = super.getContextMap(context);
        MapBuilder contextMapBuilder = MapBuilder.newBuilder().addAll(contextMap);
        String defaultAssigneeKey = (String)contextMap.get("defaultAssignee");
        String defaultAssignee = this.i18nHelper.getText(defaultAssigneeKey);
        contextMapBuilder.add((Object)"defaultAssignee", (Object)defaultAssignee);
        if ("admin.assignee.type.unassigned".equals(defaultAssigneeKey)) {
            contextMapBuilder.add((Object)CONTEXT_DEFAULT_ASSIGNEE_AVATAR_URL_KEY, (Object)this.getAnonymousAvatar());
        }
        return contextMapBuilder.toMap();
    }

    private String getAnonymousAvatar() {
        ApplicationUser anonymousUser = null;
        return this.avatarService.getAvatarURL(anonymousUser, anonymousUser, Avatar.Size.SMALL).toString();
    }
}

