/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.contextproviders;

import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.ProjectPermission;
import com.atlassian.jira.permission.ProjectPermissionCategory;
import com.atlassian.jira.permission.ProjectPermissionSchemeHelper;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.contextproviders.ContextProviderUtils;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.SecurityTypeManager;
import com.atlassian.jira.security.type.SecurityType;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SecurityTypeUtils;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.PluginParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class ProjectPermissionContextProvider
implements CacheableContextProvider {
    private static final String CONTEXT_SCHEME_SHARED_PROJECTS_KEY = "sharedProjects";
    private static final String CONTEXT_SCHEME_NAME = "schemeName";
    private static final String CONTEXT_SCHEME_ID = "schemeId";
    private static final String CONTEXT_SCHEME_DESCRIPTION = "schemeDescription";
    private static final String CONTEXT_PERMISSION_GROUPS = "permissionGroups";
    private static final String ENTITY_TYPE = "type";
    private static final String ENTITY_PARAMETER = "parameter";
    private static final String SCHEME_NAME = "name";
    private static final String SCHEME_ID = "id";
    private static final String SCHEME_DESCRIPTION = "description";
    private final PermissionManager permissionManager;
    private final PermissionSchemeManager permissionSchemeManager;
    private final SecurityTypeManager securityTypeManager;
    private final ContextProviderUtils contextProviderUtils;
    private final ProjectPermissionSchemeHelper helper;

    public ProjectPermissionContextProvider(PermissionManager permissionManager, PermissionSchemeManager permissionSchemeManager, SecurityTypeManager securityTypeManager, ContextProviderUtils contextProviderUtils, ProjectPermissionSchemeHelper helper) {
        this.permissionManager = permissionManager;
        this.securityTypeManager = securityTypeManager;
        this.contextProviderUtils = contextProviderUtils;
        this.helper = helper;
        this.permissionSchemeManager = permissionSchemeManager;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        MapBuilder contextMap = MapBuilder.newBuilder().addAll(context);
        Map<String, Object> defaultContext = this.contextProviderUtils.getDefaultContext();
        contextMap.addAll(defaultContext);
        Project project = (Project)defaultContext.get("project");
        I18nHelper i18nHelper = (I18nHelper)defaultContext.get("i18n");
        GenericValue scheme = this.getProjectPermissionsScheme(project);
        Scheme permissionScheme = this.permissionSchemeManager.getSchemeObject(scheme.getLong(SCHEME_ID));
        List sharedProjects = this.helper.getSharedProjects(permissionScheme);
        contextMap.add((Object)CONTEXT_SCHEME_SHARED_PROJECTS_KEY, (Object)sharedProjects);
        contextMap.add((Object)CONTEXT_SCHEME_NAME, (Object)scheme.getString(SCHEME_NAME));
        contextMap.add((Object)CONTEXT_SCHEME_ID, (Object)scheme.getLong(SCHEME_ID));
        String description = scheme.getString(SCHEME_DESCRIPTION);
        if (StringUtils.isNotBlank((String)description)) {
            contextMap.add((Object)CONTEXT_SCHEME_DESCRIPTION, (Object)description);
        }
        ArrayList<SimplePermissionGroup> permissionGroups = new ArrayList<SimplePermissionGroup>();
        permissionGroups.add(new SimplePermissionGroup("project", i18nHelper.getText("admin.permission.group.project.permissions"), this.getPermission(i18nHelper, scheme, this.permissionManager.getProjectPermissions(ProjectPermissionCategory.PROJECTS))));
        permissionGroups.add(new SimplePermissionGroup("issue", i18nHelper.getText("admin.permission.group.issue.permissions"), this.getPermission(i18nHelper, scheme, this.permissionManager.getProjectPermissions(ProjectPermissionCategory.ISSUES))));
        permissionGroups.add(new SimplePermissionGroup("voterAndWatchers", i18nHelper.getText("admin.permission.group.voters.and.watchers.permissions"), this.getPermission(i18nHelper, scheme, this.permissionManager.getProjectPermissions(ProjectPermissionCategory.VOTERS_AND_WATCHERS))));
        permissionGroups.add(new SimplePermissionGroup("comments", i18nHelper.getText("admin.permission.group.comments.permissions"), this.getPermission(i18nHelper, scheme, this.permissionManager.getProjectPermissions(ProjectPermissionCategory.COMMENTS))));
        permissionGroups.add(new SimplePermissionGroup("attachments", i18nHelper.getText("admin.permission.group.attachments.permissions"), this.getPermission(i18nHelper, scheme, this.permissionManager.getProjectPermissions(ProjectPermissionCategory.ATTACHMENTS))));
        permissionGroups.add(new SimplePermissionGroup("timeTracking", i18nHelper.getText("admin.permission.group.time.tracking.permissions"), this.getPermission(i18nHelper, scheme, this.permissionManager.getProjectPermissions(ProjectPermissionCategory.TIME_TRACKING))));
        if (!this.permissionManager.getProjectPermissions(ProjectPermissionCategory.OTHER).isEmpty()) {
            permissionGroups.add(new SimplePermissionGroup("other", i18nHelper.getText("admin.permission.group.other.permissions"), this.getPermission(i18nHelper, scheme, this.permissionManager.getProjectPermissions(ProjectPermissionCategory.OTHER))));
        }
        contextMap.add((Object)CONTEXT_PERMISSION_GROUPS, permissionGroups);
        return contextMap.toMap();
    }

    private List<SimplePermission> getPermission(I18nHelper i18nHelper, GenericValue scheme, Collection<ProjectPermission> permissions) {
        ArrayList<SimplePermission> returnPermissions = new ArrayList<SimplePermission>(permissions.size());
        for (ProjectPermission permission : permissions) {
            List<GenericValue> entities = this.getEntities(scheme, permission);
            ArrayList<String> entityDisplays = new ArrayList<String>(entities.size());
            for (GenericValue entity : entities) {
                String typeStr = entity.getString(ENTITY_TYPE);
                SecurityType type = this.securityTypeManager.getSecurityType(typeStr);
                if (type != null) {
                    StringBuilder sb = new StringBuilder(type.getDisplayName());
                    String parameter = entity.getString(ENTITY_PARAMETER);
                    sb.append(" ");
                    sb.append(SecurityTypeUtils.formatSecurityTypeParameter((String)type.getType(), (String)type.getArgumentDisplay(parameter), (I18nHelper)i18nHelper));
                    entityDisplays.add(sb.toString());
                    continue;
                }
                entityDisplays.add(i18nHelper.getText("admin.schemes.issuesecurity.unknown.type", typeStr));
            }
            returnPermissions.add(new SimplePermission(permission.getKey(), i18nHelper.getText(permission.getNameI18nKey()), i18nHelper.getText(permission.getDescriptionI18nKey()), entityDisplays));
        }
        return returnPermissions;
    }

    private List<GenericValue> getEntities(GenericValue scheme, ProjectPermission permission) {
        try {
            return this.permissionSchemeManager.getEntities(scheme, permission.getKey());
        }
        catch (GenericEntityException e) {
            throw new RuntimeException(e);
        }
    }

    private GenericValue getProjectPermissionsScheme(Project project) {
        try {
            return EntityUtil.getOnly((List)this.permissionSchemeManager.getSchemes(project.getGenericValue()));
        }
        catch (GenericEntityException e) {
            throw new RuntimeException(e);
        }
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        return this.getClass().getName();
    }

    public static class SimplePermission {
        private final String shortName;
        private final String name;
        private final String description;
        private final List<String> entities;

        public SimplePermission(String shortName, String name, String description, List<String> entities) {
            this.shortName = shortName;
            this.name = name;
            this.description = description;
            this.entities = entities;
        }

        public String getShortName() {
            return this.shortName;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public List<String> getEntities() {
            return this.entities;
        }
    }

    public static class SimplePermissionGroup {
        private final String id;
        private final String name;
        private final List<SimplePermission> permissions;

        public SimplePermissionGroup(String id, String name, List<SimplePermission> permissions) {
            this.id = id;
            this.name = name;
            this.permissions = permissions;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public List<SimplePermission> getPermissions() {
            return this.permissions;
        }
    }
}

