/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.contextproviders;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.plugin.profile.UserFormatManager;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectAssigneeTypes;
import com.atlassian.jira.projectconfig.contextproviders.ContextProviderUtils;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.PluginParseException;
import java.util.Map;

public class ProjectPeopleContextProvider
implements CacheableContextProvider {
    static final String CONTEXT_PROJECT_LEAD_EXISTS_KEY = "projectLeadExists";
    static final String CONTEXT_PROJECT_LEAD_KEY = "projectLeadHtml";
    static final String CONTEXT_IS_DEFAULT_ASSIGNEE_ASSIGNABLE_KEY = "defaultAssigneeAssignable";
    static final String CONTEXT_DEFAULT_ASSIGNEE_KEY = "defaultAssignee";
    static final String CONTEXT_DEFAULT_ASSIGNEE_EDITABLE = "defaultAssigneeEditable";
    static final String CONTEXT_IS_USER_AVATARS_ENABLED_KEY = "userAvatarsEnabled";
    static final String CONTEXT_LEAD_USER_AVATAR_URL_KEY = "userAvatarUrl";
    static final String CONTEXT_CURRENT_USER_CAN_BROWSE_USERS = "currentUserCanBrowseUsers";
    private final PermissionManager permissionManager;
    private final UserFormatManager userFormatManager;
    private final UserManager userManager;
    private final AvatarService avatarService;
    private final ContextProviderUtils contextProviderUtils;
    private final JiraAuthenticationContext authenticationContext;

    public ProjectPeopleContextProvider(PermissionManager permissionManager, UserFormatManager userFormatManager, UserManager userManager, AvatarService avatarService, ContextProviderUtils contextProviderUtils, JiraAuthenticationContext authenticationContext) {
        this.permissionManager = permissionManager;
        this.userFormatManager = userFormatManager;
        this.userManager = userManager;
        this.avatarService = avatarService;
        this.contextProviderUtils = contextProviderUtils;
        this.authenticationContext = authenticationContext;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        MapBuilder contextMap = MapBuilder.newBuilder().addAll(context);
        Map<String, Object> defaultContext = this.contextProviderUtils.getDefaultContext();
        contextMap.addAll(defaultContext);
        Project project = (Project)defaultContext.get("project");
        String leadUserKey = project.getLeadUserKey();
        ApplicationUser leadUser = this.getUser(leadUserKey);
        String leadUserString = this.userFormatManager.formatUserkey(leadUserKey, "profileLink", "projectLead");
        String userAvatarUrl = this.avatarService.getAvatarURL(leadUser, leadUser, Avatar.Size.SMALL).toString();
        contextMap.add((Object)CONTEXT_PROJECT_LEAD_EXISTS_KEY, (Object)(leadUser != null ? 1 : 0));
        contextMap.add((Object)CONTEXT_PROJECT_LEAD_KEY, (Object)leadUserString);
        contextMap.add((Object)CONTEXT_IS_DEFAULT_ASSIGNEE_ASSIGNABLE_KEY, (Object)this.isDefaultAssigneeAssignable(project));
        contextMap.add((Object)CONTEXT_DEFAULT_ASSIGNEE_KEY, (Object)this.getPrettyAssigneeTypeString(project.getAssigneeType()));
        contextMap.add((Object)CONTEXT_DEFAULT_ASSIGNEE_EDITABLE, (Object)this.isDefaultAssigneeEditable());
        contextMap.add((Object)CONTEXT_LEAD_USER_AVATAR_URL_KEY, (Object)userAvatarUrl);
        contextMap.add((Object)CONTEXT_CURRENT_USER_CAN_BROWSE_USERS, (Object)this.permissionManager.hasPermission(27, this.authenticationContext.getLoggedInUser()));
        return contextMap.toMap();
    }

    private boolean isDefaultAssigneeEditable() {
        return ProjectAssigneeTypes.getAssigneeTypes().size() > 1;
    }

    private boolean isDefaultAssigneeAssignable(Project project) {
        Long assigneeType = project.getAssigneeType();
        if (assigneeType != null && 2L == assigneeType) {
            ApplicationUser projectLead = this.getUser(project.getLeadUserName());
            if (projectLead == null) {
                return false;
            }
            return this.permissionManager.hasPermission(17, project, projectLead);
        }
        return true;
    }

    private ApplicationUser getUser(String userkey) {
        return this.userManager.getUserByKey(userkey);
    }

    String getPrettyAssigneeTypeString(Long assigneeType) {
        return ProjectAssigneeTypes.getPrettyAssigneeType((Long)assigneeType);
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        return this.getClass().getName();
    }
}

