/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.contextproviders;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.notification.NotificationType;
import com.atlassian.jira.notification.NotificationTypeManager;
import com.atlassian.jira.notification.ProjectNotificationsSchemeHelper;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.contextproviders.ContextProviderUtils;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.plugin.PluginParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class ProjectNotificationContextProvider
implements CacheableContextProvider {
    private static final String CONTEXT_SHARED_PROJECTS_KEY = "sharedProjects";
    private static final String CONTEXT_SCHEME_NAME = "schemeName";
    private static final String CONTEXT_SCHEME_ID = "schemeId";
    private static final String CONTEXT_SCHEME_DESCRIPTION = "schemeDescription";
    private static final String CONTEXT_NOTIFICATIONS = "notifications";
    private static final String CONTEXT_HAS_ADMIN_PERMISSION = "isAdmin";
    private static final String PROJECT_EMAIL = "projectEmail";
    private static final String HAS_CONFIGURED_MAIL_SERVER = "hasConfiguredMailServer";
    private static final String ENTITY_TYPE = "type";
    private static final String ENTITY_PARAMETER = "parameter";
    private static final String SCHEME_NAME = "name";
    private static final String SCHEME_ID = "id";
    private static final String SCHEME_DESCRIPTION = "description";
    private final NotificationTypeManager notificationTypeManager;
    private final NotificationSchemeManager notificationSchemeManager;
    private final ProjectNotificationsSchemeHelper helper;
    private final MailServerManager mailServerManager;
    private final ContextProviderUtils contextProviderUtils;
    private final JiraAuthenticationContext ctx;

    public ProjectNotificationContextProvider(NotificationSchemeManager notificationSchemeManager, ContextProviderUtils contextProviderUtils, ProjectNotificationsSchemeHelper helper, MailServerManager mailServerManager) {
        this.contextProviderUtils = contextProviderUtils;
        this.notificationSchemeManager = notificationSchemeManager;
        this.helper = helper;
        this.mailServerManager = mailServerManager;
        this.notificationTypeManager = (NotificationTypeManager)ComponentAccessor.getComponentOfType(NotificationTypeManager.class);
        this.ctx = (JiraAuthenticationContext)ComponentAccessor.getComponentOfType(JiraAuthenticationContext.class);
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        MapBuilder contextMap = MapBuilder.newBuilder().addAll(context);
        Map<String, Object> defaultContext = this.contextProviderUtils.getDefaultContext();
        contextMap.addAll(defaultContext);
        Project project = (Project)defaultContext.get("project");
        I18nHelper i18nHelper = (I18nHelper)defaultContext.get("i18n");
        GenericValue scheme = this.getNotificationScheme(project);
        if (scheme != null) {
            Scheme notificationScheme = this.notificationSchemeManager.getSchemeObject(scheme.getLong(SCHEME_ID));
            List sharedProjects = this.helper.getSharedProjects(notificationScheme);
            contextMap.add((Object)CONTEXT_SHARED_PROJECTS_KEY, (Object)sharedProjects);
            contextMap.add((Object)CONTEXT_SCHEME_NAME, (Object)scheme.getString(SCHEME_NAME));
            contextMap.add((Object)CONTEXT_SCHEME_ID, (Object)scheme.getLong(SCHEME_ID));
            String description = scheme.getString(SCHEME_DESCRIPTION);
            if (StringUtils.isNotBlank((String)description)) {
                contextMap.add((Object)CONTEXT_SCHEME_DESCRIPTION, (Object)description);
            }
            List<Notification> notifications = this.getNotifications(scheme);
            contextMap.add((Object)CONTEXT_NOTIFICATIONS, notifications);
        } else {
            contextMap.add((Object)CONTEXT_SCHEME_NAME, (Object)i18nHelper.getText("common.words.none"));
        }
        try {
            if (this.hasDefaultSMTPMailServer()) {
                contextMap.add((Object)HAS_CONFIGURED_MAIL_SERVER, (Object)true);
            }
        }
        catch (MailException e) {
            throw new RuntimeException(e);
        }
        try {
            if (this.hasDefaultSMTPMailServer()) {
                String projectEmail = this.contextProviderUtils.getProject().getEmail();
                String defaultEmail = this.getDefaultEmail();
                contextMap.add((Object)HAS_CONFIGURED_MAIL_SERVER, (Object)true);
                if (projectEmail != null) {
                    contextMap.add((Object)PROJECT_EMAIL, (Object)projectEmail);
                } else if (defaultEmail != null) {
                    contextMap.add((Object)PROJECT_EMAIL, (Object)defaultEmail);
                }
            }
        }
        catch (MailException e) {
            throw new RuntimeException(e);
        }
        return contextMap.toMap();
    }

    private String getDefaultEmail() throws MailException {
        SMTPMailServer defaultSMTPMailServer = this.mailServerManager.getDefaultSMTPMailServer();
        if (defaultSMTPMailServer != null) {
            return defaultSMTPMailServer.getDefaultFrom();
        }
        return null;
    }

    private List<Notification> getNotifications(GenericValue scheme) {
        Collection<EventType> eventTypes = this.getEventTypes();
        ArrayList<Notification> notificationList = new ArrayList<Notification>(eventTypes.size());
        for (EventType eventType : eventTypes) {
            List<GenericValue> entities = this.getEntities(scheme, eventType.getId());
            ArrayList<String> entityDisplays = new ArrayList<String>(entities.size());
            for (GenericValue entity : entities) {
                String typeStr = entity.getString(ENTITY_TYPE);
                NotificationType type = this.notificationTypeManager.getNotificationType(typeStr);
                String paramater = entity.getString(ENTITY_PARAMETER);
                StringBuilder sb = new StringBuilder(type.getDisplayName());
                if (StringUtils.isNotBlank((String)paramater)) {
                    sb.append(" (").append(type.getArgumentDisplay(paramater)).append(")");
                }
                entityDisplays.add(sb.toString());
            }
            Collections.sort(entityDisplays);
            notificationList.add(new Notification(eventType.getId(), eventType.getTranslatedName(this.ctx.getLoggedInUser()), eventType.getTranslatedDesc(this.ctx.getLoggedInUser()), entityDisplays));
        }
        return notificationList;
    }

    private List<GenericValue> getEntities(GenericValue scheme, Long eventTypeId) {
        try {
            return this.notificationSchemeManager.getEntities(scheme, eventTypeId);
        }
        catch (GenericEntityException e) {
            throw new RuntimeException(e);
        }
    }

    private Collection<EventType> getEventTypes() {
        return ComponentAccessor.getEventTypeManager().getEventTypesMap().values();
    }

    private GenericValue getNotificationScheme(Project project) {
        return this.notificationSchemeManager.getNotificationSchemeForProject(project.getGenericValue());
    }

    private boolean hasDefaultSMTPMailServer() throws MailException {
        return MailFactory.getServerManager().getDefaultSMTPMailServer() != null;
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        return this.getClass().getName();
    }

    public static class Notification {
        private final Long id;
        private final String name;
        private final String description;
        private final List<String> entities;

        public Notification(Long id, String name, String description, List<String> entities) {
            this.id = id;
            this.name = name;
            this.entities = entities;
            this.description = description;
        }

        public Long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public List<String> getEntities() {
            return this.entities;
        }
    }
}

