/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.contextproviders;

import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeEntity;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.beans.SimpleIssueType;
import com.atlassian.jira.projectconfig.contextproviders.ContextProviderUtils;
import com.atlassian.jira.projectconfig.order.OrderFactory;
import com.atlassian.jira.projectconfig.shared.SharedEntitiesHelper;
import com.atlassian.jira.projectconfig.shared.SharedIssueTypeWorkflowData;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.plugin.PluginParseException;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class ProjectIssueTypeContextProvider
implements CacheableContextProvider {
    static final String CONTEXT_ISSUE_TYPES_KEY = "issueTypes";
    static final String CONTEXT_ISSUE_TYPE_SCHEME_KEY = "issueTypeScheme";
    static final String CONTEXT_ERRORS_KEY = "errors";
    static final String ISSUE_TYPE_SCHEME_ERROR_I18N_KEY = "admin.project.config.summary.issuetypes.no.issuetypescheme.error";
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final OrderFactory orderFactory;
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private final ContextProviderUtils contextProviderUtils;
    private final SharedEntitiesHelper sharedHelper;

    public ProjectIssueTypeContextProvider(IssueTypeSchemeManager issueTypeSchemeManager, ContextProviderUtils contextProviderUtils, WorkflowSchemeManager workflowSchemeManager, IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, FieldLayoutManager fieldLayoutManager, OrderFactory orderFactory, SharedEntitiesHelper sharedHelper) {
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.contextProviderUtils = contextProviderUtils;
        this.workflowSchemeManager = workflowSchemeManager;
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.orderFactory = orderFactory;
        this.sharedHelper = sharedHelper;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        ArrayList errors = Lists.newArrayList();
        MapBuilder contextMap = MapBuilder.newBuilder().addAll(context);
        Map<String, Object> defaultContext = this.contextProviderUtils.getDefaultContext();
        contextMap.addAll(defaultContext);
        Project project = (Project)defaultContext.get("project");
        I18nHelper i18nHelper = (I18nHelper)defaultContext.get("i18n");
        Collection<ProjectIssueType> simpleIssueTypes = this.getSimpleIssueTypes(project);
        FieldConfigScheme issueTypeScheme = this.issueTypeSchemeManager.getConfigScheme(project);
        if (issueTypeScheme == null) {
            errors.add(i18nHelper.getText(ISSUE_TYPE_SCHEME_ERROR_I18N_KEY));
        }
        contextMap.add((Object)CONTEXT_ISSUE_TYPES_KEY, simpleIssueTypes);
        contextMap.add((Object)CONTEXT_ISSUE_TYPE_SCHEME_KEY, (Object)issueTypeScheme);
        contextMap.add((Object)CONTEXT_ERRORS_KEY, (Object)errors);
        return contextMap.toMap();
    }

    private Collection<ProjectIssueType> getSimpleIssueTypes(Project project) {
        Collection issueTypes = this.issueTypeSchemeManager.getIssueTypesForProject(project);
        IssueType defaultIssueType = this.issueTypeSchemeManager.getDefaultIssueType(project);
        ArrayList simpleIssueTypes = Lists.newArrayList();
        for (IssueType issueType : issueTypes) {
            String workflowName = this.getWorkflow(project, issueType);
            FieldScreenScheme fieldScreenScheme = this.getIssueTypeScreenScheme(project, issueType);
            FieldLayout fieldLayout = this.getFieldLayout(project, issueType);
            boolean isDefault = defaultIssueType != null && defaultIssueType.equals(issueType);
            SharedIssueTypeWorkflowData sharedBy = this.sharedHelper.getSharedData(project, issueType, workflowName);
            simpleIssueTypes.add(new ProjectIssueType(issueType, isDefault, workflowName, fieldScreenScheme, fieldLayout, sharedBy));
        }
        Collections.sort(simpleIssueTypes, this.orderFactory.createIssueTypeComparator());
        return simpleIssueTypes;
    }

    private FieldLayout getFieldLayout(Project project, IssueType issueType) {
        return this.fieldLayoutManager.getFieldLayout(project, issueType.getId());
    }

    private FieldScreenScheme getIssueTypeScreenScheme(Project project, IssueType issueType) {
        IssueTypeScreenScheme issueTypeScreenScheme = this.issueTypeScreenSchemeManager.getIssueTypeScreenScheme(project.getGenericValue());
        IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity = issueTypeScreenScheme.getEntity(issueType.getId());
        if (issueTypeScreenSchemeEntity == null && (issueTypeScreenSchemeEntity = issueTypeScreenScheme.getEntity(null)) == null) {
            throw new IllegalStateException("No default entity for issue type screen scheme with id '" + issueTypeScreenScheme.getId() + "'.");
        }
        return issueTypeScreenSchemeEntity.getFieldScreenScheme();
    }

    private String getWorkflow(Project project, IssueType issueType) {
        return this.workflowSchemeManager.getWorkflowName(project, issueType.getId());
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        return this.getClass().getName();
    }

    public static class ProjectIssueType
    implements SimpleIssueType {
        private final String iconUrl;
        private final String name;
        private final String description;
        private final String id;
        private final boolean subTask;
        private final boolean defaultIssueType;
        private final String workflowName;
        private final FieldScreenScheme fieldScreenScheme;
        private final FieldLayout fieldLayout;
        private final IssueType issueType;
        private final SharedIssueTypeWorkflowData sharedBy;

        public ProjectIssueType(IssueType issueType, boolean defaultIssueType, String workflowName, FieldScreenScheme fieldScreenScheme, FieldLayout fieldLayout, SharedIssueTypeWorkflowData sharedBy) {
            this.issueType = issueType;
            this.id = issueType.getId();
            this.name = issueType.getNameTranslation();
            this.description = issueType.getDescTranslation();
            this.iconUrl = issueType.getIconUrl();
            this.subTask = issueType.isSubTask();
            this.defaultIssueType = defaultIssueType;
            this.workflowName = workflowName;
            this.fieldScreenScheme = fieldScreenScheme;
            this.fieldLayout = fieldLayout;
            this.sharedBy = sharedBy;
        }

        @Override
        public String getIconUrl() {
            return this.iconUrl;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isDefault() {
            return this.isDefaultIssueType();
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public boolean isSubTask() {
            return this.subTask;
        }

        @Override
        public boolean isDefaultIssueType() {
            return this.defaultIssueType;
        }

        public String getWorkflowName() {
            return this.workflowName;
        }

        public FieldScreenScheme getFieldScreenScheme() {
            return this.fieldScreenScheme;
        }

        public FieldLayout getFieldLayout() {
            return this.fieldLayout;
        }

        @Override
        public IssueType getConstant() {
            return this.issueType;
        }

        public SharedIssueTypeWorkflowData getSharedBy() {
            return this.sharedBy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProjectIssueType that = (ProjectIssueType)o;
            if (this.subTask != that.subTask) {
                return false;
            }
            if (this.iconUrl != null ? !this.iconUrl.equals(that.iconUrl) : that.iconUrl != null) {
                return false;
            }
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            return !(this.sharedBy != null ? !this.sharedBy.equals(that.sharedBy) : that.sharedBy != null);
        }

        public int hashCode() {
            int result = this.iconUrl != null ? this.iconUrl.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            result = 31 * result + (this.subTask ? 1 : 0);
            result = 31 * result + (this.sharedBy != null ? this.sharedBy.hashCode() : 0);
            return result;
        }
    }
}

