/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.contextproviders;

import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.issue.security.ProjectIssueSecuritySchemeHelper;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.contextproviders.ContextProviderUtils;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.SecurityTypeManager;
import com.atlassian.jira.security.type.AbstractSecurityType;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SecurityTypeUtils;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.PluginParseException;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class ProjectIssueSecurityContextProvider
implements CacheableContextProvider {
    private static final String CONTEXT_SHARED_PREOJECTS_KEY = "sharedProjects";
    private static final String CONTEXT_SCHEME_NAME = "schemeName";
    private static final String CONTEXT_SCHEME_ID = "schemeId";
    private static final String CONTEXT_SCHEME_DESCRIPTION = "schemeDescription";
    private static final String CONTEXT_ISSUESECURITYS = "issueSecurities";
    private static final String ENTITY_TYPE = "type";
    private static final String ENTITY_PARAMETER = "parameter";
    private static final String SCHEME_NAME = "name";
    private static final String SCHEME_ID = "id";
    private static final String SCHEME_DESCRIPTION = "description";
    private final SecurityTypeManager securityTypeManager;
    private final ProjectIssueSecuritySchemeHelper helper;
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    private final ContextProviderUtils contextProviderUtils;

    public ProjectIssueSecurityContextProvider(IssueSecuritySchemeManager issueSecuritySchemeManager, ContextProviderUtils contextProviderUtils, IssueSecurityLevelManager issueSecurityLevelManager, SecurityTypeManager securityTypeManager, ProjectIssueSecuritySchemeHelper helper) {
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.contextProviderUtils = contextProviderUtils;
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.securityTypeManager = securityTypeManager;
        this.helper = helper;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        ArrayList errors = Lists.newArrayList();
        MapBuilder contextMap = MapBuilder.newBuilder().addAll(context);
        Map<String, Object> defaultContext = this.contextProviderUtils.getDefaultContext();
        contextMap.addAll(defaultContext);
        Project project = (Project)defaultContext.get("project");
        I18nHelper i18nHelper = (I18nHelper)defaultContext.get("i18n");
        GenericValue scheme = this.getIssueSecurityScheme(project);
        if (scheme != null) {
            Scheme schemeObject = this.issueSecuritySchemeManager.getSchemeObject(scheme.getLong(SCHEME_ID));
            List sharedProjects = this.helper.getSharedProjects(schemeObject);
            contextMap.add((Object)CONTEXT_SHARED_PREOJECTS_KEY, (Object)sharedProjects);
            contextMap.add((Object)CONTEXT_SCHEME_NAME, (Object)scheme.getString(SCHEME_NAME));
            contextMap.add((Object)CONTEXT_SCHEME_ID, (Object)scheme.getLong(SCHEME_ID));
            String description = scheme.getString(SCHEME_DESCRIPTION);
            if (StringUtils.isNotBlank((String)description)) {
                contextMap.add((Object)CONTEXT_SCHEME_DESCRIPTION, (Object)description);
            }
            List<IssueSecurity> issueSecurities = this.getIssueSecurities(scheme, i18nHelper);
            contextMap.add((Object)CONTEXT_ISSUESECURITYS, issueSecurities);
        } else {
            contextMap.add((Object)CONTEXT_SCHEME_NAME, (Object)i18nHelper.getText("admin.common.words.anyone"));
        }
        return contextMap.toMap();
    }

    private GenericValue getIssueSecurityScheme(Project project) {
        try {
            List schemes = this.issueSecuritySchemeManager.getSchemes(project.getGenericValue());
            if (schemes.size() > 0) {
                return (GenericValue)schemes.get(0);
            }
        }
        catch (GenericEntityException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private List<IssueSecurity> getIssueSecurities(GenericValue scheme, I18nHelper i18nHelper) {
        Long defaultLevel = scheme.getLong("defaultlevel");
        List securityLevels = this.issueSecurityLevelManager.getSchemeIssueSecurityLevels(scheme.getLong(SCHEME_ID));
        ArrayList<IssueSecurity> issueSecurityLevels = new ArrayList<IssueSecurity>();
        for (GenericValue issueSecurityLevel : securityLevels) {
            Long id = issueSecurityLevel.getLong(SCHEME_ID);
            boolean defaultSecurityLevel = id.equals(defaultLevel);
            List<GenericValue> entities = this.getEntities(scheme, id);
            ArrayList<String> entityDisplays = new ArrayList<String>(entities.size());
            for (GenericValue entity : entities) {
                String typeStr = entity.getString(ENTITY_TYPE);
                AbstractSecurityType type = (AbstractSecurityType)this.securityTypeManager.getSchemeType(typeStr);
                if (type != null) {
                    String parameter = entity.getString(ENTITY_PARAMETER);
                    StringBuilder sb = new StringBuilder(type.getDisplayName());
                    sb.append(" ");
                    sb.append(SecurityTypeUtils.formatSecurityTypeParameter((String)type.getType(), (String)type.getArgumentDisplay(parameter), (I18nHelper)i18nHelper));
                    entityDisplays.add(sb.toString());
                    continue;
                }
                entityDisplays.add(i18nHelper.getText("admin.schemes.issuesecurity.unknown.type", typeStr));
            }
            Collections.sort(entityDisplays);
            issueSecurityLevels.add(new IssueSecurity(issueSecurityLevel.getString(SCHEME_NAME), issueSecurityLevel.getString(SCHEME_DESCRIPTION), entityDisplays, defaultSecurityLevel));
        }
        Collections.sort(issueSecurityLevels);
        return issueSecurityLevels;
    }

    private List<GenericValue> getEntities(GenericValue scheme, Long level) {
        try {
            return this.issueSecuritySchemeManager.getEntities(scheme, level);
        }
        catch (GenericEntityException e) {
            throw new RuntimeException(e);
        }
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        return this.getClass().getName();
    }

    public static class IssueSecurity
    implements Comparable<IssueSecurity> {
        private final String name;
        private final String description;
        private final List<String> entities;
        private final boolean defaultSecurityLevel;

        public IssueSecurity(String name, String description, List<String> entities, boolean defaultSecurityLevel) {
            this.name = name;
            this.entities = entities;
            this.description = description;
            this.defaultSecurityLevel = defaultSecurityLevel;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public List<String> getEntities() {
            return this.entities;
        }

        public boolean isDefaultSecurityLevel() {
            return this.defaultSecurityLevel;
        }

        @Override
        public int compareTo(IssueSecurity o) {
            boolean otherDefSort;
            boolean defSort = !this.defaultSecurityLevel;
            boolean bl = otherDefSort = !o.isDefaultSecurityLevel();
            if (defSort == otherDefSort) {
                return this.name.compareTo(o.getName());
            }
            return defSort < otherDefSort ? -1 : 1;
        }
    }
}

