/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.contextproviders;

import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.projectconfig.contextproviders.ContextProviderUtils;
import com.atlassian.jira.projectconfig.util.TabUrlFactory;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.plugin.PluginParseException;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class NotificationsSummaryPanelContextProvider
implements CacheableContextProvider {
    private static final String NOTIFICATION_SCHEME = "notificationScheme";
    private static final String PROJECT_EMAIL = "projectEmail";
    private static final String HAS_CONFIGURED_MAIL_SERVER = "hasConfiguredMailServer";
    private static final String MANAGE_URL = "manageUrl";
    private final NotificationSchemeManager notificationSchemeManager;
    private final ContextProviderUtils providerUtils;
    private final MailServerManager mailServerManager;
    private final TabUrlFactory tabUrlFactory;

    public NotificationsSummaryPanelContextProvider(NotificationSchemeManager notificationSchemeManager, ContextProviderUtils providerUtils, MailServerManager mailServerManager, TabUrlFactory tabUrlFactory) {
        this.notificationSchemeManager = notificationSchemeManager;
        this.providerUtils = providerUtils;
        this.mailServerManager = mailServerManager;
        this.tabUrlFactory = tabUrlFactory;
    }

    public void init(Map<String, String> stringStringMap) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        MapBuilder contextMap = MapBuilder.newBuilder().addAll(context);
        GenericValue projectGV = this.getProjectGV();
        GenericValue notificationGV = this.notificationSchemeManager.getNotificationSchemeForProject(projectGV);
        if (notificationGV != null) {
            SimpleNotificationScheme notificationScheme = this.gvToNotificationScheme(notificationGV);
            contextMap.add((Object)NOTIFICATION_SCHEME, (Object)notificationScheme);
        }
        contextMap.add((Object)MANAGE_URL, (Object)this.tabUrlFactory.forNotifications());
        try {
            if (this.hasDefaultSMTPMailServer()) {
                String projectEmail = this.providerUtils.getProject().getEmail();
                String defaultEmail = this.getDefaultEmail();
                contextMap.add((Object)HAS_CONFIGURED_MAIL_SERVER, (Object)true);
                if (projectEmail != null) {
                    contextMap.add((Object)PROJECT_EMAIL, (Object)projectEmail);
                } else if (defaultEmail != null) {
                    contextMap.add((Object)PROJECT_EMAIL, (Object)defaultEmail);
                }
            }
        }
        catch (MailException e) {
            throw new RuntimeException(e);
        }
        return contextMap.toMap();
    }

    private SimpleNotificationScheme gvToNotificationScheme(GenericValue notificationGV) {
        return new SimpleNotificationScheme(notificationGV.getString("id"), notificationGV.getString("description"), notificationGV.getString("name"));
    }

    private boolean hasDefaultSMTPMailServer() throws MailException {
        return MailFactory.getServerManager().getDefaultSMTPMailServer() != null;
    }

    private String getDefaultEmail() throws MailException {
        SMTPMailServer defaultSMTPMailServer = this.mailServerManager.getDefaultSMTPMailServer();
        if (defaultSMTPMailServer != null) {
            return defaultSMTPMailServer.getDefaultFrom();
        }
        return null;
    }

    private GenericValue getProjectGV() {
        return this.providerUtils.getProject().getGenericValue();
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        return this.getClass().getName();
    }

    public static class SimpleNotificationScheme {
        private final String id;
        private final String description;
        private final String name;

        SimpleNotificationScheme(String id, String description, String name) {
            this.id = id;
            this.description = description;
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public String getDescription() {
            return this.description;
        }

        public String getName() {
            return this.name;
        }
    }
}

