/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.contextproviders;

import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.order.OrderFactory;
import com.atlassian.jira.util.collect.CompositeMap;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.ObjectMapper;

public class IssueTypeConfigContextProvider
implements CacheableContextProvider {
    private static final String ISSUE_TYPES_DATA_KEY = "issueTypesData";
    private final OrderFactory orderFactory;
    private ObjectMapper objectMapper;

    public IssueTypeConfigContextProvider(OrderFactory orderFactory) {
        this.orderFactory = orderFactory;
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        return this.getClass().getName();
    }

    public void init(Map<String, String> params) {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        Project project = (Project)context.get("project");
        List<IssueTypeConfigData> issueTypeConfigDatas = this.getIssueTypeLinks(project);
        try {
            ImmutableMap newContext = ImmutableMap.of((Object)ISSUE_TYPES_DATA_KEY, (Object)this.getObjectMapper().writeValueAsString(issueTypeConfigDatas));
            return CompositeMap.of((Map)newContext, context);
        }
        catch (IOException e) {
            throw new RuntimeException("An error occurred while parsing the issue types to a JSON string", e);
        }
    }

    private List<IssueTypeConfigData> getIssueTypeLinks(Project project) {
        ArrayList issueTypeConfigDatas = Lists.newArrayList();
        for (IssueType issueType : project.getIssueTypes()) {
            issueTypeConfigDatas.add(new IssueTypeConfigData(issueType));
        }
        return Ordering.from(this.orderFactory.createStringComparator()).onResultOf(IssueTypeConfigData.GET_NAME_FUNC).immutableSortedCopy((Iterable)issueTypeConfigDatas);
    }

    private ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
        }
        return this.objectMapper;
    }

    public static class IssueTypeConfigData {
        private static Function<IssueTypeConfigData, String> GET_NAME_FUNC = new Function<IssueTypeConfigData, String>(){

            public String apply(IssueTypeConfigData input) {
                return input.getName();
            }
        };
        @JsonProperty
        private String id;
        @JsonProperty
        private String name;

        public IssueTypeConfigData(IssueType issueType) {
            this.id = issueType.getId();
            this.name = issueType.getNameTranslation();
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

